/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntrySerializer;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.LocalEntryRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class LocalEntryStore
extends AbstractStore<Entry> {
    public LocalEntryStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new LocalEntryRegistryStore(registry, configName);
        }
    }

    @Override
    protected String getFileName(Entry entry) {
        return entry.getFileName();
    }

    @Override
    protected Entry getObjectToPersist(String name, SynapseConfiguration config) {
        return (Entry)config.getDefinedEntries().get(name);
    }

    @Override
    protected OMElement saveToFile(Entry entry, SynapseConfiguration synapseConfiguration) {
        try {
            return this.serializer.serializeLocalEntry((Object)entry, synapseConfiguration, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the local entry: " + entry.getKey() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(Entry entry) {
        return EntrySerializer.serializeEntry((Entry)entry, null);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File entriesDir = new File(this.configPath, "local-entries");
        if (!entriesDir.exists()) {
            return;
        }
        File entryFile = new File(entriesDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(entryFile.getAbsolutePath());
        entryFile.delete();
    }
}

