/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.configurations;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInformation;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConfigurationTracker {
    public static final Log log = LogFactory.getLog(ConfigurationTracker.class);
    public static final String CONFIGURATION_TRACKER = "configurationTracker";
    private UserRegistry registry = null;
    private ConfigurationInformation currentConfig = null;

    public ConfigurationTracker(UserRegistry configRegistry) {
        this.registry = configRegistry;
    }

    public String getCurrentConfigurationName() {
        return this.currentConfig.getName();
    }

    public synchronized void create(String configurationName, String description) throws RegistryException {
        if (!this.registry.resourceExists("repository/esb/esb-configurations")) {
            this.init();
        }
        try {
            this.registry.beginTransaction();
            Resource r = this.registry.newResource();
            r.setProperty("DESCRIPTION", description);
            r.setProperty("ACTIVE", "false");
            r.setProperty("CREATED", "false");
            this.registry.put("repository/esb/esb-configurations/" + configurationName, r);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
    }

    private void rollbackTransaction(Exception e) throws RegistryException {
        log.error((Object)"Error occurred accessing registry", (Throwable)e);
        this.registry.rollbackTransaction();
    }

    public synchronized void activate(String configurationName) throws RegistryException {
        this.currentConfig.setActive(false);
        this.updateConfiguration(this.currentConfig);
        ConfigurationInformation newConfigurationInfo = this.loadConfigurationInfo(configurationName);
        newConfigurationInfo.setActive(true);
        this.updateConfiguration(newConfigurationInfo);
        this.currentConfig = newConfigurationInfo;
        this.currentConfig.setCreated(true);
    }

    public void delete(String configurationName) throws RegistryException {
        try {
            this.registry.beginTransaction();
            String resourceName = "repository/esb/esb-configurations/" + configurationName;
            if (this.registry.resourceExists(resourceName)) {
                this.registry.delete(resourceName);
            }
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
    }

    public List<ConfigurationInformation> getConfigurationList() throws RegistryException {
        if (!this.registry.resourceExists("repository/esb/esb-configurations")) {
            this.init();
        }
        ArrayList<ConfigurationInformation> configList = new ArrayList<ConfigurationInformation>();
        Resource resource = this.registry.get("repository/esb/esb-configurations");
        if (resource instanceof Collection) {
            Collection c = (Collection)resource;
            for (String rName : c.getChildren()) {
                Resource r = this.registry.get(rName);
                String description = r.getProperty("DESCRIPTION");
                String name = rName.substring("repository/esb/esb-configurations".length() + 2);
                String active = r.getProperty("ACTIVE");
                String created = r.getProperty("CREATED");
                ConfigurationInformation config = new ConfigurationInformation(name);
                config.setDescription(description);
                if (active != null && (active.equalsIgnoreCase("TRUE") || active.equals("FALSE"))) {
                    config.setActive(Boolean.parseBoolean(active));
                }
                config.setCreated(Boolean.parseBoolean(created));
                configList.add(config);
            }
        }
        return configList;
    }

    public boolean isConfigurationCreated(String name) throws RegistryException {
        Resource resource = this.registry.get("repository/esb/esb-configurations/" + name);
        String created = resource.getProperty("CREATED");
        if (created != null) {
            if (created.equalsIgnoreCase("FALSE")) {
                return false;
            }
            if (created.equalsIgnoreCase("TRUE")) {
                return true;
            }
        }
        return false;
    }

    public boolean isConfigurationExists(String name) throws RegistryException {
        return this.registry.resourceExists("repository/esb/esb-configurations/" + name);
    }

    public void init() throws RegistryException {
        if (!this.registry.resourceExists("repository/esb/esb-configurations")) {
            this.createConfigurationsCollection();
            this.persistConfiguration("default");
        }
        List<ConfigurationInformation> configurationInformations = this.getConfigurationList();
        for (ConfigurationInformation info : configurationInformations) {
            if (!info.isActive()) continue;
            this.currentConfig = info;
        }
        if (this.currentConfig == null) {
            this.currentConfig = configurationInformations.get(0);
            log.warn((Object)("No Current configurations found. Activating the :" + this.currentConfig.getName()));
        }
    }

    public void update(String name, boolean created) throws RegistryException {
        ConfigurationInformation configurationInformation = this.loadConfigurationInfo(name);
        configurationInformation.setCreated(created);
        this.updateConfiguration(configurationInformation);
    }

    public ConfigurationInformation getConfigurationInformation(String name) throws RegistryException {
        return this.loadConfigurationInfo(name);
    }

    private void createConfigurationsCollection() throws RegistryException {
        try {
            this.registry.beginTransaction();
            Collection c = this.registry.newCollection();
            this.registry.put("repository/esb/esb-configurations", (Resource)c);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
    }

    private void updateConfiguration(ConfigurationInformation configurationInformation) throws RegistryException {
        try {
            this.registry.beginTransaction();
            Resource r = this.registry.get("repository/esb/esb-configurations/" + configurationInformation.getName());
            r.setProperty("DESCRIPTION", configurationInformation.getDescription());
            r.setProperty("ACTIVE", Boolean.toString(configurationInformation.isActive()));
            r.setProperty("CREATED", Boolean.toString(configurationInformation.isCreated()));
            this.registry.delete("repository/esb/esb-configurations/" + configurationInformation.getName());
            this.registry.put("repository/esb/esb-configurations/" + configurationInformation.getName(), r);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
    }

    private void persistConfiguration(String configName) throws RegistryException {
        this.registry.beginTransaction();
        try {
            Resource r = this.registry.newResource();
            r.setProperty("DESCRIPTION", "Default Configuration");
            r.setProperty("ACTIVE", "true");
            r.setProperty("CREATED", "true");
            this.registry.put("repository/esb/esb-configurations/" + configName, r);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
    }

    private ConfigurationInformation loadConfigurationInfo(String configName) throws RegistryException {
        ConfigurationInformation configurationInformation = null;
        try {
            this.registry.beginTransaction();
            Resource r = this.registry.get("repository/esb/esb-configurations/" + configName);
            String description = r.getProperty("DESCRIPTION");
            String active = r.getProperty("ACTIVE");
            String created = r.getProperty("CREATED");
            configurationInformation = new ConfigurationInformation(configName);
            configurationInformation.setActive(Boolean.parseBoolean(active));
            configurationInformation.setCreated(Boolean.parseBoolean(created));
            configurationInformation.setDescription(description);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction(e);
        }
        return configurationInformation;
    }
}

