/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.EndpointRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class EndpointStore
extends AbstractStore<Endpoint> {
    public EndpointStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new EndpointRegistryStore(registry, configName);
        }
    }

    @Override
    protected String getFileName(Endpoint endpoint) {
        if (endpoint instanceof AbstractEndpoint) {
            return endpoint.getFileName();
        }
        return null;
    }

    @Override
    protected Endpoint getObjectToPersist(String name, SynapseConfiguration config) {
        return (Endpoint)config.getDefinedEndpoints().get(name);
    }

    @Override
    protected OMElement saveToFile(Endpoint endpoint, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeEndpoint(endpoint, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the endpoint: " + endpoint.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(Endpoint endpoint) {
        return EndpointSerializer.getElementFromEndpoint((Endpoint)endpoint);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File endpointsDir = new File(this.configPath, "endpoints");
        if (!endpointsDir.exists()) {
            return;
        }
        File endpointFile = new File(endpointsDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(endpointFile.getAbsolutePath());
        endpointFile.delete();
    }
}

