/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.mediation.registry.RegistryServiceHolder;
import org.wso2.carbon.mediation.registry.persistence.PersistenceManager;
import org.wso2.carbon.mediation.registry.services.SynapseRegistryService;
import org.wso2.carbon.mediation.registry.services.SynapseRegistryServiceImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

@Component(name="mediation.registry", immediate=true)
public class SynapseRegistryServiceComponent {
    private static Log log = LogFactory.getLog(SynapseRegistryServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        ctxt.getBundleContext().registerService(SynapseRegistryService.class.getName(), (Object)new SynapseRegistryServiceImpl(), null);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the SynapseRegistry initialization process");
        }
        RegistryServiceHolder.getInstance().setRegistryService(registryService);
        try {
            PersistenceManager.getInstance().setRegistry((Registry)registryService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Error while accessing the registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the SynapseRegistry");
        }
        RegistryServiceHolder.getInstance().setRegistryService(null);
        PersistenceManager.getInstance().setRegistry(null);
    }
}

