/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.registry.persistence.dao.RegistryEntryDAO;
import org.wso2.carbon.mediation.registry.persistence.dataobject.RegistryEntryDO;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PersistenceManager {
    private static final PersistenceManager PERSISTENCE_MANAGER = new PersistenceManager();
    private static final Log log = LogFactory.getLog(PersistenceManager.class);
    private Registry registry;

    private PersistenceManager() {
    }

    public static PersistenceManager getInstance() {
        return PERSISTENCE_MANAGER;
    }

    public void addRegistryEntry(RegistryEntryDO registryEntryDO) {
        new RegistryEntryDAO(this.registry).addRegistryEntry(registryEntryDO);
    }

    public void updateRegistryEntry(RegistryEntryDO registryEntryDO) {
        new RegistryEntryDAO(this.registry).updateRegistryEntry(registryEntryDO);
    }

    public void saveOrUpdateRegistryEntry(RegistryEntryDO registryEntryDO) {
        new RegistryEntryDAO(this.registry).saveOrUpdateRegistryEntry(registryEntryDO);
    }

    public RegistryEntryDO getRegistryEntry(String key) {
        return new RegistryEntryDAO(this.registry).getRegistryEntry(key);
    }

    public void deleteRegistryEntry(String key) {
        new RegistryEntryDAO(this.registry).deleteRegistryEntry(key);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
        if (registry != null) {
            try {
                if (!registry.resourceExists("/repository/esb/registry")) {
                    CollectionImpl collection = new CollectionImpl();
                    collection.setPath("/repository/esb/registry");
                    registry.put("/repository/esb/registry", (Resource)collection);
                }
            }
            catch (RegistryException e) {
                PersistenceManager.handleException("Error during initiating 'PersistenceManager'", e);
            }
        }
    }

    private static void handleException(String msg, Throwable throwable) {
        log.error((Object)msg, throwable);
        throw new RuntimeException(msg, throwable);
    }
}

