/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry.persistence.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.registry.persistence.dataobject.BaseDO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public abstract class BaseDAO {
    protected Log log = LogFactory.getLog(BaseDAO.class);
    private Registry registry;

    public BaseDAO(Registry registry) {
        this.registry = registry;
    }

    public void create(String path, BaseDO baseDO) {
        Resource resource = this.createResource(path);
        this.populateResource(resource, baseDO);
    }

    public void update(String path, BaseDO baseDO) {
        Resource resource = this.getResource(path);
        if (resource != null) {
            this.populateResource(resource, baseDO);
            this.setResource(resource);
        }
    }

    public void delete(String path) {
        this.deleteResource(path);
    }

    public BaseDO get(String path) {
        Resource resource = this.getResource(path);
        if (resource != null) {
            return this.populateDataObject(resource);
        }
        return null;
    }

    public abstract void populateResource(Resource var1, BaseDO var2);

    public abstract BaseDO populateDataObject(Resource var1);

    private String getCorrectPath(String path) {
        if (path == null) {
            return path;
        }
        String tempPath = path;
        if (path.endsWith("/")) {
            tempPath = path.substring(0, path.lastIndexOf("/"));
        }
        if (!tempPath.startsWith("/")) {
            tempPath = "/" + tempPath;
        }
        return "/repository/esb/registry" + tempPath;
    }

    private Resource createResource(String path) {
        try {
            String resolvedPath = this.getCorrectPath(path);
            if (!this.registry.resourceExists(resolvedPath)) {
                ResourceImpl resource = new ResourceImpl();
                resource.setPath(resolvedPath);
                return resource;
            }
        }
        catch (RegistryException e) {
            this.handleException("Unable to create a Resource in path : " + path, e);
        }
        return null;
    }

    private void setResource(Resource resource) {
        try {
            this.registry.put(resource.getPath(), resource);
        }
        catch (RegistryException e) {
            this.handleException("Error when setting a resource in the path : " + resource.getPath(), e);
        }
    }

    private Resource getResource(String path) {
        try {
            String resolvedPath = this.getCorrectPath(path);
            if (this.registry.resourceExists(resolvedPath)) {
                return this.registry.get(resolvedPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error when setting a resource in the path : " + path, e);
        }
        return null;
    }

    private void deleteResource(String path) {
        try {
            String resolvedPath = this.getCorrectPath(path);
            if (this.registry.resourceExists(resolvedPath)) {
                this.registry.delete(resolvedPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error when deleting a resource at path :" + path, e);
        }
    }

    protected void handleException(String msg, Throwable throwable) {
        this.log.error((Object)msg, throwable);
        throw new RuntimeException(msg, throwable);
    }

    protected void handleException(String msg) {
        this.log.error((Object)msg);
        throw new RuntimeException(msg);
    }
}

