/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.internal;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sequences.SequenceDeploymentInterceptor;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.internal.ConfigHolder;
import org.wso2.carbon.sequences.services.SequenceAdmin;
import org.wso2.carbon.sequences.services.SequenceAdminService;
import org.wso2.carbon.sequences.services.SequenceDeployerService;
import org.wso2.carbon.sequences.services.SequenceDeployerServiceImpl;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.sequences", immediate=true)
public class SequenceEditorServiceComponent
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(SequenceEditorServiceComponent.class);
    private SynapseEnvironment synapseEnvironment;
    private boolean activated = false;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bndCtx = context.getBundleContext();
            bndCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)this, null);
            bndCtx.registerService(SequenceDeployerService.class.getName(), (Object)new SequenceDeployerServiceImpl(), null);
            bndCtx.registerService(SequenceAdminService.class.getName(), (Object)new SequenceAdminService(), null);
            bndCtx.registerService(SequenceAdmin.class.getName(), (Object)new SequenceAdmin(), null);
            SynapseEnvironmentService synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(-1234);
            this.registerDeployer(ConfigHolder.getInstance().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sequence Admin bundle is activated ");
            }
            this.activated = true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Sequence Admin bundle ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = ConfigHolder.getInstance().getSynapseEnvironmentServices().entrySet();
        for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
            this.unregisterDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
        }
    }

    private void unregisterDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
            String sequencesDirPath = synapseConfigPath + File.separator + "sequences";
            deploymentEngine.removeDeployer(sequencesDirPath, "xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) throws SequenceEditorException {
        SynapseConfiguration synCfg = synapseEnvironment.getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synCfg.getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String sequenceDirPath = synapseConfigPath + File.separator + "sequences";
        for (SequenceMediator seq : synCfg.getDefinedSequences().values()) {
            if (seq.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(sequenceDirPath + File.separator + seq.getFileName());
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            deploymentEngine.addDeployer((Deployer)new SequenceDeploymentInterceptor(), sequenceDirPath, "xml");
        }
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
        ConfigHolder.getInstance().setConfigurationContextService(cfgCtxService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    @Reference(name="synapse.config.service", service=SynapseConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseConfigurationService")
    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    @Reference(name="synapse.env.service", service=SynapseEnvironmentService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseEnvironmentService")
    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        boolean alreadyCreated = ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(synapseEnvironmentService.getTenantId());
        ConfigHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
        if (this.activated && !alreadyCreated) {
            try {
                this.registerDeployer(synapseEnvironmentService.getConfigurationContext().getAxisConfiguration(), synapseEnvironmentService.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Sequence Admin bundle is activated ");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Failed to activate Sequence Admin bundle ", e);
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
    }

    @Reference(name="dependency.mgt.service", service=DependencyManagementService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetDependencyManager")
    protected void setDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service bound to the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(dependencyMgr);
    }

    protected void unsetDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service unbound from the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(null);
    }

    @Reference(name="synapse.registrations.service", service=SynapseRegistrationsService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseRegistrationsService")
    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(tenantId)) {
            SynapseEnvironment env = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment();
            ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unregisterDeployer(axisConfig, env);
            }
        }
    }

    public void createdConfigurationContext(ConfigurationContext configContext) {
        SynapseEnvironmentService synEnvService;
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (axisConfig != null && (synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId)) != null) {
            try {
                this.registerDeployer(axisConfig, synEnvService.getSynapseEnvironment());
            }
            catch (SequenceEditorException e) {
                log.error((Object)"Error while initializing SequenceEditor Admin", (Throwable)e);
            }
        }
    }
}

