/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.services;

import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.sequences.SequenceAdminUtil;
import org.wso2.carbon.sequences.common.SequenceEditorException;

public class SequenceAdminService {
    private static final Log log = LogFactory.getLog(SequenceAdminService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        Lock lock = SequenceAdminUtil.getLock();
        try {
            lock.lock();
            SynapseConfiguration synCfg = SequenceAdminUtil.getSynapseConfigFromConfigCtx();
            SequenceMediator sequence = (SequenceMediator)synCfg.getDefinedSequences().get(sequenceName);
            if (sequence != null && sequence.getArtifactContainerName() == null) {
                synCfg.removeSequence(sequenceName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = SequenceAdminUtil.getMediationPersistenceManager();
                    pm.deleteItem(sequenceName, sequence.getFileName(), 1);
                }
            } else {
                this.handleException("No defined sequence with name " + sequenceName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
        finally {
            lock.unlock();
        }
    }

    public void addSequence(OMElement sequenceElement) throws SequenceEditorException {
        Lock lock = SequenceAdminUtil.getLock();
        try {
            lock.lock();
            if (sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                if ("".equals(sequenceName) || null == sequenceName) {
                    this.handleException("sequence name is required.");
                }
                SynapseConfiguration config = SequenceAdminUtil.getSynapseConfigFromConfigCtx();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding sequence : " + sequenceName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(sequenceName) != null) {
                    this.handleException("The name '" + sequenceName + "' is already used within the configuration - a sequence or local entry with this name already exists");
                } else {
                    SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)config, (OMElement)sequenceElement, (Properties)SequenceAdminUtil.getSynapseConfigFromConfigCtx().getProperties());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added sequence : " + sequenceName + " to the configuration"));
                    }
                    SequenceMediator seq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    seq.setFileName(ServiceBusUtils.generateFileName((String)sequenceName));
                    seq.init(SequenceAdminUtil.getSynapseEnvironmentFromConfigCtx());
                    this.persistSequence(seq);
                }
            } else {
                this.handleException("Invalid sequence definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Error adding sequence : " + fault.getMessage(), fault);
        }
        catch (Error error) {
            throw new SequenceEditorException("Unexpected error occured while adding the sequence : " + error.getMessage(), (Throwable)error);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isExistingSequence(String sequenceName) throws SequenceEditorException {
        SynapseConfiguration config = SequenceAdminUtil.getSynapseConfiguration();
        return config.getLocalRegistry().get(sequenceName) != null;
    }

    public boolean isExistingSequenceForTenant(String sequenceName, String tenantDomain) throws SequenceEditorException {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
        return this.isExistingSequence(sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getSequence(String sequenceName) throws SequenceEditorException {
        Lock lock = SequenceAdminUtil.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = SequenceAdminUtil.getSynapseConfigFromConfigCtx();
            if (synapseConfiguration.getSequence(sequenceName) != null) {
                OMElement oMElement = MediatorSerializerFinder.getInstance().getSerializer(synapseConfiguration.getSequence(sequenceName)).serializeMediator(null, synapseConfiguration.getSequence(sequenceName));
                return oMElement;
            }
            this.handleException("Sequence with the name " + sequenceName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + sequenceName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the sequence", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws SequenceEditorException {
        log.error((Object)message, cause);
        throw new SequenceEditorException(message, cause);
    }

    private void handleException(String message) throws SequenceEditorException {
        log.error((Object)message);
        throw new SequenceEditorException(message);
    }

    private void persistSequence(SequenceMediator sequence) throws SequenceEditorException {
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            MediationPersistenceManager pm = SequenceAdminUtil.getMediationPersistenceManager();
            if (pm == null) {
                this.handleException("Cannot Persist sequence because persistence manager is null, probably persistence is disabled");
            }
            pm.saveItem(sequence.getName(), 1);
        }
    }
}

