/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.JarInfo;
import org.wso2.carbon.server.util.PatchInfo;
import org.wso2.carbon.server.util.PatchUtils;
import org.wso2.carbon.server.util.Utils;

public class PatchInstaller
implements CarbonLaunchExtension {
    private static final Logger log = Logger.getLogger(PatchInstaller.class.getName());

    @Override
    public void perform() {
        File carbonComponentDir = Utils.getCarbonComponentRepo();
        String patchesPath = System.getProperty("carbon.patches.dir.path");
        String servicepackPaths = System.getProperty("carbon.servicepacks.dir.path");
        File plugins = new File(carbonComponentDir, "plugins");
        File servicepackDir = servicepackPaths == null ? new File(carbonComponentDir, "servicepacks") : new File(servicepackPaths);
        File patchesDir = patchesPath == null ? new File(carbonComponentDir, "patches") : new File(patchesPath);
        File prePatchedDirFile = new File(PatchUtils.getMetaDirectory(), "prePatchedDir.txt");
        try {
            PatchInfo patchInfo = PatchUtils.processPatches(prePatchedDirFile, servicepackDir, patchesDir);
            boolean patchesChanged = patchInfo.isPatchesChanged();
            Map<String, JarInfo> latestPatchedJar = PatchUtils.getMostLatestJarsInServicepackAndPatches(servicepackDir, patchesDir);
            if (!patchesChanged) {
                patchesChanged = PatchUtils.checkUpdatedJars(latestPatchedJar);
            }
            if (patchesChanged) {
                log.log(Level.INFO, "Patch changes detected");
                PatchUtils.applyServicepacksAndPatches(servicepackDir, patchesDir, plugins);
            }
            PatchUtils.checkMD5Checksum(latestPatchedJar, plugins, patchesChanged);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error occurred while applying patches", e);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occurred while verifying md5 checksum of patched jars", e);
        }
    }
}

