/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class SystemBundleExtensionCreator
implements CarbonLaunchExtension {
    private static final String EXTENSIONS_DIR;
    private static final String EXTENSION_PREFIX = "org.wso2.carbon.framework.extension.";

    @Override
    public void perform() {
        String dropinsPath = System.getProperty("carbon.dropins.dir.path");
        File dropinsFolder = dropinsPath == null ? new File(Utils.getCarbonComponentRepo(), "dropins") : new File(dropinsPath);
        File dir = Utils.getBundleDirectory(EXTENSIONS_DIR);
        File[] files = dir.listFiles(new Utils.JarFileFilter());
        if (files != null) {
            for (File file : files) {
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("Fragment-Host", "system.bundle; extension:=framework");
                    Utils.createBundle(file, dropinsFolder, mf, EXTENSION_PREFIX);
                }
                catch (IOException e) {
                    System.err.println("Cannot create framework extension bundle from jar file " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        String extensions = System.getProperty("carbon.extensions.dir.path");
        if (extensions == null) {
            String componentsPath = System.getProperty("carbon.components.dir.path");
            if (componentsPath == null) {
                EXTENSIONS_DIR = Paths.get("repository", "components", "extensions").toString();
            } else {
                Path path = Paths.get(componentsPath, "extensions");
                EXTENSIONS_DIR = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(path).toString();
            }
        } else {
            EXTENSIONS_DIR = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(extensions, new String[0])).toString();
        }
    }
}

