/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.util;

public class BundleInfoLine {
    String bundleSymbolicName;
    String bundleVersion;
    String bundlePath;
    int startLevel;
    boolean isFragment;
    boolean isFromDropins;

    public BundleInfoLine(String bundleSymbolicName, String bundleVersion, String bundlePath, int startLevel, boolean isFragment) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.bundleVersion = bundleVersion;
        this.bundlePath = bundlePath;
        this.startLevel = startLevel;
        this.isFragment = isFragment;
        this.isFromDropins = bundlePath.contains("dropins/");
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setFragment(boolean fragment) {
        this.isFragment = fragment;
    }

    public boolean isFromDropins() {
        return this.isFromDropins;
    }

    public static BundleInfoLine getInstance(String bundleInfoLineStr) throws Exception {
        String[] parts = bundleInfoLineStr.split(",");
        if (parts.length != 5) {
            throw new RuntimeException("Invalid line in the bundles.info file: " + bundleInfoLineStr);
        }
        return new BundleInfoLine(parts[0].trim(), parts[1].trim(), parts[2].trim(), Integer.parseInt(parts[3].trim()), !Boolean.parseBoolean(parts[4].trim()));
    }

    public String toString() {
        return this.bundleSymbolicName + "," + this.bundleVersion + "," + this.bundlePath + "," + this.startLevel + "," + Boolean.toString(!this.isFragment);
    }
}

