/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.context.internal.CarbonContextDataHolder;
import org.wso2.carbon.context.internal.OSGiDataHolder;
import org.wso2.carbon.queuing.CarbonQueue;
import org.wso2.carbon.queuing.CarbonQueueManager;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.utils.CarbonUtils;

public class CarbonContext {
    private static final Log log = LogFactory.getLog(CarbonContext.class);
    private static List<String> allowedOSGiServices = new ArrayList<String>();
    private CarbonContextDataHolder carbonContextHolder = null;
    private static OSGiDataHolder dataHolder = OSGiDataHolder.getInstance();
    private static final String OSGI_SERVICES_PROPERTIES_FILE = "carboncontext-osgi-services.properties";

    protected CarbonContext(CarbonContextDataHolder carbonContextHolder) {
        this.carbonContextHolder = carbonContextHolder;
    }

    protected CarbonContextDataHolder getCarbonContextDataHolder() {
        return this.carbonContextHolder;
    }

    public static CarbonContext getThreadLocalCarbonContext() {
        return new CarbonContext(CarbonContextDataHolder.getThreadLocalCarbonContextHolder());
    }

    public int getTenantId() {
        CarbonBaseUtils.checkSecurity();
        return this.getCarbonContextDataHolder().getTenantId();
    }

    public String getUsername() {
        return this.getCarbonContextDataHolder().getUsername();
    }

    public String getUserId() {
        return this.getCarbonContextDataHolder().getUserId();
    }

    public String getTenantDomain() {
        return this.getCarbonContextDataHolder().getTenantDomain();
    }

    public String getOrganizationId() {
        return this.getCarbonContextDataHolder().getOrganizationId();
    }

    public Registry getRegistry(RegistryType type) {
        int tenantId = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return CarbonContext.this.getTenantId();
            }
        });
        switch (type) {
            case USER_CONFIGURATION: {
                if (tenantId != -1) {
                    try {
                        Registry registry = dataHolder.getRegistryService().getConfigUserRegistry(this.getUsername(), tenantId);
                        return registry;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            case SYSTEM_CONFIGURATION: {
                if (tenantId != -1) {
                    try {
                        Registry registry = dataHolder.getRegistryService().getConfigSystemRegistry(tenantId);
                        return registry;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            case USER_GOVERNANCE: {
                if (tenantId != -1) {
                    try {
                        Registry registry = dataHolder.getRegistryService().getGovernanceUserRegistry(this.getUsername(), tenantId);
                        return registry;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            case SYSTEM_GOVERNANCE: {
                if (tenantId != -1) {
                    try {
                        Registry registry = dataHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
                        return registry;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            case LOCAL_REPOSITORY: {
                if (tenantId == -1) break;
                try {
                    Registry registry = dataHolder.getRegistryService().getLocalRepository(tenantId);
                    return registry;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public UserRealm getUserRealm() {
        return this.getCarbonContextDataHolder().getUserRealm();
    }

    @Deprecated
    public CarbonQueue<?> getQueue(String name) {
        return CarbonQueueManager.getInstance().getQueue(name);
    }

    public Context getJNDIContext(Hashtable properties) throws NamingException {
        return new InitialContext(properties);
    }

    public Context getJNDIContext() throws NamingException {
        return new InitialContext();
    }

    public String[] discover(URI[] scopes) {
        try {
            return CarbonContextDataHolder.getDiscoveryServiceProvider().probe(null, scopes, null, this.getCarbonContextDataHolder().getTenantId());
        }
        catch (Exception ignored) {
            return new String[0];
        }
    }

    @Deprecated
    public Object getOSGiService(Class clazz) {
        return this.getOSGiService(clazz, null);
    }

    @Deprecated
    public List<Object> getOSGiServices(Class clazz) {
        return this.getOSGiServices(clazz, null);
    }

    public Object getOSGiService(Class clazz, Hashtable<String, String> props) {
        final Class osgiServiceClass = clazz;
        final Hashtable<String, String> properties = props;
        if (allowedOSGiServices.contains(clazz.getName())) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    try (ServiceTracker serviceTracker = null;){
                        BundleContext bundleContext = dataHolder.getBundleContext();
                        Filter osgiFilter = CarbonContext.this.createFilter(bundleContext, osgiServiceClass, properties);
                        serviceTracker = new ServiceTracker(bundleContext, osgiFilter, null);
                        serviceTracker.open();
                        Object object = serviceTracker.getServices()[0];
                        return object;
                    }
                    return null;
                }
            });
        }
        throw new SecurityException("OSGi service " + clazz.getName() + " cannot be accessed via CarbonContext");
    }

    public List<Object> getOSGiServices(Class clazz, Hashtable<String, String> props) {
        final Class osgiServiceClass = clazz;
        final Hashtable<String, String> properties = props;
        if (allowedOSGiServices.contains(clazz.getName())) {
            return AccessController.doPrivileged(new PrivilegedAction<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Object> run() {
                    ArrayList<Object> services = new ArrayList<Object>();
                    try (ServiceTracker serviceTracker = null;){
                        BundleContext bundleContext = dataHolder.getBundleContext();
                        Filter osgiFilter = CarbonContext.this.createFilter(bundleContext, osgiServiceClass, properties);
                        serviceTracker = new ServiceTracker(bundleContext, osgiFilter, null);
                        serviceTracker.open();
                        Collections.addAll(services, serviceTracker.getServices());
                    }
                    return services;
                }
            });
        }
        new SecurityException("OSGi service " + clazz.getName() + " cannot be accessed via CarbonContext");
        return new ArrayList<Object>();
    }

    private static String getOSGiServicesConfigFilePath() {
        String etcDir = CarbonUtils.getEtcCarbonConfigDirPath();
        return etcDir + File.separator + OSGI_SERVICES_PROPERTIES_FILE;
    }

    protected Filter createFilter(BundleContext bundleContext, Class clazz, Hashtable<String, String> props) throws InvalidSyntaxException {
        StringBuilder buf = new StringBuilder();
        buf.append("(objectClass=" + clazz.getName() + ")");
        if (props != null && !props.isEmpty()) {
            buf.insert(0, "(&");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                buf.append("(" + entry.getKey() + "=" + entry.getValue() + ")");
            }
            buf.append(")");
        }
        return bundleContext.createFilter(buf.toString());
    }

    public String getApplicationName() {
        return this.getCarbonContextDataHolder().getApplicationName();
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream fileInputStream = null;
        String osgiServicesFilename = CarbonContext.getOSGiServicesConfigFilePath();
        try {
            Properties osgiServices = new Properties();
            File configFile = new File(osgiServicesFilename);
            if (configFile.exists()) {
                fileInputStream = new FileInputStream(configFile);
                osgiServices.load(fileInputStream);
                Set<String> propNames = osgiServices.stringPropertyNames();
                for (String propName : propNames) {
                    allowedOSGiServices.add(osgiServices.getProperty(propName));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot load " + osgiServicesFilename), (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close FileInputStream of file " + osgiServicesFilename), (Throwable)e);
                }
            }
        }
    }
}

