/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.DeploymentFileDataWrapper;
import org.wso2.carbon.utils.deployment.GhostAwareAxis2ServiceDeployer;

public class GhostArtifactRepository {
    private Map<String, DeploymentFileDataWrapper> deploymentFileDataList = new HashMap<String, DeploymentFileDataWrapper>();

    public GhostArtifactRepository(AxisConfiguration axisConfiguration) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
        deploymentEngine.addDeployer((Deployer)new GhostAwareAxis2ServiceDeployer(), CarbonUtils.getAxis2ServicesDir(axisConfiguration), ".aar");
    }

    public DeploymentFileDataWrapper getDeploymentFileData(String fileName) {
        File deploymentFile = new File(fileName);
        fileName = deploymentFile.getPath();
        return this.deploymentFileDataList.get(fileName);
    }

    public void addDeploymentFileData(DeploymentFileData deploymentFileData, boolean isGhost) {
        File deploymentFile = new File(deploymentFileData.getAbsolutePath());
        String fileName = deploymentFile.getPath();
        DeploymentFileDataWrapper dfdWrapper = new DeploymentFileDataWrapper(deploymentFileData, isGhost);
        this.deploymentFileDataList.put(fileName, dfdWrapper);
    }

    public DeploymentFileDataWrapper removeDeploymentFileData(String filePath) {
        return this.deploymentFileDataList.remove(filePath);
    }
}

