/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.database.utils.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.wso2.carbon.database.utils.jdbc.ExecuteCallable;
import org.wso2.carbon.database.utils.jdbc.JdbcConstants;
import org.wso2.carbon.database.utils.jdbc.JdbcUtils;
import org.wso2.carbon.database.utils.jdbc.QueryFilter;
import org.wso2.carbon.database.utils.jdbc.RowMapper;
import org.wso2.carbon.database.utils.jdbc.Template;
import org.wso2.carbon.database.utils.jdbc.TransactionEntry;
import org.wso2.carbon.database.utils.jdbc.TransactionManager;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.database.utils.jdbc.exceptions.TransactionException;

public class JdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(JdbcTemplate.class);
    private static final String ID = "ID";
    private String driverName;
    private String productName;
    private DataSource dataSource;

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public <T, E extends Exception> T withTransaction(ExecuteCallable<T> callable) throws TransactionException, E {
        TransactionEntry transactionEntry = TransactionManager.getTransactionEntry();
        if (transactionEntry.getTransactionDepth() == 0) {
            try {
                Connection connection = this.dataSource.getConnection();
                transactionEntry.setAutoCommitState(connection.getAutoCommit());
                connection.setAutoCommit(false);
                transactionEntry.setConnection(connection);
            }
            catch (SQLException e) {
                throw new TransactionException(JdbcConstants.ErrorCodes.ERROR_CODE_GETTING_CONNECTION_FAILURE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_GETTING_CONNECTION_FAILURE.getErrorCode(), e);
            }
        }
        transactionEntry.incrementTransactionDepth();
        TransactionManager.setTransactionEntry(transactionEntry);
        try {
            T result = callable.get(new Template());
            transactionEntry.decrementTransactionDepth();
            if (transactionEntry.getTransactionDepth() == 0) {
                transactionEntry.getConnection().commit();
            }
            T t = result;
            return t;
        }
        catch (Throwable t) {
            this.logDebug("Could not commit the transaction.", t);
            transactionEntry.decrementTransactionDepth();
            if (transactionEntry.getTransactionDepth() == 0) {
                try {
                    transactionEntry.getConnection().rollback();
                }
                catch (SQLException e) {
                    this.logDebug("Could not rollback the transaction.", e, new Object[0]);
                    throw new TransactionException(JdbcConstants.ErrorCodes.ERROR_CODE_ROLLBACK_TRANSACTION_FAILURE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_ROLLBACK_TRANSACTION_FAILURE.getErrorCode(), e);
                }
            }
            throw new TransactionException(JdbcConstants.ErrorCodes.ERROR_CODE_COMMIT_TRANSACTION_FAILURE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_COMMIT_TRANSACTION_FAILURE.getErrorCode(), t);
        }
        finally {
            if (transactionEntry.getTransactionDepth() == 0) {
                try {
                    transactionEntry.getConnection().setAutoCommit(transactionEntry.getAutoCommitState());
                    transactionEntry.getConnection().close();
                    transactionEntry.setConnection(null);
                }
                catch (SQLException e) {
                    this.logDebug("Could not close the transaction.", e, new Object[0]);
                    throw new TransactionException(JdbcConstants.ErrorCodes.ERROR_CODE_CLOSE_CONNECTION_FAILURE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_CLOSE_CONNECTION_FAILURE.getErrorCode(), e);
                }
                TransactionManager.exitTransaction();
            }
        }
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(query, rowMapper, null);
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper, QueryFilter queryFilter) throws DataAccessException {
        ArrayList<T> result = new ArrayList<T>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                int i = 0;
                while (resultSet.next()) {
                    T row = rowMapper.mapRow(resultSet, i);
                    result.add(row);
                    ++i;
                }
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the Parameters are {}", e, query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return result;
    }

    public <T> T fetchSingleRecord(String query, RowMapper<T> rowMapper, QueryFilter queryFilter) throws DataAccessException {
        T result = null;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    result = rowMapper.mapRow(resultSet, 0);
                }
                if (!resultSet.isClosed() && resultSet.next()) {
                    this.logDebug("There are more records than one found for query: {} for the parameters {}", query, queryFilter);
                    throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_MORE_RECORDS_IN_SINGLE_FETCH.getErrorMessage() + query);
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the parameters are {}", e, query, rowMapper, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return result;
    }

    public void executeUpdate(String query, QueryFilter queryFilter) throws DataAccessException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            if (queryFilter != null) {
                queryFilter.filter(preparedStatement);
            }
            preparedStatement.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database update: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
    }

    /*
     * Exception decompiling
     */
    public int executeUpdate(String query) throws DataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> int executeInsert(String query, QueryFilter queryFilter, T bean, boolean fetchInsertedId) throws DataAccessException {
        try (Connection connection = this.dataSource.getConnection();){
            if (fetchInsertedId) {
                int resultId;
                String dbProductName = connection.getMetaData().getDatabaseProductName();
                try (PreparedStatement preparedStatement = connection.prepareStatement(query, new String[]{JdbcUtils.getConvertedAutoGeneratedColumnName(dbProductName, ID)});){
                    this.doInternalUpdate(queryFilter, preparedStatement);
                    this.logDebug("Mapping generated key (Auto Increment ID) to the object", new Object[0]);
                    try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                        if (!generatedKeys.next()) throw new SQLException(JdbcConstants.ErrorCodes.ERROR_CODE_AUTO_GENERATED_ID_FAILURE.getErrorMessage());
                        resultId = generatedKeys.getInt(1);
                        this.logDebug("Newly inserted ID (Auto Increment ID) is {} for the bean {} ", resultId, bean);
                    }
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                int n = resultId;
                return n;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                this.doInternalUpdate(queryFilter, preparedStatement);
            }
            if (connection.getAutoCommit()) return 0;
            connection.commit();
            return 0;
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorMessage() + query, JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorCode(), e);
        }
    }

    public <T> int executeBatchInsert(String query, QueryFilter queryFilter, T bean) throws DataAccessException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            this.doInternalBatchUpdate(queryFilter, preparedStatement);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, queryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + query, e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDriverName() throws DataAccessException {
        if (StringUtils.isNotBlank((String)this.driverName)) {
            return this.driverName;
        }
        try (Connection connection = this.dataSource.getConnection();){
            String string = this.driverName = connection.getMetaData().getDriverName();
            return string;
        }
        catch (SQLException e) {
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_GET_DB_TYPE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_GET_DB_TYPE.getErrorCode(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseProductName() throws DataAccessException {
        if (StringUtils.isNotBlank((String)this.productName)) {
            return this.productName;
        }
        try (Connection connection = this.dataSource.getConnection();){
            String string = this.productName = connection.getMetaData().getDatabaseProductName();
            return string;
        }
        catch (SQLException e) {
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_GET_DB_TYPE.getErrorMessage(), JdbcConstants.ErrorCodes.ERROR_CODE_GET_DB_TYPE.getErrorCode(), e);
        }
    }

    private int doInternalUpdate(QueryFilter queryFilter, PreparedStatement preparedStatement) throws SQLException, DataAccessException {
        if (queryFilter != null) {
            queryFilter.filter(preparedStatement);
        }
        return preparedStatement.executeUpdate();
    }

    private <T> void doInternalBatchUpdate(QueryFilter queryFilter, PreparedStatement preparedStatement) throws SQLException, DataAccessException {
        if (queryFilter != null) {
            queryFilter.filter(preparedStatement);
        }
        preparedStatement.executeBatch();
    }

    private void logDebug(String s, Object ... params) {
        this.logDebug(s, null, params);
    }

    private void logDebug(String s, Exception e, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormatter.arrayFormat((String)s, (Object[])params).getMessage(), (Throwable)e);
        }
    }
}

