/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class ValueInferrer {
    private static final Log log = LogFactory.getLog(ValueInferrer.class);

    private ValueInferrer() {
    }

    static Context infer(Context context, String inferConfigFilePath) throws ConfigParserException {
        Map<String, Object> inferredContext = ValueInferrer.infer(context.getTemplateData(), inferConfigFilePath);
        context.getTemplateData().clear();
        context.getTemplateData().putAll(inferredContext);
        return context;
    }

    static Map<String, Object> infer(Map<String, Object> context, String inferConfigFilePath) throws ConfigParserException {
        Map<String, Object> enrichedContext = ValueInferrer.readConfiguration(inferConfigFilePath);
        enrichedContext = ValueInferrer.getInferredValues(context, enrichedContext);
        enrichedContext.putAll(context);
        return enrichedContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> readConfiguration(String inferConfigFilePath) throws ConfigParserException {
        Gson gson = new Gson();
        try (FileInputStream fileInputStream = new FileInputStream(inferConfigFilePath);){
            InputStreamReader input = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            Map map = (Map)gson.fromJson((Reader)input, Map.class);
            return map;
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while reading inferring file", e);
        }
    }

    private static Map<String, Object> getInferredValues(Map<String, Object> configurationValues, Map<String, Object> inferringData) {
        LinkedHashMap<String, Object> inferredValues = new LinkedHashMap<String, Object>();
        if (configurationValues != null) {
            configurationValues.forEach((key, value) -> {
                Map inferringValues;
                String matchedKey = ValueInferrer.getMatchedKey(key, inferringData.keySet());
                if (StringUtils.isNotEmpty((String)matchedKey) && (inferringValues = (Map)inferringData.get(matchedKey)).containsKey(String.valueOf(value))) {
                    LinkedHashMap<Object, Object> valuesInferredByKey = new LinkedHashMap<Object, Object>((Map)inferringValues.get(String.valueOf(value)));
                    ValueInferrer.replaceReferences(matchedKey, key, valuesInferredByKey);
                    ValueInferrer.getRecursiveInferredValues(inferredValues, valuesInferredByKey, inferringData);
                    inferredValues.putAll(valuesInferredByKey);
                }
            });
        }
        for (Map.Entry entry : inferredValues.entrySet()) {
            Double value2;
            if (!(entry.getValue() instanceof Double) || (value2 = (Double)entry.getValue()).compareTo(Math.rint(value2)) != 0) continue;
            entry.setValue(value2.intValue());
        }
        return inferredValues;
    }

    private static void replaceReferences(String matchedKey, String s, Map<String, Object> valuesInferredByKey) {
        Map resolvedValues = ValueInferrer.getResolvedValues(s, matchedKey);
        new LinkedHashMap<String, Object>(valuesInferredByKey).forEach((key, value) -> {
            String resolvedKey = key;
            Object resolvedValue = value;
            for (Map.Entry entry : resolvedValues.entrySet()) {
                String s1 = (String)entry.getKey();
                String s2 = (String)entry.getValue();
                resolvedKey = resolvedKey.replaceAll(Pattern.quote(s1), s2);
                if (!(value instanceof String)) continue;
                resolvedValue = ((String)resolvedValue).replaceAll(Pattern.quote(s1), s2);
            }
            valuesInferredByKey.remove(key);
            valuesInferredByKey.put(resolvedKey, resolvedValue);
        });
    }

    private static void getRecursiveInferredValues(Map context, Map<Object, Object> valuesInferredByKey, Map<String, Object> inferringData) {
        valuesInferredByKey.forEach((key, value) -> {
            Map dataMap;
            String matchedKey = ValueInferrer.getMatchedKey((String)key, inferringData.keySet());
            if (StringUtils.isNotEmpty((String)matchedKey) && (dataMap = (Map)inferringData.get(matchedKey)).containsKey(value)) {
                Map inferredValues = (Map)dataMap.get(value);
                context.putAll(inferredValues);
                ValueInferrer.getRecursiveInferredValues(context, inferredValues, inferringData);
            }
        });
    }

    private static String getMatchedKey(String key, Set<String> inferredKeys) {
        if (inferredKeys.contains(key)) {
            return key;
        }
        for (String s : inferredKeys) {
            String matchedRegex = s.replaceAll("\\$[0-9]+", "\\\\w+");
            if (!key.matches(matchedRegex)) continue;
            return s;
        }
        return null;
    }

    private static Map getResolvedValues(String key, String matchedKey) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int l = 0;
        for (String s : matchedKey.split("\\.")) {
            if (s.matches("\\$[0-9]+")) {
                map.put(s, key.split("\\.")[l]);
            }
            ++l;
        }
        return map;
    }
}

