/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Axis2SynapseController;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.snmp.SynapseSNMPAgent;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.ClassMediatorDeployer;
import org.apache.synapse.deployers.ExtensionDeployer;
import org.wso2.micro.integrator.core.services.CarbonServerConfigurationService;
import org.wso2.micro.integrator.initializer.ServiceBusInitializer;

public class CarbonSynapseController
extends Axis2SynapseController {
    private static final Log log = LogFactory.getLog(CarbonSynapseController.class);
    private static final String PARAMETER_VALUE_TRUE = Boolean.toString(true);
    public static final String MULTI_TENANT_DISPATCHER_NAME = "MultitenantDispatcher";
    public static final String KEEP_SERVICE_HISTORY_PARAM = "keepServiceHistory";
    private String currentConfigurationName;
    private String synapseXMLLocation;
    private SynapseSNMPAgent snmpAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServerConfigurationInformation serverConfigurationInformation, ServerContextInformation serverContextInformation) {
        Object context = serverContextInformation.getServerContext();
        if (context instanceof ConfigurationContext) {
            AxisConfiguration axisCfg;
            AxisConfiguration axisConfiguration = axisCfg = ((ConfigurationContext)context).getAxisConfiguration();
            synchronized (axisConfiguration) {
                DeploymentEngine deploymentEngine = (DeploymentEngine)axisCfg.getConfigurator();
                String carbonRepoPath = axisCfg.getRepository().getPath();
                String mediatorsPath = carbonRepoPath + File.separator + "mediators";
                String extensionsPath = carbonRepoPath + File.separator + "extensions";
                ExtensionDeployer deployer = new ExtensionDeployer();
                deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "xar");
                deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "xar");
                deploymentEngine.addDeployer((Deployer)deployer, mediatorsPath, "jar");
                deploymentEngine.addDeployer((Deployer)deployer, extensionsPath, "jar");
                String classMediatorsPath = carbonRepoPath + File.separator + "class-mediators";
                deploymentEngine.addDeployer((Deployer)new ClassMediatorDeployer(), classMediatorsPath, "jar");
            }
            this.currentConfigurationName = ((ConfigurationContext)context).getAxisConfiguration().getParameterValue("SYNAPSE_CURRENT_CONFIGURATION").toString();
            this.synapseXMLLocation = serverConfigurationInformation.getSynapseXMLLocation();
        }
        super.init(serverConfigurationInformation, serverContextInformation);
    }

    public void start() {
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        String enabled = properties.getProperty("synapse.snmp.enabled");
        try {
            if (enabled != null && JavaUtils.isTrueExplicitly((String)enabled)) {
                this.snmpAgent = new SynapseSNMPAgent(properties);
                this.snmpAgent.start();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while initializing SNMP", (Throwable)e);
        }
        catch (Exception e) {
            log.info((Object)("SNMP not initialized, SNMP not supported in tenants. Message : " + e.getMessage()));
        }
        if (this.getContext() != null) {
            List inflowPhases = ((ConfigurationContext)this.getContext()).getAxisConfiguration().getInFlowPhases();
            for (Phase inPhase : inflowPhases) {
                if (!"Dispatch".equals(inPhase.getPhaseName())) continue;
                for (Handler handler : inPhase.getHandlers()) {
                    if (!MULTI_TENANT_DISPATCHER_NAME.equals(handler.getName())) continue;
                    return;
                }
                super.start();
            }
        } else {
            this.handleFatal("Couldn't start Synapse, ConfigurationContext not found");
        }
    }

    public SynapseConfiguration createSynapseConfiguration() {
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        if (this.serverConfigurationInformation.getResolveRoot() != null) {
            properties.put("resolve.root", this.serverConfigurationInformation.getResolveRoot());
        }
        if (this.serverConfigurationInformation.getSynapseHome() != null) {
            properties.put("synapse.home", this.serverConfigurationInformation.getSynapseHome());
        }
        log.debug((Object)"Loading the mediation configuration from the file system");
        return super.createSynapseConfiguration();
    }

    public void destroySynapseEnvironment() {
        for (ProxyService proxy : this.synapseConfiguration.getProxyServices()) {
            try {
                proxy.getAxisService().addParameter(KEEP_SERVICE_HISTORY_PARAM, (Object)PARAMETER_VALUE_TRUE);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while accessing the Proxy Service " + proxy.getName() + ". Service configuration history might get lost"), (Throwable)axisFault);
            }
        }
        super.destroySynapseEnvironment();
    }

    private void addServerIPAndHostEnrties(SynapseConfiguration configuration) {
        Entry entry;
        String hostName = ServiceBusInitializer.getServerConfigurationInformation().getHostName();
        String ipAddress = ServiceBusInitializer.getServerConfigurationInformation().getIpAddress();
        if (hostName != null && !"".equals(hostName)) {
            entry = new Entry("SERVER_HOST");
            entry.setValue((Object)hostName);
            configuration.addEntry("SERVER_HOST", entry);
        }
        if (ipAddress != null && !"".equals(ipAddress)) {
            entry = new Entry("SERVER_IP");
            entry.setValue((Object)ipAddress);
            configuration.addEntry("SERVER_IP", entry);
        }
    }

    private String getParameter(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        CarbonServerConfigurationService serverConf = CarbonServerConfigurationService.getInstance();
        return serverConf.getFirstProperty(name);
    }

    private void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }
}

