/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.AbstractExtendedSynapseHandler;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.debug.SynapseDebugInterface;
import org.apache.synapse.debug.SynapseDebugManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.inbound.endpoint.EndpointListenerLoader;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.micro.core.ServerShutdownHandler;
import org.wso2.micro.integrator.core.services.Axis2ConfigurationContextService;
import org.wso2.micro.integrator.core.services.CarbonServerConfigurationService;
import org.wso2.micro.integrator.core.util.MicroIntegratorBaseUtils;
import org.wso2.micro.integrator.initializer.CarbonSynapseController;
import org.wso2.micro.integrator.initializer.handler.ProxyLogHandler;
import org.wso2.micro.integrator.initializer.handler.SynapseExternalPropertyConfigurator;
import org.wso2.micro.integrator.initializer.handler.transaction.TransactionCountHandler;
import org.wso2.micro.integrator.initializer.handler.transaction.TransactionCountHandlerComponent;
import org.wso2.micro.integrator.initializer.persistence.MediationPersistenceManager;
import org.wso2.micro.integrator.initializer.services.SynapseConfigurationService;
import org.wso2.micro.integrator.initializer.services.SynapseConfigurationServiceImpl;
import org.wso2.micro.integrator.initializer.services.SynapseEnvironmentService;
import org.wso2.micro.integrator.initializer.services.SynapseEnvironmentServiceImpl;
import org.wso2.micro.integrator.initializer.services.SynapseRegistrationsService;
import org.wso2.micro.integrator.initializer.services.SynapseRegistrationsServiceImpl;
import org.wso2.micro.integrator.initializer.utils.ConfigurationHolder;
import org.wso2.micro.integrator.initializer.utils.SynapseArtifactInitUtils;
import org.wso2.micro.integrator.ndatasource.core.DataSourceService;
import org.wso2.micro.integrator.ntask.core.service.TaskService;

@Component(name="org.wso2.micro.integrator.initializer.ServiceBusInitializer", immediate=true)
public class ServiceBusInitializer {
    private static final Log log = LogFactory.getLog(ServiceBusInitializer.class);
    private static ServerConfigurationInformation configurationInformation;
    private static String configPath;
    private Axis2ConfigurationContextService configCtxSvc;
    private SecretCallbackHandlerService secretCallbackHandlerService;
    private ServerManager serverManager;
    private TaskService taskService;
    private DataSourceService dataSourceService;
    private TransactionCountHandlerComponent transactionCountHandlerComponent;
    private ExecutorService transactionCountExecutor;

    @Activate
    protected void activate(ComponentContext ctxt) {
        String javaTempDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)(ServiceBusInitializer.class.getName() + "#activate() BEGIN - " + System.currentTimeMillis()));
        }
        log.debug((Object)"Activating Micro Integrator...");
        if (this.taskService != null && !this.taskService.isServerInit()) {
            log.debug((Object)"Initialize Task Service");
            this.taskService.serverInitialized();
        }
        String APP_UNZIP_DIR = (javaTempDir = System.getProperty("java.io.tmpdir")).endsWith(File.separator) ? javaTempDir + "libs" : javaTempDir + File.separator + "libs";
        ServiceBusInitializer.cleanupTempDirectory(APP_UNZIP_DIR);
        try {
            BundleContext bndCtx = ctxt.getBundleContext();
            ConfigurationHolder.getInstance().setBundleContext(bndCtx);
            ReentrantLock lock = new ReentrantLock();
            this.configCtxSvc.getServerConfigContext().getAxisConfiguration().addParameter("synapse.config.lock", (Object)lock);
            ServerContextInformation contextInfo = this.initESB("default");
            ServiceRegistration synCfgRegistration = null;
            ServiceRegistration synEnvRegistration = null;
            if (contextInfo.getSynapseConfiguration() != null) {
                SynapseConfigurationServiceImpl synCfgSvc = new SynapseConfigurationServiceImpl(contextInfo.getSynapseConfiguration(), -1234, this.configCtxSvc.getServerConfigContext());
                ConfigurationHolder.getInstance().setSynapseConfigurationService(synCfgSvc);
                synCfgRegistration = bndCtx.registerService(SynapseConfigurationService.class.getName(), (Object)synCfgSvc, null);
                bndCtx.registerService(ServerShutdownHandler.class.getName(), (Object)new MPMShutdownHandler(synCfgSvc.getSynapseConfiguration().getAxisConfiguration()), null);
                this.initPersistence(synCfgSvc, "default");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseConfigurationService Registered");
                }
            } else {
                this.handleFatal("Couldn't register the SynapseConfigurationService, SynapseConfiguration not found");
            }
            SynapseEnvironment synapseEnvironment = contextInfo.getSynapseEnvironment();
            List handlers = synapseEnvironment.getSynapseHandlers();
            for (SynapseHandler handler : handlers) {
                AbstractExtendedSynapseHandler abstractExtendedSynapseHandler;
                if (!(handler instanceof AbstractExtendedSynapseHandler) || (abstractExtendedSynapseHandler = (AbstractExtendedSynapseHandler)handler).handleServerInit()) continue;
                log.warn((Object)"Server initialization not executed in the server init path of the AbstractExtendedSynapseHandler");
            }
            if (synapseEnvironment != null) {
                SynapseEnvironmentServiceImpl synEnvSvc = new SynapseEnvironmentServiceImpl(synapseEnvironment, -1234, this.configCtxSvc.getServerConfigContext());
                ConfigurationHolder.getInstance().setSynapseEnvironmentService(synEnvSvc);
                synEnvRegistration = bndCtx.registerService(SynapseEnvironmentService.class.getName(), (Object)synEnvSvc, null);
                synapseEnvironment.registerSynapseHandler((SynapseHandler)new SynapseExternalPropertyConfigurator());
                synapseEnvironment.registerSynapseHandler((SynapseHandler)new ProxyLogHandler());
                boolean transactionPropertyEnabled = TransactionCountHandlerComponent.isTransactionPropertyEnabled();
                if (transactionPropertyEnabled) {
                    this.transactionCountHandlerComponent = new TransactionCountHandlerComponent();
                    this.transactionCountHandlerComponent.start(this.dataSourceService);
                    this.transactionCountExecutor = Executors.newFixedThreadPool(100);
                    synapseEnvironment.registerSynapseHandler((SynapseHandler)new TransactionCountHandler(this.transactionCountExecutor));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseEnvironmentService Registered");
                }
            } else {
                this.handleFatal("Couldn't register the SynapseEnvironmentService, SynapseEnvironment not found");
            }
            SynapseRegistrationsServiceImpl synRegistrationsSvc = new SynapseRegistrationsServiceImpl(synCfgRegistration, synEnvRegistration, -1234, this.configCtxSvc.getServerConfigContext());
            ConfigurationHolder.getInstance().setSynapseRegistrationsService(synRegistrationsSvc);
            bndCtx.registerService(SynapseRegistrationsService.class.getName(), (Object)synRegistrationsSvc, null);
            EndpointListenerLoader.loadListeners();
        }
        catch (Exception e) {
            this.handleFatal("Couldn't initialize the ESB...", e);
        }
        catch (Throwable t) {
            log.fatal((Object)"Failed to initialize ESB due to a fatal error", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(ServiceBusInitializer.class.getName() + "#activate() COMPLETED - " + System.currentTimeMillis()));
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (Objects.nonNull(this.transactionCountHandlerComponent)) {
            this.transactionCountHandlerComponent.cleanup();
        }
        if (Objects.nonNull(this.transactionCountExecutor)) {
            this.transactionCountExecutor.shutdownNow();
        }
        List handlers = this.serverManager.getServerContextInformation().getSynapseEnvironment().getSynapseHandlers();
        for (SynapseHandler handler : handlers) {
            AbstractExtendedSynapseHandler abstractExtendedSynapseHandler;
            if (!(handler instanceof AbstractExtendedSynapseHandler) || (abstractExtendedSynapseHandler = (AbstractExtendedSynapseHandler)handler).handleServerShutDown()) continue;
            log.warn((Object)"Server shut down not executed in the server shut down path of the AbstractExtendedSynapseHandler");
        }
        this.serverManager.stop();
        this.serverManager.shutdown();
    }

    private void initPersistence(SynapseConfigurationService synCfgSvc, String configName) throws AxisFault {
        CarbonServerConfigurationService serverConf = CarbonServerConfigurationService.getInstance();
        String persistence = serverConf.getFirstProperty("MediationConfig.Persistence");
        if (!"disabled".equals(persistence)) {
            String interval = serverConf.getFirstProperty("MediationConfig.WorkerInterval");
            long intervalInMillis = 5000L;
            if (interval != null && !"".equals(interval)) {
                try {
                    intervalInMillis = Long.parseLong(interval);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid value " + interval + " specified for the mediation persistence worker interval, Using defaults"), (Throwable)e);
                }
            }
            MediationPersistenceManager pm = new MediationPersistenceManager(configurationInformation.getSynapseXMLLocation(), synCfgSvc.getSynapseConfiguration(), intervalInMillis, configName);
            this.configCtxSvc.getServerConfigContext().getAxisConfiguration().addParameter(new Parameter("PERSISTENCE_MANAGER", (Object)pm));
        } else {
            log.info((Object)"Persistence for mediation configuration is disabled");
        }
    }

    private ServerContextInformation initESB(String name) throws AxisFault {
        if (this.configCtxSvc != null) {
            boolean initConnectors;
            String synapseConfigsLocation;
            ConfigurationContext configContext = this.configCtxSvc.getServerConfigContext();
            log.debug((Object)"Initializing Apache Synapse...");
            configurationInformation = ServerConfigurationInformationFactory.createServerConfigurationInformation((AxisConfiguration)configContext.getAxisConfiguration());
            if (System.getProperty("SynapseServerName") != null) {
                configurationInformation.setServerName(System.getProperty("SynapseServerName"));
            }
            if ((synapseConfigsLocation = configurationInformation.getSynapseXMLLocation()) != null) {
                configurationInformation.setSynapseXMLLocation(synapseConfigsLocation + File.separator + name);
            } else {
                configurationInformation.setSynapseXMLLocation("repository/deployment/server/synapse-configs" + name);
            }
            configurationInformation.setCreateNewInstance(false);
            configurationInformation.setServerControllerProvider(CarbonSynapseController.class.getName());
            if (ServiceBusInitializer.isRunningSamplesMode()) {
                if (System.getProperty("esb.sample") != null) {
                    configurationInformation.setSynapseXMLLocation("repository" + File.separator + "samples" + File.separator + "synapse_sample_" + System.getProperty("esb.sample") + ".xml");
                } else {
                    configurationInformation.setSynapseXMLLocation("samples" + File.separator + "service-bus" + File.separator + "synapse_sample_" + System.getProperty("ei.sample") + ".xml");
                }
            }
            this.serverManager = new ServerManager();
            ServerContextInformation contextInfo = new ServerContextInformation((Object)configContext, configurationInformation);
            if (this.secretCallbackHandlerService != null) {
                contextInfo.addProperty("SharedSecretCallbackHandler", (Object)this.secretCallbackHandlerService.getSecretCallbackHandler());
            }
            AxisConfiguration axisConf = configContext.getAxisConfiguration();
            axisConf.addParameter(new Parameter("SYNAPSE_CURRENT_CONFIGURATION", (Object)name));
            if (ServiceBusInitializer.isRunningDebugMode()) {
                log.debug((Object)"Micro Integrator started in Debug mode for super tenant");
                this.createSynapseDebugEnvironment(contextInfo);
            }
            boolean bl = initConnectors = Boolean.valueOf(System.getProperty("esb.connector.startup.init.disable")) == false;
            if (initConnectors) {
                SynapseArtifactInitUtils.initializeConnectors(axisConf);
            }
            this.serverManager.init(configurationInformation, contextInfo);
            this.serverManager.start();
            AxisServiceGroup serviceGroup = axisConf.getServiceGroup("__SynapseService");
            serviceGroup.addParameter("hiddenService", (Object)"true");
            return contextInfo;
        }
        this.handleFatal("Couldn't initialize Synapse, ConfigurationContext service or SynapseRegistryService is not available");
        return null;
    }

    public static boolean isRunningSamplesMode() {
        return System.getProperty("esb.sample") != null || System.getProperty("ei.sample") != null;
    }

    public static boolean isRunningDebugMode() {
        String debugMode = System.getProperty("esb.debug");
        return "true".equals(debugMode) || "super".equals(debugMode);
    }

    public void createSynapseDebugEnvironment(ServerContextInformation contextInfo) {
        try {
            String carbonHome = System.getProperty("carbon.home");
            File synapseProperties = Paths.get(MicroIntegratorBaseUtils.getCarbonConfigDirPath(), "synapse.properties").toFile();
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(synapseProperties);
            properties.load(inputStream);
            ((InputStream)inputStream).close();
            int event_port = Integer.parseInt(properties.getProperty("synapse.debugger.port.event"));
            int command_port = Integer.parseInt(properties.getProperty("synapse.debugger.port.command"));
            SynapseDebugInterface debugInterface = SynapseDebugInterface.getInstance();
            debugInterface.init(command_port, event_port);
            contextInfo.setServerDebugModeEnabled(true);
            contextInfo.setSynapseDebugInterface(debugInterface);
            SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
            contextInfo.setSynapseDebugManager(debugManager);
            log.debug((Object)"Synapse debug Environment created successfully");
        }
        catch (IOException ex) {
            log.error((Object)"Error while creating Synapse debug environment ", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.error((Object)"Error while creating Synapse debug environment ", (Throwable)ex);
        }
    }

    @Reference(name="config.context.service", service=Axis2ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(Axis2ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the ESB initialization process");
            log.debug((Object)("configurationContextService : " + configurationContextService));
        }
        this.configCtxSvc = configurationContextService;
        ConfigurationHolder.getInstance().setAxis2ConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(Axis2ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the ESB environment");
        }
        this.configCtxSvc = null;
    }

    @Reference(name="org.wso2.micro.integrator.core.services.CarbonServerConfigurationService", service=CarbonServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(CarbonServerConfigurationService serverConfigurationService) {
        ConfigurationHolder.getInstance().setCarbonServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(CarbonServerConfigurationService serverConfigurationService) {
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService bound to the ESB initialization process");
        }
        this.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService unbound from the ESB environment");
        }
        this.secretCallbackHandlerService = null;
    }

    public static ServerConfigurationInformation getConfigurationInformation() {
        return configurationInformation;
    }

    protected static ServerConfigurationInformation getServerConfigurationInformation() {
        return configurationInformation;
    }

    private void handleFatal(String message) {
        log.fatal((Object)message);
    }

    private void handleFatal(String message, Exception e) {
        log.fatal((Object)message, (Throwable)e);
    }

    private static void cleanupTempDirectory(String appUnzipDir) {
        File tempDirector = new File(appUnzipDir);
        if (tempDirector.isDirectory()) {
            File[] entries = tempDirector.listFiles();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                try {
                    FileUtils.deleteDirectory((File)entries[i]);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)("Could not build lib artifact for path : " + entries[i].getAbsolutePath()));
                }
            }
        }
    }

    @Reference(name="org.wso2.micro.integrator.ntask.core.service.TaskService", service=TaskService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskService")
    protected void setTaskService(TaskService taskService) {
        log.debug((Object)"Set Task Service");
        this.taskService = taskService;
    }

    protected void unsetTaskService(TaskService taskService) {
        this.taskService = null;
    }

    @Reference(name="osgi.configadmin.service", service=ConfigurationAdmin.class, unbind="unsetConfigAdminService", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    public void setConfigAdminService(ConfigurationAdmin configAdminService) {
        log.debug((Object)"Setting ConfigurationAdmin Service");
        ConfigurationHolder.getInstance().setConfigAdminService(configAdminService);
    }

    public void unsetConfigAdminService(ConfigurationAdmin configAdminService) {
        log.debug((Object)"Unsetting ConfigurationAdmin Service");
    }

    @Reference(name="org.wso2.carbon.ndatasource", service=DataSourceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDatasourceHandlerService")
    protected void setDatasourceHandlerService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    protected void unsetDatasourceHandlerService(DataSourceService dataSourceService) {
        this.dataSourceService = null;
    }

    public class MPMShutdownHandler
    implements ServerShutdownHandler {
        private AxisConfiguration configuration;

        public MPMShutdownHandler(AxisConfiguration configuration) {
            this.configuration = configuration;
        }

        public void invoke() {
            Parameter p = this.configuration.getParameter("PERSISTENCE_MANAGER");
            if (p != null && p.getValue() instanceof MediationPersistenceManager) {
                ((MediationPersistenceManager)p.getValue()).destroy();
            }
        }
    }
}

