/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer;

import java.io.File;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.wso2.micro.integrator.core.util.MicroIntegratorBaseUtils;
import org.wso2.micro.integrator.initializer.ServiceBusInitializer;
import org.wso2.micro.integrator.initializer.persistence.MediationPersistenceManager;

public class ServiceBusUtils {
    private static final Log log = LogFactory.getLog(ServiceBusUtils.class);

    public static String getSynapseConfigAbsPath(ServerContextInformation contextInformation) {
        String carbonHome = MicroIntegratorBaseUtils.getCarbonHome();
        ServerConfigurationInformation configInfo = ServiceBusUtils.getSynapseServerConfigInfo(contextInformation);
        if (configInfo == null) {
            String msg = "Unable to obtain ESB server configuration information";
            log.warn((Object)msg);
            throw new SynapseException(msg);
        }
        File synapseConfigFile = new File(configInfo.getSynapseXMLLocation());
        String synapseConfigPath = synapseConfigFile.isAbsolute() ? synapseConfigFile.getAbsolutePath() : new File(carbonHome.trim(), configInfo.getSynapseXMLLocation()).getAbsolutePath();
        return synapseConfigPath;
    }

    public static ServerConfigurationInformation getSynapseServerConfigInfo(ServerContextInformation contextInformation) {
        if (contextInformation != null) {
            return contextInformation.getServerConfigurationInformation();
        }
        return ServiceBusInitializer.getServerConfigurationInformation();
    }

    public static MediationPersistenceManager getMediationPersistenceManager(AxisConfiguration axisCfg) {
        Parameter p = axisCfg.getParameter("PERSISTENCE_MANAGER");
        if (p != null) {
            return (MediationPersistenceManager)p.getValue();
        }
        return null;
    }

    public static String generateFileName(String name) {
        return name.replaceAll("[\\/?*|:<> ]", "_") + ".xml";
    }
}

