/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wso2.micro.core.ServerStatus;
import org.wso2.micro.integrator.initializer.utils.ConfigurationHolder;

public class StartupFinalizer {
    private static final Log log = LogFactory.getLog(StartupFinalizer.class);
    public static final String START_TIME = "wso2carbon.start.time";
    public static final String SERVER_START_TIME = "wso2carbon.server.start.time";
    public static final String START_UP_DURATION = "wso2carbon.startup.duration";
    private ConfigurationContext configCtx;
    private BundleContext bundleContext;
    private ConfigurationHolder dataHolder = ConfigurationHolder.getInstance();
    private ServiceRegistration listerManagerServiceRegistration;

    public StartupFinalizer(ConfigurationContext configCtx, BundleContext bundleContext) {
        this.configCtx = configCtx;
        this.bundleContext = bundleContext;
    }

    public void finalizeStartup() {
        this.completeInitialization();
    }

    public void cleanup() {
    }

    private void completeInitialization() {
        ListenerManager listenerManager = this.configCtx.getListenerManager();
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
        }
        listenerManager.setShutdownHookRequired(false);
        listenerManager.startSystem(this.configCtx);
        this.setServerStartTimeParam();
        this.printInfo();
    }

    private void setServerStartTimeParam() {
        Parameter startTimeParam = new Parameter();
        startTimeParam.setName(SERVER_START_TIME);
        startTimeParam.setValue((Object)System.getProperty(START_TIME));
        try {
            this.configCtx.getAxisConfiguration().addParameter(startTimeParam);
        }
        catch (AxisFault e) {
            log.error((Object)"Could not set the  server start time parameter", (Throwable)e);
        }
    }

    private void setServerStartUpDurationParam(String startupTime) {
        Parameter startupDurationParam = new Parameter();
        startupDurationParam.setName(START_UP_DURATION);
        startupDurationParam.setValue((Object)startupTime);
        try {
            this.configCtx.getAxisConfiguration().addParameter(startupDurationParam);
        }
        catch (AxisFault e) {
            log.error((Object)"Could not set the  server start up duration parameter", (Throwable)e);
        }
    }

    private void printInfo() {
        long startTime = Long.parseLong(System.getProperty(START_TIME));
        double startupTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Server           :  " + this.dataHolder.getCarbonServerConfigurationService().getFirstProperty("Name") + "-" + this.dataHolder.getCarbonServerConfigurationService().getFirstProperty("Version")));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error while retrieving server configuration", (Throwable)e);
        }
        try {
            ServerStatus.setServerRunning();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to running mode";
            log.error((Object)msg, (Throwable)e);
        }
        log.info((Object)String.format("WSO2 Micro Integrator started in %.2f seconds", startupTime));
        this.setServerStartUpDurationParam(String.valueOf(startupTime));
        System.getProperties().remove("setup");
    }
}

