/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.dashboard;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.integrator.initializer.dashboard.HeartBeatComponent;

public class ArtifactUpdateListener {
    private static final Log log = LogFactory.getLog(ArtifactUpdateListener.class);
    private static JsonArray stateChangedArtifacts = new JsonArray();

    private ArtifactUpdateListener() {
    }

    public static void addToUpdatedArtifactsQueue(String artifactType, String name) {
        if (HeartBeatComponent.isDashboardConfigured()) {
            JsonObject updatedArtifact = ArtifactUpdateListener.getUpdatedArtifact(artifactType, name);
            log.debug((Object)("Adding " + updatedArtifact.get("type").toString() + " " + updatedArtifact.get("name").toString() + " to state changed artifacts queue."));
            stateChangedArtifacts.add((JsonElement)updatedArtifact);
        }
    }

    public static JsonArray getStateChangedArtifacts() {
        return stateChangedArtifacts;
    }

    public static void removeFromUpdatedArtifactQueue(int artifactsSize) {
        for (int i = 0; i < artifactsSize; ++i) {
            stateChangedArtifacts.remove(0);
        }
    }

    private static JsonObject getUpdatedArtifact(String type, String name) {
        JsonObject updatedArtifact = new JsonObject();
        updatedArtifact.addProperty("type", type);
        updatedArtifact.addProperty("name", name);
        return updatedArtifact;
    }
}

