/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.deployment;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.micro.application.deployer.handler.AppDeploymentHandler;
import org.wso2.micro.application.deployer.handler.DefaultAppDeployer;
import org.wso2.micro.core.CarbonAxisConfigurator;
import org.wso2.micro.integrator.core.UserStoreTemporaryService;
import org.wso2.micro.integrator.dataservices.core.DBDeployer;
import org.wso2.micro.integrator.initializer.StartupFinalizer;
import org.wso2.micro.integrator.initializer.dashboard.HeartBeatComponent;
import org.wso2.micro.integrator.initializer.deployment.DataHolder;
import org.wso2.micro.integrator.initializer.deployment.application.deployer.CappDeployer;
import org.wso2.micro.integrator.initializer.deployment.synapse.deployer.FileRegistryResourceDeployer;
import org.wso2.micro.integrator.initializer.deployment.synapse.deployer.SynapseAppDeployer;
import org.wso2.micro.integrator.initializer.deployment.user.store.deployer.UserStoreDeployer;
import org.wso2.micro.integrator.initializer.services.SynapseEnvironmentService;
import org.wso2.micro.integrator.initializer.utils.ConfigurationHolder;
import org.wso2.micro.integrator.ndatasource.capp.deployer.DataSourceCappDeployer;

@Component(name="org.wso2.micro.integrator.initializer.deployment.AppDeployerServiceComponent", immediate=true)
public class AppDeployerServiceComponent {
    private static SecretCallbackHandlerService secretCallbackHandlerService;
    private static UserStoreTemporaryService userStoreTemporaryService;
    private static final Log log;
    private ConfigurationContext configCtx;
    private SynapseEnvironmentService synapseEnvironmentService;
    private StartupFinalizer startupFinalizer;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(AppDeployerServiceComponent.class.getName() + "#activate() BEGIN - " + System.currentTimeMillis()));
            log.debug((Object)"Activating AppDeployerServiceComponent");
        }
        this.configCtx = ConfigurationHolder.getInstance().getAxis2ConfigurationContextService().getServerConfigContext();
        this.initializeDeployers();
        this.invokeRegisteredDeployers();
        if (HeartBeatComponent.isDashboardConfigured()) {
            log.info((Object)"Dashboard is configured. Initiating heartbeat component.");
            HeartBeatComponent.invokeHeartbeatExecutorService();
        }
        this.startupFinalizer = new StartupFinalizer(this.configCtx, ctxt.getBundleContext());
        this.startupFinalizer.finalizeStartup();
        if (log.isDebugEnabled()) {
            log.debug((Object)(AppDeployerServiceComponent.class.getName() + "#activate() COMPLETE - " + System.currentTimeMillis()));
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Deactivating AppDeployerServiceComponent");
        this.startupFinalizer.cleanup();
    }

    @Reference(name="synapse.env.service", service=SynapseEnvironmentService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseEnvironmentService")
    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentService = synapseEnvironmentService;
        DataHolder.getInstance().setSynapseEnvironmentService(this.synapseEnvironmentService);
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentService = null;
    }

    private void initializeDeployers() {
        DeploymentEngine deploymentEngine = (DeploymentEngine)this.configCtx.getAxisConfiguration().getConfigurator();
        this.addDBDeployer(deploymentEngine);
        this.addCAppDeployer(deploymentEngine);
        if (!Boolean.parseBoolean(System.getProperty("NonUserCoreMode"))) {
            this.addUserStoreDeployer(deploymentEngine);
        }
    }

    private void addCAppDeployer(DeploymentEngine deploymentEngine) {
        String artifactRepoPath = this.configCtx.getAxisConfiguration().getRepository().getPath();
        CappDeployer cappDeployer = new CappDeployer();
        cappDeployer.setDirectory(artifactRepoPath + "carbonapps");
        cappDeployer.setSecretCallbackHandlerService(secretCallbackHandlerService);
        cappDeployer.init(this.configCtx);
        cappDeployer.registerDeploymentHandler(new FileRegistryResourceDeployer(this.synapseEnvironmentService.getSynapseEnvironment().getSynapseConfiguration().getRegistry()));
        cappDeployer.registerDeploymentHandler((AppDeploymentHandler)new DataSourceCappDeployer());
        cappDeployer.registerDeploymentHandler((AppDeploymentHandler)new DefaultAppDeployer());
        cappDeployer.registerDeploymentHandler(new SynapseAppDeployer());
        deploymentEngine.addDeployer((Deployer)cappDeployer, artifactRepoPath + "carbonapps", "car");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully registered CappDeployer");
        }
    }

    private void addDBDeployer(DeploymentEngine deploymentEngine) {
        String artifactRepoPath = this.configCtx.getAxisConfiguration().getRepository().getPath();
        DBDeployer dbDeployer = new DBDeployer();
        dbDeployer.setDirectory(artifactRepoPath + "dataservices");
        dbDeployer.setExtension(".dbs");
        deploymentEngine.addDeployer((Deployer)dbDeployer, "dataservices", "dbs");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully registered Data Service Deployer");
        }
    }

    private void addUserStoreDeployer(DeploymentEngine deploymentEngine) {
        String artifactRepoPath = this.configCtx.getAxisConfiguration().getRepository().getPath();
        UserStoreDeployer userStoreDeployer = new UserStoreDeployer();
        userStoreDeployer.setDirectory(artifactRepoPath + "userstores");
        userStoreDeployer.setExtension("xml");
        deploymentEngine.addDeployer((Deployer)userStoreDeployer, "userstores", "xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully registered UserStore Deployer");
        }
    }

    private void invokeRegisteredDeployers() {
        AxisConfigurator axisConfigurator = this.configCtx.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).deployServices();
        }
    }

    @Reference(name="user.temporaryService.default", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTemporaryService")
    protected void setTemporaryService(UserStoreTemporaryService userStoreTemporaryService) {
        AppDeployerServiceComponent.userStoreTemporaryService = userStoreTemporaryService;
    }

    protected void unsetTemporaryService(UserStoreTemporaryService userStoreTemporaryService) {
        userStoreTemporaryService = null;
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        log.debug((Object)"SecretCallbackHandlerService bound to the ESB initialization process");
        AppDeployerServiceComponent.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        log.debug((Object)"SecretCallbackHandlerService unbound from the ESB environment");
        AppDeployerServiceComponent.secretCallbackHandlerService = null;
    }

    static {
        log = LogFactory.getLog(AppDeployerServiceComponent.class);
    }
}

