/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.deployment.synapse.deployer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.registry.Registry;
import org.wso2.micro.application.deployer.AppDeployerUtils;
import org.wso2.micro.application.deployer.CarbonApplication;
import org.wso2.micro.application.deployer.config.ApplicationConfiguration;
import org.wso2.micro.application.deployer.config.Artifact;
import org.wso2.micro.application.deployer.config.CappFile;
import org.wso2.micro.application.deployer.config.RegistryConfig;
import org.wso2.micro.application.deployer.handler.AppDeploymentHandler;
import org.wso2.micro.integrator.registry.MicroIntegratorRegistry;

public class FileRegistryResourceDeployer
implements AppDeploymentHandler {
    private Registry lightweightRegistry;
    public static final Log log = LogFactory.getLog(FileRegistryResourceDeployer.class);
    private static final String REGISTRY_RESOURCE_TYPE = "registry/resource";

    public FileRegistryResourceDeployer(Registry lightweightRegistry) {
        this.lightweightRegistry = lightweightRegistry;
    }

    public void deployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        ApplicationConfiguration appConfig = carbonApplication.getAppConfig();
        List deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.deployRegistryArtifacts(artifacts, carbonApplication.getAppNameWithVersion());
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        ApplicationConfiguration appConfig = carbonApplication.getAppConfig();
        List deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.undeployRegistryArtifacts(artifacts, carbonApplication.getAppNameWithVersion());
    }

    private void deployRegistryArtifacts(List<Artifact> artifacts, String parentAppName) {
        artifacts.stream().filter(artifact -> REGISTRY_RESOURCE_TYPE.equals(artifact.getType())).forEach(artifact -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deploying registry artifact: " + artifact.getName()));
            }
            RegistryConfig regConfig = this.buildRegistryConfig((Artifact)artifact, parentAppName);
            this.writeArtifactToRegistry(regConfig);
        });
    }

    private void undeployRegistryArtifacts(List<Artifact> artifacts, String parentAppName) {
        artifacts.stream().filter(artifact -> REGISTRY_RESOURCE_TYPE.equals(artifact.getType())).forEach(artifact -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Undeploying registry artifact: " + artifact.getName()));
            }
            RegistryConfig regConfig = this.buildRegistryConfig((Artifact)artifact, parentAppName);
            this.removeArtifactFromRegistry(regConfig);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistryConfig buildRegistryConfig(Artifact artifact, String appName) {
        RegistryConfig regConfig = null;
        List files = artifact.getFiles();
        if (files.size() == 1) {
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String regConfigPath = artifact.getExtractedPath() + File.separator + fileName;
            File regConfigFile = new File(regConfigPath);
            if (regConfigFile.exists()) {
                FileInputStream xmlInputStream = null;
                try {
                    xmlInputStream = new FileInputStream(regConfigFile);
                    regConfig = AppDeployerUtils.populateRegistryConfig((OMElement)new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement());
                }
                catch (Exception e) {
                    log.error((Object)("Error while reading file : " + fileName), (Throwable)e);
                }
                finally {
                    if (xmlInputStream != null) {
                        try {
                            ((InputStream)xmlInputStream).close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing input stream.", (Throwable)e);
                        }
                    }
                }
                if (regConfig != null) {
                    regConfig.setAppName(appName);
                    regConfig.setExtractedPath(artifact.getExtractedPath());
                    regConfig.setParentArtifactName(artifact.getName());
                    regConfig.setConfigFileName(fileName);
                }
            } else {
                log.error((Object)("Registry config file not found at : " + regConfigPath));
            }
        } else {
            log.error((Object)("Registry/Resource type must have a single file which declares registry configs. But " + files.size() + " files found."));
        }
        return regConfig;
    }

    private void writeArtifactToRegistry(RegistryConfig registryConfig) {
        List resources = registryConfig.getResources();
        for (RegistryConfig.Resourse resource : resources) {
            String filePath = registryConfig.getExtractedPath() + File.separator + "resources" + File.separator + resource.getFileName();
            File file = new File(filePath);
            if (!file.exists()) {
                log.error((Object)("Specified file to be written as a resource is not found at : " + filePath));
                continue;
            }
            String resourcePath = AppDeployerUtils.computeResourcePath((String)this.createRegistryKey(resource), (String)resource.getFileName());
            String mediaType = resource.getMediaType();
            ((MicroIntegratorRegistry)this.lightweightRegistry).addNewNonEmptyResource(resourcePath, false, mediaType, this.readResourceContent(file), resource.getProperties());
        }
        List collections = registryConfig.getCollections();
        for (RegistryConfig.Collection collection : collections) {
            String filePath = registryConfig.getExtractedPath() + File.separator + "resources" + File.separator + collection.getDirectory();
            File file = new File(filePath);
            if (!file.exists()) {
                log.error((Object)("Specified file to be written as a resource is not found at : " + filePath));
                continue;
            }
            ((MicroIntegratorRegistry)this.lightweightRegistry).addNewNonEmptyResource(AppDeployerUtils.createRegistryPath((String)collection.getPath()), true, "", "", collection.getProperties());
        }
    }

    private void removeArtifactFromRegistry(RegistryConfig registryConfig) {
        List resources = registryConfig.getResources();
        for (RegistryConfig.Resourse resource : resources) {
            String filePath = registryConfig.getExtractedPath() + File.separator + "resources" + File.separator + resource.getFileName();
            File file = new File(filePath);
            if (!file.exists()) continue;
            String resourcePath = AppDeployerUtils.computeResourcePath((String)AppDeployerUtils.createRegistryPath((String)resource.getPath()), (String)resource.getFileName());
            this.lightweightRegistry.delete(resourcePath);
        }
    }

    private String createRegistryKey(RegistryConfig.Resourse resourse) {
        return AppDeployerUtils.createRegistryPath((String)resourse.getPath());
    }

    private String readResourceContent(File file) {
        block16: {
            String string;
            FileInputStream is = new FileInputStream(file);
            try {
                long length = file.length();
                if (length > Integer.MAX_VALUE) {
                    log.error((Object)("File " + file.getName() + "is too large."));
                }
                StringBuilder strBuilder = new StringBuilder();
                try (BufferedReader bReader = new BufferedReader(new InputStreamReader(is));){
                    String line;
                    while ((line = bReader.readLine()) != null) {
                        strBuilder.append(line).append('\n');
                    }
                }
                string = strBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Unable to find file at: " + file.getAbsolutePath()), (Throwable)e);
                    break block16;
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while reading the content of file: " + file.getAbsolutePath()));
                }
            }
            ((InputStream)is).close();
            return string;
        }
        return null;
    }
}

