/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.deployment.synapse.deployer;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.APIDeployer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.deployers.EndpointDeployer;
import org.apache.synapse.deployers.InboundEndpointDeployer;
import org.apache.synapse.deployers.LibraryArtifactDeployer;
import org.apache.synapse.deployers.LocalEntryDeployer;
import org.apache.synapse.deployers.MessageProcessorDeployer;
import org.apache.synapse.deployers.MessageStoreDeployer;
import org.apache.synapse.deployers.ProxyServiceDeployer;
import org.apache.synapse.deployers.SequenceDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.deployers.TaskDeployer;
import org.apache.synapse.deployers.TemplateDeployer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.micro.application.deployer.AppDeployerUtils;
import org.wso2.micro.application.deployer.CarbonApplication;
import org.wso2.micro.application.deployer.config.Artifact;
import org.wso2.micro.application.deployer.config.CappFile;
import org.wso2.micro.application.deployer.handler.AppDeploymentHandler;
import org.wso2.micro.core.util.StringUtils;
import org.wso2.micro.integrator.core.util.MicroIntegratorBaseUtils;
import org.wso2.micro.integrator.initializer.ServiceBusUtils;
import org.wso2.micro.integrator.initializer.dashboard.ArtifactDeploymentListener;
import org.wso2.micro.integrator.initializer.persistence.MediationPersistenceManager;
import org.wso2.micro.integrator.initializer.utils.ConfigurationHolder;
import org.wso2.micro.integrator.initializer.utils.DeployerUtil;
import org.wso2.micro.integrator.initializer.utils.LocalEntryUtil;

public class SynapseAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(SynapseAppDeployer.class);
    private Map<String, Boolean> acceptanceList = null;
    private static String MAIN_XML = "<sequence xmlns=\"http://ws.apache.org/ns/synapse\" name=\"main\"/>";
    private static String FAULT_XML = "<sequence xmlns=\"http://ws.apache.org/ns/synapse\" name=\"fault\"/>";
    private static String MAIN_SEQ_REGEX = "main-\\d+\\.\\d+\\.\\d+\\.xml";
    private static String FAULT_SEQ_REGEX = "fault-\\d+\\.\\d+\\.\\d+\\.xml";
    private HashMap<String, Deployer> synapseDeployers = new HashMap();

    public SynapseAppDeployer() {
        this.initializeDefaultSynapseDeployers();
    }

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.deployClassMediators(artifacts, axisConfig);
        this.deploySynapseLibrary(artifacts, axisConfig);
        Map<String, List<Artifact.Dependency>> artifactTypeMap = this.getOrderedArtifactsMap(artifacts);
        for (String artifactType : artifactTypeMap.keySet()) {
            this.deployArtifactType(artifactTypeMap.get(artifactType), carbonApp, axisConfig);
        }
    }

    private Map<String, List<Artifact.Dependency>> getOrderedArtifactsMap(List<Artifact.Dependency> artifacts) {
        LinkedHashMap<String, List<Artifact.Dependency>> artifactTypeMap = new LinkedHashMap<String, List<Artifact.Dependency>>();
        artifactTypeMap.put("lib/synapse/mediator", new ArrayList());
        artifactTypeMap.put("synapse/lib", new ArrayList());
        artifactTypeMap.put("synapse/local-entry", new ArrayList());
        artifactTypeMap.put("synapse/endpoint", new ArrayList());
        artifactTypeMap.put("synapse/sequence", new ArrayList());
        artifactTypeMap.put("synapse/message-store", new ArrayList());
        artifactTypeMap.put("synapse/template", new ArrayList());
        artifactTypeMap.put("synapse/proxy-service", new ArrayList());
        artifactTypeMap.put("synapse/task", new ArrayList());
        artifactTypeMap.put("synapse/event-source", new ArrayList());
        artifactTypeMap.put("synapse/message-processors", new ArrayList());
        artifactTypeMap.put("synapse/api", new ArrayList());
        artifactTypeMap.put("synapse/inbound-endpoint", new ArrayList());
        artifactTypeMap.put("other", new ArrayList());
        block30: for (Artifact.Dependency dep : artifacts) {
            switch (dep.getArtifact().getType()) {
                case "lib/synapse/mediator": {
                    ((List)artifactTypeMap.get("lib/synapse/mediator")).add(dep);
                    continue block30;
                }
                case "synapse/lib": {
                    ((List)artifactTypeMap.get("synapse/lib")).add(dep);
                    continue block30;
                }
                case "synapse/local-entry": {
                    ((List)artifactTypeMap.get("synapse/local-entry")).add(dep);
                    continue block30;
                }
                case "synapse/endpoint": {
                    ((List)artifactTypeMap.get("synapse/endpoint")).add(dep);
                    continue block30;
                }
                case "synapse/sequence": {
                    ((List)artifactTypeMap.get("synapse/sequence")).add(dep);
                    continue block30;
                }
                case "synapse/message-store": {
                    ((List)artifactTypeMap.get("synapse/message-store")).add(dep);
                    continue block30;
                }
                case "synapse/template": {
                    ((List)artifactTypeMap.get("synapse/template")).add(dep);
                    continue block30;
                }
                case "synapse/proxy-service": {
                    ((List)artifactTypeMap.get("synapse/proxy-service")).add(dep);
                    continue block30;
                }
                case "synapse/task": {
                    ((List)artifactTypeMap.get("synapse/task")).add(dep);
                    continue block30;
                }
                case "synapse/event-source": {
                    ((List)artifactTypeMap.get("synapse/event-source")).add(dep);
                    continue block30;
                }
                case "synapse/message-processors": {
                    ((List)artifactTypeMap.get("synapse/message-processors")).add(dep);
                    continue block30;
                }
                case "synapse/api": {
                    ((List)artifactTypeMap.get("synapse/api")).add(dep);
                    continue block30;
                }
                case "synapse/inbound-endpoint": {
                    ((List)artifactTypeMap.get("synapse/inbound-endpoint")).add(dep);
                    continue block30;
                }
            }
            ((List)artifactTypeMap.get("other")).add(dep);
        }
        return artifactTypeMap;
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfig) throws DeploymentException {
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        Map<String, List<Artifact.Dependency>> artifactTypeMap = this.getOrderedArtifactsMap(artifacts);
        ArrayList<String> artifactTypesList = new ArrayList<String>(artifactTypeMap.keySet());
        Collections.reverse(artifactTypesList);
        for (String artifactType : artifactTypesList) {
            this.undeployArtifactType(carbonApplication, axisConfig, artifactTypeMap.get(artifactType));
        }
    }

    private void undeployArtifactType(CarbonApplication carbonApplication, AxisConfiguration axisConfig, List<Artifact.Dependency> artifacts) {
        for (Artifact.Dependency dep : artifacts) {
            Deployer deployer;
            Artifact artifact = dep.getArtifact();
            if (!this.validateArtifact(artifact)) continue;
            String artifactDir = null;
            if ("lib/synapse/mediator".endsWith(artifact.getType())) {
                deployer = this.getClassMediatorDeployer(axisConfig);
            } else if ("synapse/lib".equals(artifact.getType())) {
                deployer = this.getSynapseLibraryDeployer(axisConfig);
            } else {
                String artifactType = artifact.getType();
                String artifactDirName = this.getArtifactDirName(artifactType);
                if (artifactDirName == null) continue;
                deployer = this.getDeployer(artifact.getType());
                artifactDir = this.getArtifactDirPath(axisConfig, artifactDirName);
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = null;
            if (!StringUtils.isEmpty((String)fileName)) {
                artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            }
            if (deployer != null && "Deployed".equals(artifact.getDeploymentStatus())) {
                String artifactName = artifact.getName();
                File artifactInRepo = new File(artifactDir + File.separator + fileName);
                try {
                    if ("lib/synapse/mediator".endsWith(artifact.getType())) {
                        if (deployer instanceof AbstractSynapseArtifactDeployer) {
                            ((AbstractSynapseArtifactDeployer)deployer).setCustomLog(carbonApplication.getAppName(), AppDeployerUtils.getTenantIdLogString((int)AppDeployerUtils.getTenantId()));
                        }
                        deployer.undeploy(artifactPath);
                    } else if ("synapse/lib".equals(artifact.getType())) {
                        String libQName = this.getArtifactName(artifactPath, axisConfig);
                        this.deleteImport(libQName, axisConfig);
                        deployer.undeploy(artifactPath);
                    } else if ("synapse/sequence".equals(artifact.getType()) && this.handleMainFaultSeqUndeployment(artifact, axisConfig)) {
                        log.debug((Object)"Handling main and fault sequence un-deployment");
                    } else if (artifactInRepo.exists()) {
                        log.info((Object)("Deleting artifact at " + artifactInRepo.getAbsolutePath()));
                        if (!artifactInRepo.delete()) {
                            log.error((Object)("Unable to delete " + artifactInRepo.getAbsolutePath()));
                        }
                    } else {
                        if (artifact.getType().equals("synapse/api")) {
                            OMElement apiElement = new StAXOMBuilder((InputStream)new FileInputStream(new File(artifactPath))).getDocumentElement();
                            API api = DeployerUtil.partiallyBuildAPI(apiElement);
                            artifactName = api.getName();
                        }
                        Class[] paramString = new Class[]{String.class};
                        Method method = deployer.getClass().getDeclaredMethod("undeploySynapseArtifact", paramString);
                        method.invoke((Object)deployer, artifactName);
                    }
                    artifact.setDeploymentStatus("Pending");
                    File artifactFile = new File(artifactPath);
                    if (artifactFile.exists() && !artifactFile.delete()) {
                        log.warn((Object)("Couldn't delete App artifact file : " + artifactPath));
                    }
                }
                catch (Exception e) {
                    artifact.setDeploymentStatus("Failed");
                    log.error((Object)("Error occured while trying to un deploy : " + artifactName));
                }
            }
            JsonObject undeployedArtifact = this.createUpdatedArtifactInfoObject(artifact, artifactPath, false);
            ArtifactDeploymentListener.addToUndeployedArtifactsQueue(undeployedArtifact);
        }
    }

    private void deployClassMediators(List<Artifact.Dependency> artifacts, AxisConfiguration axisConfig) throws DeploymentException {
        for (Artifact.Dependency dependency : artifacts) {
            Deployer deployer;
            Artifact artifact = dependency.getArtifact();
            if (!this.validateArtifact(artifact) || !"lib/synapse/mediator".endsWith(artifact.getType()) || (deployer = this.getClassMediatorDeployer(axisConfig)) == null) continue;
            artifact.setRuntimeObjectName(artifact.getName());
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            try {
                deployer.deploy(new DeploymentFileData(new File(artifactPath), deployer));
                artifact.setDeploymentStatus("Deployed");
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                throw e;
            }
        }
    }

    private void deploySynapseLibrary(List<Artifact.Dependency> artifacts, AxisConfiguration axisConfig) throws DeploymentException {
        for (Artifact.Dependency dependency : artifacts) {
            Deployer deployer;
            Artifact artifact = dependency.getArtifact();
            if (!this.validateArtifact(artifact) || !"synapse/lib".equals(artifact.getType()) || (deployer = this.getSynapseLibraryDeployer(axisConfig)) == null) continue;
            artifact.setRuntimeObjectName(artifact.getName());
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            String artifactDir = this.getArtifactDirPath(axisConfig, "synapse-libs");
            File artifactInRepo = new File(artifactDir + File.separator + fileName);
            if (artifactInRepo.exists()) {
                log.warn((Object)("Synapse Library " + fileName + " already found in " + artifactInRepo.getAbsolutePath() + ". Ignoring CAPP's artifact"));
                artifact.setDeploymentStatus("Deployed");
                continue;
            }
            try {
                deployer.deploy(new DeploymentFileData(new File(artifactPath), deployer));
                artifact.setDeploymentStatus("Deployed");
                try {
                    String artifactName = this.getArtifactName(artifactPath, axisConfig);
                    SynapseConfiguration configuration = this.getSynapseConfiguration(axisConfig);
                    if (artifactName == null || configuration.getSynapseImports().get(artifactName) != null) continue;
                    String libName = artifactName.substring(artifactName.lastIndexOf("}") + 1);
                    String libraryPackage = artifactName.substring(1, artifactName.lastIndexOf("}"));
                    this.updateStatus(artifactName, libName, libraryPackage, "enabled", axisConfig);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Unable to update status for the synapse library : " + axisFault.getMessage()));
                }
                catch (NullPointerException nullException) {
                    log.error((Object)("Error while getting qualified name of the synapse library : " + nullException.getMessage()));
                }
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                log.error((Object)("Error while deploying the synapse library : " + e.getMessage()));
                throw e;
            }
        }
    }

    public String getArtifactName(String filePath, AxisConfiguration axisConfig) throws DeploymentException {
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration(axisConfig).getArtifactDeploymentStore();
        return deploymentStore.getArtifactNameForFile(filePath);
    }

    protected SynapseConfiguration getSynapseConfiguration(AxisConfiguration axisConfig) {
        return (SynapseConfiguration)axisConfig.getParameter("synapse.config").getValue();
    }

    public boolean updateStatus(String libQName, String libName, String packageName, String status, AxisConfiguration axisConfig) throws AxisFault {
        try {
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration(axisConfig);
            SynapseImport synapseImport = (SynapseImport)synapseConfiguration.getSynapseImports().get(libQName);
            if (synapseImport == null && libName != null && packageName != null) {
                this.addImport(libName, packageName, axisConfig);
                synapseImport = (SynapseImport)synapseConfiguration.getSynapseImports().get(libQName);
            }
            Library synLib = (Library)synapseConfiguration.getSynapseLibraries().get(libQName);
            if (libQName != null && synLib != null) {
                if ("enabled".equals(status)) {
                    synapseImport.setStatus(true);
                    synLib.setLibStatus(true);
                    synLib.loadLibrary();
                    this.deployingLocalEntries(synLib, synapseConfiguration, axisConfig);
                } else {
                    synapseImport.setStatus(false);
                    synLib.setLibStatus(false);
                    synLib.unLoadLibrary();
                    this.undeployingLocalEntries(synLib, synapseConfiguration, axisConfig);
                }
            }
        }
        catch (Exception e) {
            String message = "Unable to update status for :  " + libQName;
            this.handleException(log, message, e);
        }
        return true;
    }

    public void addImport(String libName, String packageName, AxisConfiguration axisConfig) throws AxisFault {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(libName);
        synImport.setLibPackage(packageName);
        OMElement impEl = SynapseImportSerializer.serializeImport((SynapseImport)synImport);
        if (impEl != null) {
            try {
                this.addImport(impEl.toString(), axisConfig);
            }
            catch (AxisFault axisFault) {
                this.handleException(log, "Could not add Synapse Import", (Exception)((Object)axisFault));
            }
        } else {
            this.handleException(log, "Could not add Synapse Import. Invalid import params for libName : " + libName + " packageName : " + packageName, null);
        }
    }

    private void undeployingLocalEntries(Library library, SynapseConfiguration config, AxisConfiguration axisConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Removing Local registry entries from the configuration");
        }
        for (Map.Entry libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = LocalEntryUtil.getOMElement(localEntryFileObj);
            this.deleteEntry(document.toString(), axisConfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Removing Local registry entries from the configuration");
        }
    }

    private void addImport(String xml, AxisConfiguration axisConfig) throws AxisFault {
        try {
            OMElement imprtElem = this.createElement(xml);
            SynapseImport synapseImport = SynapseImportFactory.createImport((OMElement)imprtElem, null);
            if (synapseImport != null && synapseImport.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration(axisConfig);
                String fileName = ServiceBusUtils.generateFileName(synapseImport.getName());
                synapseImport.setFileName(fileName);
                synapseConfiguration.addSynapseImport(synapseImport.getName(), synapseImport);
                String synImportQualfiedName = LibDeployerUtils.getQualifiedName((SynapseImport)synapseImport);
                Library synLib = (Library)synapseConfiguration.getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    LibDeployerUtils.loadLibArtifacts((SynapseImport)synapseImport, (Library)synLib);
                }
            } else {
                String message = "Unable to create a Synapse Import for :  " + xml;
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create a Synapse Import for :  " + xml;
            this.handleException(log, message, e);
        }
    }

    private OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    protected MediationPersistenceManager getMediationPersistenceManager(AxisConfiguration axisConfig) {
        return ServiceBusUtils.getMediationPersistenceManager(axisConfig);
    }

    private void deployingLocalEntries(Library library, SynapseConfiguration config, AxisConfiguration axisConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Adding Local registry entries to the configuration");
        }
        for (Map.Entry libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = LocalEntryUtil.getOMElement(localEntryFileObj);
            this.addEntry(document.toString(), axisConfig);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Adding Local registry entries to the configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEntry(String ele, AxisConfiguration axisConfig) {
        Lock lock = this.getLock(axisConfig);
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = LocalEntryUtil.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error while converting the file content : " + e.getMessage()));
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                String entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration(axisConfig);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding local entry with key : " + entryKey));
                }
                if (synapseConfiguration.getLocalRegistry().containsKey(entryKey)) {
                    log.error((Object)("An Entry with key " + entryKey + " is already used within the configuration"));
                } else {
                    Entry entry = EntryFactory.createEntry((OMElement)elem, (Properties)synapseConfiguration.getProperties());
                    entry.setFileName(ServiceBusUtils.generateFileName(entry.getKey()));
                    synapseConfiguration.addEntry(entryKey, entry);
                    MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager(axisConfig);
                    pm.saveItem(entry.getKey(), 4);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local registry entry : " + entryKey + " added to the configuration"));
                }
                boolean bl = true;
                return bl;
            }
            log.warn((Object)"Error adding local entry. Invalid definition");
        }
        catch (SynapseException syne) {
            log.error((Object)"Unable to add local entry ", (Throwable)syne);
        }
        catch (OMException e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String ele, AxisConfiguration axisConfig) {
        Lock lock = this.getLock(axisConfig);
        String entryKey = null;
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = LocalEntryUtil.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error while converting the file content : " + e.getMessage()));
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                log.debug((Object)("Adding local entry with key : " + entryKey));
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration(axisConfig);
                Entry entry = (Entry)synapseConfiguration.getDefinedEntries().get(entryKey);
                if (entry != null) {
                    synapseConfiguration.removeEntry(entryKey);
                    MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager(axisConfig);
                    pm.deleteItem(entryKey, entry.getFileName(), 4);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleted local entry with key : " + entryKey));
                    }
                    boolean bl = true;
                    return bl;
                }
                log.warn((Object)("No entry exists by the key : " + entryKey));
                boolean bl = false;
                return bl;
            }
        }
        catch (SynapseException syne) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)syne);
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    protected Lock getLock(AxisConfiguration axisConfig) {
        Parameter p = axisConfig.getParameter("synapse.config.lock");
        if (p != null) {
            return (Lock)p.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            axisConfig.addParameter("synapse.config.lock", (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock");
            return null;
        }
    }

    public void deleteImport(String importQualifiedName, AxisConfiguration axisConfig) throws AxisFault {
        try {
            SynapseConfiguration configuration = this.getSynapseConfiguration(axisConfig);
            assert (configuration != null);
            if (configuration.getSynapseImports().containsKey(importQualifiedName)) {
                SynapseImport synapseImport = configuration.removeSynapseImport(importQualifiedName);
                String fileName = synapseImport.getFileName();
                Library synLib = (Library)configuration.getSynapseLibraries().get(importQualifiedName);
                if (synLib != null) {
                    synLib.unLoadLibrary();
                    this.undeployingLocalEntries(synLib, configuration, axisConfig);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while deleting the synapse library import");
        }
    }

    private boolean handleMainFaultSeqDeployment(Artifact artifact, AxisConfiguration axisConfig, Deployer deployer) throws DeploymentException {
        String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
        String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
        boolean isMainOrFault = false;
        if (fileName.matches(MAIN_SEQ_REGEX) || fileName.matches("main.xml")) {
            isMainOrFault = true;
            try {
                String mainXMLPath = this.getMainXmlPath(axisConfig);
                log.info((Object)("Copying main sequence to " + mainXMLPath));
                FileUtils.copyFile((File)new File(artifactPath), (File)new File(mainXMLPath));
                if (!MicroIntegratorBaseUtils.getCarbonAxisConfigurator().isHotDeploymentEnabled()) {
                    deployer.deploy(new DeploymentFileData(new File(mainXMLPath), deployer));
                }
                artifact.setDeploymentStatus("Deployed");
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                throw e;
            }
            catch (IOException e) {
                log.error((Object)"Error copying main.xml to sequence directory", (Throwable)e);
            }
            catch (Throwable throwable) {
                artifact.setDeploymentStatus("Failed");
                throw new DeploymentException(throwable);
            }
            finally {
                this.setCustomLogContent(deployer, null);
                CustomLogSetter.getInstance().clearThreadLocalContent();
            }
        } else if (fileName.matches(FAULT_SEQ_REGEX) || fileName.matches("fault.xml")) {
            isMainOrFault = true;
            try {
                String faultXMLPath = this.getFaultXmlPath(axisConfig);
                log.info((Object)("Copying fault sequence to " + faultXMLPath));
                FileUtils.copyFile((File)new File(artifactPath), (File)new File(faultXMLPath));
                if (!MicroIntegratorBaseUtils.getCarbonAxisConfigurator().isHotDeploymentEnabled()) {
                    deployer.deploy(new DeploymentFileData(new File(faultXMLPath), deployer));
                }
                artifact.setDeploymentStatus("Deployed");
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                throw e;
            }
            catch (IOException e) {
                log.error((Object)"Error copying main.xml to sequence directory", (Throwable)e);
            }
            catch (Throwable throwable) {
                artifact.setDeploymentStatus("Failed");
                throw new DeploymentException(throwable);
            }
            finally {
                this.setCustomLogContent(deployer, null);
                CustomLogSetter.getInstance().clearThreadLocalContent();
            }
        }
        return isMainOrFault;
    }

    private boolean handleMainFaultSeqUndeployment(Artifact artifact, AxisConfiguration axisConfig) throws IOException {
        boolean isMainOrFault = false;
        String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
        if (fileName.matches(MAIN_SEQ_REGEX) || fileName.matches("main.xml")) {
            isMainOrFault = true;
            String mainXMLPath = this.getMainXmlPath(axisConfig);
            FileUtils.deleteQuietly((File)new File(mainXMLPath));
            FileUtils.writeStringToFile((File)new File(mainXMLPath), (String)MAIN_XML);
        } else if (fileName.matches(FAULT_SEQ_REGEX) || fileName.matches("fault.xml")) {
            isMainOrFault = true;
            String faultXMLPath = this.getFaultXmlPath(axisConfig);
            FileUtils.deleteQuietly((File)new File(faultXMLPath));
            FileUtils.writeStringToFile((File)new File(faultXMLPath), (String)FAULT_XML);
        }
        return isMainOrFault;
    }

    private boolean isAccepted(String serviceType) {
        return true;
    }

    private boolean validateArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        if (!this.isAccepted(artifact.getType())) {
            log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
            return false;
        }
        List files = artifact.getFiles();
        if (files.size() != 1) {
            log.error((Object)("Synapse artifact types must have a single file to be deployed. But " + files.size() + " files found."));
            return false;
        }
        return true;
    }

    private Deployer getClassMediatorDeployer(AxisConfiguration axisConfig) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        String classMediatorPath = axisConfig.getRepository().getPath() + File.separator + "class-mediators";
        return deploymentEngine.getDeployer(classMediatorPath, "jar");
    }

    private Deployer getSynapseLibraryDeployer(AxisConfiguration axisConfig) {
        try {
            String synapseLibraryPath = axisConfig.getRepository().getPath() + "synapse-libs";
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            deploymentEngine.addDeployer((Deployer)new LibraryArtifactDeployer(), synapseLibraryPath, "zip");
            return deploymentEngine.getDeployer(synapseLibraryPath, "zip");
        }
        catch (Exception e) {
            log.error((Object)"Error occured while getting the deployer");
            return null;
        }
    }

    private String getArtifactDirName(String artifactType) {
        if ("synapse/sequence".equals(artifactType)) {
            return "sequences";
        }
        if ("synapse/endpoint".equals(artifactType)) {
            return "endpoints";
        }
        if ("synapse/proxy-service".equals(artifactType)) {
            return "proxy-services";
        }
        if ("synapse/local-entry".equals(artifactType)) {
            return "local-entries";
        }
        if ("synapse/event-source".equals(artifactType)) {
            return "event-sources";
        }
        if ("synapse/task".equals(artifactType)) {
            return "tasks";
        }
        if ("synapse/message-store".endsWith(artifactType)) {
            return "message-stores";
        }
        if ("synapse/message-processors".endsWith(artifactType)) {
            return "message-processors";
        }
        if ("synapse/api".endsWith(artifactType)) {
            return "api";
        }
        if ("synapse/template".endsWith(artifactType)) {
            return "templates";
        }
        if ("synapse/inbound-endpoint".endsWith(artifactType)) {
            return "inbound-endpoints";
        }
        if ("synapse/lib".equals(artifactType)) {
            return "synapse-libs";
        }
        return null;
    }

    private String getArtifactDirPath(AxisConfiguration axisConfiguration, String artifactDirName) {
        if (artifactDirName.equals("synapse-libs")) {
            return axisConfiguration.getRepository().getPath() + "synapse-libs";
        }
        return axisConfiguration.getRepository().getPath() + "synapse-configs" + File.separator + "default" + File.separator + artifactDirName;
    }

    private String getMainXmlPath(AxisConfiguration axisConfig) {
        return axisConfig.getRepository().getPath() + "synapse-configs" + File.separator + "default" + File.separator + "sequences" + File.separator + "main.xml";
    }

    private String getFaultXmlPath(AxisConfiguration axisConfig) {
        return axisConfig.getRepository().getPath() + "synapse-configs" + File.separator + "default" + File.separator + "sequences" + File.separator + "fault.xml";
    }

    public void setCustomLogContent(Deployer deployer, CarbonApplication carbonApp) {
        if (deployer instanceof AbstractSynapseArtifactDeployer) {
            if (carbonApp != null) {
                ((AbstractSynapseArtifactDeployer)deployer).setCustomLog(carbonApp.getAppName(), AppDeployerUtils.getTenantIdLogString((int)AppDeployerUtils.getTenantId()));
            } else {
                ((AbstractSynapseArtifactDeployer)deployer).setCustomLog(null, null);
            }
        }
    }

    public void deployArtifactType(List<Artifact.Dependency> artifacts, CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            String artifactType = artifact.getType();
            String artifactDirName = this.getArtifactDirName(artifactType);
            if (!this.validateArtifact(artifact) || artifactDirName == null) continue;
            Deployer deployer = this.getDeployer(artifact.getType());
            String artifactDir = this.getArtifactDirPath(axisConfig, artifactDirName);
            artifact.setRuntimeObjectName(artifact.getName());
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = null;
            if (!StringUtils.isEmpty((String)fileName)) {
                artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            }
            if (deployer != null) {
                File artifactInRepo = new File(artifactDir + File.separator + fileName);
                if ("synapse/sequence".equals(artifact.getType()) && this.handleMainFaultSeqDeployment(artifact, axisConfig, deployer)) {
                    log.debug((Object)"Handling main and fault sequence deployment");
                } else if (artifactInRepo.exists()) {
                    log.warn((Object)("Artifact " + fileName + " already found in " + artifactInRepo.getAbsolutePath() + ". Ignoring CAPP's artifact"));
                    artifact.setDeploymentStatus("Deployed");
                } else {
                    try {
                        this.setCustomLogContent(deployer, carbonApp);
                        deployer.deploy(new DeploymentFileData(new File(artifactPath), deployer));
                        artifact.setDeploymentStatus("Deployed");
                    }
                    catch (DeploymentException e) {
                        artifact.setDeploymentStatus("Failed");
                        throw e;
                    }
                    catch (Throwable throwable) {
                        artifact.setDeploymentStatus("Failed");
                        throw new DeploymentException(throwable);
                    }
                    finally {
                        this.setCustomLogContent(deployer, null);
                        CustomLogSetter.getInstance().clearThreadLocalContent();
                    }
                }
            }
            JsonObject deployedArtifact = this.createUpdatedArtifactInfoObject(artifact, artifactPath, true);
            ArtifactDeploymentListener.addToDeployedArtifactsQueue(deployedArtifact);
        }
    }

    private void initializeDefaultSynapseDeployers() {
        this.addSynapseDeployer("synapse/local-entry", (Deployer)new LocalEntryDeployer());
        this.addSynapseDeployer("synapse/endpoint", (Deployer)new EndpointDeployer());
        this.addSynapseDeployer("synapse/sequence", (Deployer)new SequenceDeployer());
        this.addSynapseDeployer("synapse/template", (Deployer)new TemplateDeployer());
        this.addSynapseDeployer("synapse/task", (Deployer)new TaskDeployer());
        this.addSynapseDeployer("synapse/message-store", (Deployer)new MessageStoreDeployer());
        this.addSynapseDeployer("synapse/message-processors", (Deployer)new MessageProcessorDeployer());
        this.addSynapseDeployer("synapse/inbound-endpoint", (Deployer)new InboundEndpointDeployer());
        this.addSynapseDeployer("synapse/api", (Deployer)new APIDeployer());
        this.addSynapseDeployer("synapse/proxy-service", (Deployer)new ProxyServiceDeployer());
    }

    private Deployer getDeployer(String type) {
        return this.synapseDeployers.get(type);
    }

    private void addSynapseDeployer(String type, Deployer deployer) {
        ConfigurationContext configContext = ConfigurationHolder.getInstance().getAxis2ConfigurationContextService().getServerConfigContext();
        if (deployer == null) {
            log.error((Object)"Failed to add Deployer : deployer is null");
            return;
        }
        if (configContext != null) {
            deployer.init(configContext);
            this.registerSynapseDeployer(configContext.getAxisConfiguration(), type, deployer);
        } else {
            log.warn((Object)("ConfigurationContext has not been set. Deployer: " + deployer.getClass() + "is not initialized"));
        }
        this.synapseDeployers.put(type, deployer);
    }

    private void registerSynapseDeployer(AxisConfiguration axisConfig, String artifactType, Deployer deployer) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        String artifactDirName = this.getArtifactDirName(artifactType);
        if (artifactDirName != null) {
            SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration(axisConfig).getArtifactDeploymentStore();
            SynapseConfiguration synCfg = this.getSynapseConfiguration(axisConfig);
            String artifactDir = this.getArtifactDirPath(axisConfig, artifactDirName);
            switch (artifactType) {
                case "synapse/sequence": {
                    for (SequenceMediator seq : synCfg.getDefinedSequences().values()) {
                        if (seq.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + seq.getFileName());
                    }
                    break;
                }
                case "synapse/endpoint": {
                    for (Endpoint ep : synCfg.getDefinedEndpoints().values()) {
                        if (ep.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + ep.getFileName());
                    }
                    break;
                }
                case "synapse/proxy-service": {
                    for (ProxyService proxyService : synCfg.getProxyServices()) {
                        if (proxyService.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + proxyService.getFileName());
                    }
                    break;
                }
                case "synapse/local-entry": {
                    for (Entry entry : synCfg.getDefinedEntries().values()) {
                        if (entry.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + entry.getFileName());
                    }
                    break;
                }
                case "synapse/task": {
                    for (Startup stp : synCfg.getStartups()) {
                        if (stp.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + stp.getFileName());
                    }
                    break;
                }
                case "synapse/message-store": {
                    for (MessageStore messageStore : synCfg.getMessageStores().values()) {
                        if (messageStore.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + messageStore.getFileName());
                    }
                    break;
                }
                case "synapse/message-processors": {
                    for (MessageProcessor processor : synCfg.getMessageProcessors().values()) {
                        if (processor.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + processor.getFileName());
                    }
                    break;
                }
                case "synapse/api": {
                    for (API api : synCfg.getAPIs()) {
                        if (api.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + api.getFileName());
                    }
                    break;
                }
                case "synapse/template": {
                    for (TemplateMediator seqTempl : synCfg.getSequenceTemplates().values()) {
                        if (seqTempl.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + seqTempl.getFileName());
                    }
                    for (Template epTempl : synCfg.getEndpointTemplates().values()) {
                        if (epTempl.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + epTempl.getFileName());
                    }
                    break;
                }
                case "synapse/inbound-endpoint": {
                    for (InboundEndpoint inboundEndpoint : synCfg.getInboundEndpoints()) {
                        if (inboundEndpoint.getFileName() == null) continue;
                        deploymentStore.addRestoredArtifact(artifactDir + File.separator + inboundEndpoint.getFileName());
                    }
                    break;
                }
            }
            deploymentEngine.addDeployer(deployer, artifactDir, "xml");
        }
    }

    private JsonObject createUpdatedArtifactInfoObject(Artifact artifact, String artifactPath, boolean isDeploy) {
        JsonObject artifactInfo = new JsonObject();
        String type = this.getArtifactDirName(artifact.getType());
        String name = artifact.getName();
        if ("api".equals(type)) {
            type = "apis";
        } else if ("synapse-libs".equals(type)) {
            type = "connectors";
            name = this.getConnectorName(name);
        }
        if (isDeploy && "templates".equals(type)) {
            name = this.getTemplateName(artifactPath, name);
        }
        artifactInfo.addProperty("type", type);
        artifactInfo.addProperty("name", name);
        artifactInfo.addProperty("version", artifact.getVersion());
        return artifactInfo;
    }

    private String getConnectorName(String artifactName) {
        return artifactName.substring(0, artifactName.lastIndexOf("-connector"));
    }

    private String getTemplateName(String artifactPath, String name) {
        try {
            FileInputStream in = FileUtils.openInputStream((File)new File(artifactPath));
            OMElement artifactConfig = new StAXOMBuilder(StAXUtils.createXMLStreamReader((InputStream)in)).getDocumentElement();
            OMElement element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
            if (null != element) {
                return "endpoint_".concat(name);
            }
            element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
            if (null != element) {
                return "sequence_".concat(name);
            }
        }
        catch (IOException | XMLStreamException e) {
            log.error((Object)("Error occurred while creating name of template located at " + artifactPath), (Throwable)e);
        }
        return name;
    }
}

