/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.handler.transaction;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.micro.core.util.StringUtils;
import org.wso2.micro.integrator.initializer.handler.DataHolder;
import org.wso2.micro.integrator.initializer.handler.transaction.TransactionCountHandler;
import org.wso2.micro.integrator.initializer.handler.transaction.exception.TransactionCounterInitializationException;
import org.wso2.micro.integrator.initializer.handler.transaction.security.CryptoUtil;
import org.wso2.micro.integrator.initializer.handler.transaction.store.TransactionStore;
import org.wso2.micro.integrator.ndatasource.common.DataSourceException;
import org.wso2.micro.integrator.ndatasource.core.CarbonDataSource;
import org.wso2.micro.integrator.ndatasource.core.DataSourceService;

public class TransactionCountHandlerComponent {
    private static final Log LOG = LogFactory.getLog(TransactionCountHandlerComponent.class);
    private static final int DEFAULT_UPDATE_INTERVAL = 1;
    private static final String TRANSACTION_COUNTER_SYS_PROPERTY_NAME = "enableTransactionCounter";
    private static final String TRANSACTION_CONFIG_SECTION = "transaction_counter";
    private static final String TRANSACTION_CONFIG_ENABLE = "enable";
    private static final String TRANSACTION_CONFIG_DATA_SOURCE = "data_source";
    private static final String TRANSACTION_CONFIG_UPDATE_INTERVAL = "update_interval";
    private ScheduledExecutorService txCountWriterTaskScheduler;

    public void start(DataSourceService dataSourceService) throws DataSourceException, TransactionCounterInitializationException {
        DataSource dataSource = this.getTransactionDataSource(dataSourceService);
        Cipher cipher = CryptoUtil.initializeCipher();
        String nodeId = this.generateRandomId();
        TransactionStore transactionStore = new TransactionStore(dataSource, nodeId, cipher);
        DataHolder.getInstance().setTransactionStore(transactionStore);
        this.scheduleTransactionWriterTask(transactionStore);
    }

    private int getTransactionCountUpdateInterval() {
        Object updateIntervalObject = ConfigParser.getParsedConfigs().get("transaction_counter.update_interval");
        if (null != updateIntervalObject) {
            String updateIntervalStr = updateIntervalObject.toString();
            try {
                return Integer.parseInt(updateIntervalStr);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Cannot parse the provided transaction count update period " + updateIntervalStr + " as an Integer. Hence, proceeding with default value (" + 1 + "min)"));
                return 1;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Transaction count update period is set to default value (1min).");
        }
        return 1;
    }

    private void scheduleTransactionWriterTask(TransactionStore transactionStore) {
        this.txCountWriterTaskScheduler = Executors.newSingleThreadScheduledExecutor();
        int updateInterval = this.getTransactionCountUpdateInterval();
        DataHolder.getInstance().setTransactionUpdateInterval(updateInterval);
        this.txCountWriterTaskScheduler.scheduleAtFixedRate(() -> {
            try {
                transactionStore.addTransaction();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added the current transaction count: " + TransactionCountHandler.getTransactionCount() + " to the database."));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Could not persist the transaction count: ", e);
            }
        }, 0L, updateInterval, TimeUnit.MINUTES);
    }

    private void stopTransactionWriterTask() {
        if (this.txCountWriterTaskScheduler != null) {
            this.txCountWriterTaskScheduler.shutdownNow();
        }
    }

    private String generateRandomId() {
        return UUID.randomUUID().toString();
    }

    private DataSource getTransactionDataSource(DataSourceService dataSourceService) throws DataSourceException, TransactionCounterInitializationException {
        String dataSourceId = this.getTransactionDatasourceId();
        CarbonDataSource dataSource = dataSourceService.getDataSource(dataSourceId);
        if (Objects.isNull(dataSource)) {
            throw new DataSourceException("DataSource " + dataSourceId + " is not configured properly.");
        }
        Object transactionDataSourceObject = dataSource.getDSObject();
        if (!(transactionDataSourceObject instanceof DataSource)) {
            throw new DataSourceException("DataSource is not an RDBMS data source.");
        }
        return (DataSource)transactionDataSourceObject;
    }

    private String getTransactionDatasourceId() throws TransactionCounterInitializationException {
        Object dataSourceIdObject = ConfigParser.getParsedConfigs().get("transaction_counter.data_source");
        if (dataSourceIdObject != null) {
            return dataSourceIdObject.toString();
        }
        LOG.error((Object)"DataSource is not configured for transaction component.");
        throw new TransactionCounterInitializationException("DataSource is not configured for transaction component.");
    }

    public static boolean isTransactionPropertyEnabled() {
        Object updatePeriodObject;
        String transactionCounterPropertyStr = System.getProperty(TRANSACTION_COUNTER_SYS_PROPERTY_NAME);
        if (StringUtils.isEmpty((String)transactionCounterPropertyStr) && StringUtils.isEmpty((String)(transactionCounterPropertyStr = System.getenv(TRANSACTION_COUNTER_SYS_PROPERTY_NAME))) && Objects.nonNull(updatePeriodObject = ConfigParser.getParsedConfigs().get("transaction_counter.enable"))) {
            transactionCounterPropertyStr = updatePeriodObject.toString();
        }
        return "true".equalsIgnoreCase(transactionCounterPropertyStr);
    }

    public void cleanup() {
        this.stopTransactionWriterTask();
    }
}

