/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.handler.transaction.security;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.integrator.initializer.handler.transaction.TransactionConstants;
import org.wso2.micro.integrator.initializer.handler.transaction.exception.TransactionCounterException;
import org.wso2.micro.integrator.initializer.handler.transaction.exception.TransactionCounterInitializationException;

public class CryptoUtil {
    private static final Log LOG = LogFactory.getLog(CryptoUtil.class);

    private CryptoUtil() {
    }

    public static Cipher initializeCipher() throws TransactionCounterInitializationException {
        Cipher cipher;
        try {
            PublicKey publicKey = CryptoUtil.loadPublicKey();
            cipher = Cipher.getInstance("RSA/ECB/OAEPwithSHA1andMGF1Padding");
            cipher.init(1, publicKey);
            LOG.debug((Object)"Successfully initialized the Cipher to be used in the transaction count encryption process in the Transaction Count Handler component.");
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new TransactionCounterInitializationException("Error initializing Cipher ", e);
        }
        return cipher;
    }

    public static String doEncryption(Cipher cipher, String plainTextValue) throws TransactionCounterException {
        String encodedValue;
        try {
            byte[] encryptedPassword = cipher.doFinal(plainTextValue.getBytes(StandardCharsets.UTF_8));
            encodedValue = DatatypeConverter.printBase64Binary((byte[])encryptedPassword);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new TransactionCounterException("Error encrypting transaction count ", e);
        }
        return encodedValue;
    }

    private static PublicKey loadPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        String publicKeyPEM = FileUtils.readFileToString((File)new File(TransactionConstants.PUBLIC_KEY), (Charset)StandardCharsets.UTF_8);
        publicKeyPEM = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        byte[] publicKeyDER = Base64.getDecoder().decode(publicKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyDER));
    }
}

