/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.endpoints.TemplateSerializer;
import org.apache.synapse.endpoints.Template;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class EndpointTemplateStore
extends AbstractStore<Template> {
    public EndpointTemplateStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected String getFileName(Template template) {
        return template.getFileName();
    }

    @Override
    protected Template getObjectToPersist(String name, SynapseConfiguration config) {
        return (Template)config.getEndpointTemplates().get(name);
    }

    @Override
    protected OMElement saveToFile(Template template, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeTemplate(template, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the template: " + template.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(Template endpointTemplate) {
        TemplateSerializer serializer = new TemplateSerializer();
        return serializer.serializeEndpointTemplate(endpointTemplate, null);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfig) {
        File templateDir = new File(this.configPath, "templates");
        if (!templateDir.exists()) {
            return;
        }
        File templateFile = new File(templateDir, fileName);
        synapseConfig.getArtifactDeploymentStore().addBackedUpArtifact(templateFile.getAbsolutePath());
        templateFile.delete();
    }
}

