/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.registry.Registry;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class SynapseRegistryStore
extends AbstractStore<Registry> {
    public SynapseRegistryStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    public void save(String name, SynapseConfiguration config) {
        if (name == null) {
            this.log.warn((Object)"Name of the configuration item is not given");
            return;
        }
        Registry registry = this.getObjectToPersist(name, config);
        if (registry == null) {
            this.log.warn((Object)"Unable to find the Synapse registry for persistence");
            return;
        }
        try {
            if (!Boolean.valueOf(config.getProperty("__separateRegDef")).booleanValue()) {
                this.serializer.serializeSynapseXML(config);
            } else {
                this.serializer.serializeSynapseRegistry(registry, config, null);
            }
        }
        catch (Exception e) {
            this.handleException("Error while saving the mediation registry to the file system", e);
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File rootDir = new File(this.configPath);
        if (!rootDir.exists()) {
            return;
        }
        File registryFile = new File(this.configPath, fileName);
        registryFile.delete();
    }

    @Override
    protected String getFileName(Registry registry) {
        return null;
    }

    @Override
    protected Registry getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getRegistry();
    }

    @Override
    protected OMElement saveToFile(Registry registry, SynapseConfiguration synapseConfiguration) {
        return null;
    }

    @Override
    protected OMElement serialize(Registry registry) {
        return RegistrySerializer.serializeRegistry(null, (Registry)registry);
    }
}

