/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.resolvers.ResolverException;
import org.apache.synapse.commons.resolvers.SystemResolver;
import org.apache.synapse.config.SynapseConfigUtils;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.micro.application.deployer.AppDeployerUtils;
import org.wso2.micro.application.deployer.CarbonApplication;
import org.wso2.micro.core.util.CarbonException;
import org.wso2.micro.core.util.StringUtils;
import org.wso2.micro.integrator.initializer.deployment.application.deployer.CappDeployer;
import org.wso2.micro.integrator.initializer.utils.ServiceMetaDataHolder;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ServiceCatalogUtils {
    private static final Log log = LogFactory.getLog(ServiceCatalogUtils.class);
    private static SecretResolver secretResolver;
    private static List<ServiceMetaDataHolder> md5List;
    private static Boolean alreadyUploaded;
    private static String resolvedHostName;
    private static String httpListenerPort;
    private static String httpsListenerPort;
    private static String resolvedUrl;
    private static String lineSeparator;
    private static Map<String, Object> parsedConfigs;

    private static String updateServiceUrl(String currentUrl) throws ResolverException {
        SystemResolver resolver = new SystemResolver();
        if (parsedConfigs == null) {
            parsedConfigs = ConfigParser.getParsedConfigs();
        }
        if (currentUrl.contains("{MI_HOST}") || currentUrl.contains("{MI_PORT}")) {
            if (currentUrl.contains("{MI_HOST}")) {
                if (resolvedHostName == null) {
                    try {
                        resolver.setVariable("MI_HOST");
                        resolvedHostName = resolver.resolve();
                    }
                    catch (ResolverException e) {
                        resolvedHostName = (String)parsedConfigs.get("server.hostname");
                    }
                }
                currentUrl = currentUrl.replace("{MI_HOST}", resolvedHostName);
            }
            if (currentUrl.contains("{MI_PORT}")) {
                if (currentUrl.startsWith("https")) {
                    if (httpsListenerPort == null) {
                        try {
                            resolver.setVariable("MI_PORT");
                            httpsListenerPort = resolver.resolve();
                        }
                        catch (ResolverException e) {
                            int portOffset = Integer.parseInt(System.getProperty("portOffset"));
                            int httpsPort = Integer.parseInt((String)parsedConfigs.get("transport.https.listener.parameter.port"));
                            httpsListenerPort = String.valueOf(httpsPort + portOffset);
                        }
                    }
                    currentUrl = currentUrl.replace("{MI_PORT}", httpsListenerPort);
                } else if (currentUrl.startsWith("http")) {
                    if (httpListenerPort == null) {
                        try {
                            resolver.setVariable("MI_PORT");
                            httpListenerPort = resolver.resolve();
                        }
                        catch (ResolverException e) {
                            int portOffset = Integer.parseInt(System.getProperty("portOffset"));
                            int httpsPort = Integer.parseInt((String)parsedConfigs.get("transport.http.listener.parameter.port"));
                            httpListenerPort = String.valueOf(httpsPort + portOffset);
                        }
                    }
                    currentUrl = currentUrl.replace("{MI_PORT}", httpListenerPort);
                }
            }
        } else if (currentUrl.contains("{MI_URL}")) {
            if (resolvedUrl == null) {
                resolver.setVariable("MI_URL");
                resolvedUrl = resolver.resolve();
            }
            currentUrl = currentUrl.replace("MI_URL", resolvedUrl);
        }
        return currentUrl;
    }

    public static String updateMetadataWithServiceUrl(File yamlFile) throws IOException, ResolverException {
        Yaml yaml = new Yaml();
        FileInputStream yamlStream = new FileInputStream(yamlFile);
        Map obj = (Map)yaml.load((InputStream)yamlStream);
        String currentServiceUrl = (String)obj.get("serviceUrl");
        obj.put("serviceUrl", ServiceCatalogUtils.updateServiceUrl(currentServiceUrl));
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml output = new Yaml(options);
        String updatedYaml = output.dump((Object)obj);
        DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(yamlFile, false));
        outputStream.write(updatedYaml.getBytes());
        outputStream.close();
        ((InputStream)yamlStream).close();
        return (String)obj.get("key");
    }

    public static void publishToAPIM(Map<String, String> apimConfigs, String attachmentFilePath) {
        int responseCode = ServiceCatalogUtils.uploadZip(apimConfigs, attachmentFilePath);
        if (responseCode == -1) {
            return;
        }
        switch (responseCode) {
            case 200: {
                log.info((Object)"Successfully updated the service catalog");
                break;
            }
            case 503: 
            case 504: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("APIM responds with the status code : " + responseCode + " start retrying"));
                }
                int retryCount = 3;
                for (int i = 0; i < retryCount; ++i) {
                    try {
                        log.info((Object)("Retrying to connect with APIM. Remaining retry count : " + (retryCount - i)));
                        Thread.sleep(2000L);
                        responseCode = ServiceCatalogUtils.uploadZip(apimConfigs, attachmentFilePath);
                        if (responseCode != 200) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Service catalog thread interrupted", (Throwable)e);
                    }
                }
                log.error((Object)("Could not connect with APIM after " + retryCount + " retries."));
                break;
            }
            case 401: {
                log.error((Object)"Unauthenticated, please verify the username and password provided for service catalog");
                break;
            }
            default: {
                log.error((Object)("Unknown response code received from the service catalog endpoint: " + responseCode));
            }
        }
    }

    public static Map<String, String> getAllServices(Map<String, String> apimConfigs) {
        HashMap<String, String> md5Map = new HashMap<String, String>();
        String APIMHost = apimConfigs.get("apim_host");
        String credentials = Base64.getEncoder().encodeToString((apimConfigs.get("username") + ":" + apimConfigs.get("password")).getBytes());
        APIMHost = APIMHost.endsWith("/") ? APIMHost + "api/am/service-catalog/v1/services" : APIMHost + "/" + "api/am/service-catalog/v1/services";
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(APIMHost).openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Authorization", "Basic " + credentials);
            connection.setHostnameVerifier(ServiceCatalogUtils.getHostnameVerifier());
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JsonParser parser = new JsonParser();
                JsonObject rootObject = parser.parse(response.toString()).getAsJsonObject();
                JsonArray serviceList = rootObject.getAsJsonArray("list");
                for (JsonElement service : serviceList) {
                    String serviceKey = ((JsonObject)service).get("serviceKey").getAsString();
                    String md5 = ((JsonObject)service).get("md5").getAsString();
                    md5Map.put(serviceKey, md5);
                }
                return md5Map;
            }
            log.error((Object)"Error occurred while fetching services from the service catalog");
        }
        catch (MalformedURLException e) {
            log.error((Object)("Service catalog url " + APIMHost + " is malformed. Please check the configuration"), (Throwable)e);
        }
        catch (MalformedJsonException e) {
            log.error((Object)"Invalid JSON response received from service catalog", (Throwable)e);
        }
        catch (ProtocolException e) {
            log.error((Object)"Error occurred while creating the connection with APIM", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while reading the response from service catalog", (Throwable)e);
        }
        return null;
    }

    private static int uploadZip(Map<String, String> apimConfigs, String attachmentFilePath) {
        try {
            String APIMHost = apimConfigs.get("apim_host");
            APIMHost = APIMHost.endsWith("/") ? APIMHost + "api/am/service-catalog/v1/services/import?overwrite=true" : APIMHost + "/" + "api/am/service-catalog/v1/services/import?overwrite=true";
            String encodeBytes = Base64.getEncoder().encodeToString((apimConfigs.get("username") + ":" + apimConfigs.get("password")).getBytes());
            File binaryFile = new File(attachmentFilePath);
            String boundary = "------------------------" + Long.toHexString(System.currentTimeMillis());
            String CRLF = "\r\n";
            HttpsURLConnection connection = (HttpsURLConnection)new URL(APIMHost).openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Authorization", "Basic " + encodeBytes);
            connection.setHostnameVerifier(ServiceCatalogUtils.getHostnameVerifier());
            OutputStream output = connection.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), true);
            writer.append("--").append(boundary).append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(binaryFile.getName()).append("\"").append(CRLF);
            writer.append("Content-Type: application/octet-stream").append(CRLF);
            writer.append(CRLF).flush();
            Files.copy(binaryFile.toPath(), output);
            output.flush();
            String verifier = new Gson().toJson(md5List);
            writer.append("--").append(boundary).append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"verifier\"").append(CRLF);
            writer.append(CRLF);
            writer.append(verifier).append(CRLF);
            writer.append(CRLF).append("--").append(boundary).append("--").flush();
            if (log.isDebugEnabled()) {
                String strCurrentLine;
                StringBuilder response = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((strCurrentLine = br.readLine()) != null) {
                    response.append(strCurrentLine);
                }
                br.close();
                log.debug((Object)("Response from APIM : " + response));
            }
            return connection.getResponseCode();
        }
        catch (MalformedURLException e) {
            log.error((Object)"Service catalog url is malformed, please check the configured APIM host", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while uploading metadata to service catalog endpoint", (Throwable)e);
        }
        return -1;
    }

    public static Map<String, String> readConfiguration(SecretCallbackHandlerService secretCallbackHandlerService) {
        String alias;
        HashMap<String, String> configMap = new HashMap<String, String>();
        Map catalogProperties = (Map)((ArrayList)ConfigParser.getParsedConfigs().get("service_catalog")).get(0);
        String apimHost = (String)catalogProperties.get("apim_host");
        String userName = (String)catalogProperties.get("username");
        String password = (String)catalogProperties.get("password");
        String executorThreads = (String)catalogProperties.get("executor_threads");
        if (secretResolver == null) {
            secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        }
        if (!secretResolver.isInitialized()) {
            secretResolver.init(secretCallbackHandlerService.getSecretCallbackHandler());
        }
        if (!StringUtils.isEmpty((String)(alias = MiscellaneousUtil.getProtectedToken((String)userName)))) {
            userName = secretResolver.resolve(alias);
        }
        if (!StringUtils.isEmpty((String)(alias = MiscellaneousUtil.getProtectedToken((String)password)))) {
            password = secretResolver.resolve(alias);
        }
        configMap.put("apim_host", apimHost);
        configMap.put("username", userName);
        configMap.put("password", password);
        configMap.put("executor_threads", executorThreads);
        return configMap;
    }

    private static boolean processMetadata(File tempDir, File metadataFolder, File metadataYamlFolder, Map<String, String> md5MapOfAllService) throws IOException, ResolverException, NoSuchAlgorithmException {
        String metaFileName = metadataYamlFolder.getName();
        return metaFileName.contains("_proxy") && !new File(metadataFolder, metaFileName.replaceAll("_metadata_", "_swagger_")).exists() ? ServiceCatalogUtils.processProxyServiceMetadata(tempDir, metadataYamlFolder, md5MapOfAllService) : ServiceCatalogUtils.processAPIMetadata(metadataFolder, metaFileName, tempDir, metadataYamlFolder, md5MapOfAllService);
    }

    private static boolean processAPIMetadata(File metadataFolder, String metaFileName, File tempDir, File metadataYamlFolder, Map<String, String> md5MapOfAllService) throws IOException, ResolverException, NoSuchAlgorithmException {
        String APIName = metaFileName.substring(0, metaFileName.indexOf("_metadata_"));
        String APIVersion = metaFileName.substring(metaFileName.lastIndexOf("_metadata_") + "_metadata_".length());
        File newMetaFile = new File(tempDir, APIName + "_v" + APIVersion);
        File newYamlFile = new File(newMetaFile, "metadata.yaml");
        File metadataYamlFile = new File(metadataYamlFolder, APIName + "_metadata-" + APIVersion + ".yaml");
        File swaggerFolder = new File(metadataFolder, APIName + "_swagger_" + APIVersion);
        File swaggerFile = new File(swaggerFolder, APIName + "_swagger-" + APIVersion + ".yaml");
        File newSwaggerFile = new File(newMetaFile, "definition.yaml");
        String key = ServiceCatalogUtils.updateMetadataWithServiceUrl(metadataYamlFile);
        String md5FromServer = md5MapOfAllService.get(key);
        String md5SumOfMetadata = ServiceCatalogUtils.getFileChecksum(metadataYamlFile);
        String md5SumOfSwagger = ServiceCatalogUtils.getFileChecksum(swaggerFile);
        String newMD5String = md5SumOfSwagger + md5SumOfMetadata;
        if (StringUtils.isEmpty((String)md5FromServer) || !newMD5String.equals(md5FromServer)) {
            if (!newMetaFile.mkdir()) {
                log.error((Object)"Could not create temporary files");
                return false;
            }
            FileUtils.copyFile((File)metadataYamlFile, (File)newYamlFile);
            FileUtils.copyFile((File)swaggerFile, (File)newSwaggerFile);
            md5List.add(new ServiceMetaDataHolder(key, StringUtils.isEmpty((String)md5FromServer) ? newMD5String : md5FromServer));
        } else {
            alreadyUploaded = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(APIName + " is already updated in the service catalog"));
            }
        }
        return true;
    }

    private static boolean processProxyServiceMetadata(File tempDir, File metadataYamlFolder, Map<String, String> md5MapOfAllService) throws IOException, ResolverException, NoSuchAlgorithmException {
        String metaFileName = metadataYamlFolder.getName();
        String proxyServiceName = metaFileName.substring(0, metaFileName.indexOf("_proxy_metadata_"));
        String proxyServiceVersion = metaFileName.substring(metaFileName.lastIndexOf("_metadata_") + "_metadata_".length());
        File newMetaFile = new File(tempDir, proxyServiceName + "_proxy" + "_v" + proxyServiceVersion);
        File newYamlFile = new File(newMetaFile, "metadata.yaml");
        File metadataYamlFile = new File(metadataYamlFolder, proxyServiceName + "_proxy" + "_metadata-" + proxyServiceVersion + ".yaml");
        String key = ServiceCatalogUtils.updateMetadataWithServiceUrl(metadataYamlFile);
        String md5FromServer = md5MapOfAllService.get(key);
        if (!ServiceCatalogUtils.readProxyServiceWSDL(metadataYamlFile, metadataYamlFolder)) {
            log.error((Object)("Could not find WSDL definition of proxy service: " + proxyServiceName));
            return false;
        }
        File wsdlFile = new File(metadataYamlFolder, "definition.wsdl");
        String md5SumOfMetadata = ServiceCatalogUtils.getFileChecksum(metadataYamlFile);
        String md5SumOfWSDL = ServiceCatalogUtils.getFileChecksum(wsdlFile);
        String newMD5String = md5SumOfWSDL + md5SumOfMetadata;
        if (StringUtils.isEmpty((String)md5FromServer) || !newMD5String.equals(md5FromServer)) {
            if (!newMetaFile.mkdir()) {
                log.error((Object)"Could not create temporary files");
                return false;
            }
            FileUtils.copyFile((File)metadataYamlFile, (File)newYamlFile);
            FileUtils.copyFile((File)wsdlFile, (File)new File(newMetaFile, wsdlFile.getName()));
            md5List.add(new ServiceMetaDataHolder(key, StringUtils.isEmpty((String)md5FromServer) ? newMD5String : md5FromServer));
        } else {
            alreadyUploaded = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(proxyServiceName + " is already updated in the service catalog"));
            }
        }
        return true;
    }

    public static boolean archiveDir(String destArchiveName, String sourceDir) {
        File zipDir = new File(sourceDir);
        if (zipDir.exists() && zipDir.list().length == 0) {
            if (alreadyUploaded.booleanValue()) {
                log.info((Object)"Service catalog already contains the latest configs, aborting the service-catalog uploader");
            } else {
                log.info((Object)"Metadata not included, hence not publishing to Service Catalog");
            }
            return false;
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destArchiveName));){
            ServiceCatalogUtils.zipDir(zipDir, zos, sourceDir);
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred while creating the archive", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static void zipDir(File zipDir, ZipOutputStream zos, String archiveSourceDir) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        for (String s : dirList) {
            int bytesIn;
            File f = new File(zipDir, s);
            zos.putNextEntry(new ZipEntry(ServiceCatalogUtils.getZipEntryPath(f, archiveSourceDir)));
            if (f.isDirectory()) {
                ServiceCatalogUtils.zipDir(f, zos, archiveSourceDir);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    private static String getZipEntryPath(File f, String archiveSourceDir) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }

    private static HostnameVerifier getHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    public static boolean checkPreConditions() {
        ArrayList<String> faultyCapps;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start service-catalog uploading process");
        }
        if (!(faultyCapps = new ArrayList<String>(CappDeployer.getFaultyCapps())).isEmpty()) {
            log.info((Object)"Faulty CAPPs detected - aborting the service-catalog uploader");
            return false;
        }
        ArrayList<CarbonApplication> deployedCapps = new ArrayList<CarbonApplication>(CappDeployer.getCarbonApps());
        if (deployedCapps.isEmpty()) {
            log.info((Object)"Cannot find carbon applications - aborting the service-catalog uploader");
            return false;
        }
        Collection APITable = SynapseConfigUtils.getSynapseConfiguration((String)"carbon.super").getAPIs();
        Collection proxyTable = SynapseConfigUtils.getSynapseConfiguration((String)"carbon.super").getProxyServices();
        if (APITable.isEmpty() && proxyTable.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find APIs or Proxy Services - aborting the service-catalog uploader");
            }
            return false;
        }
        return true;
    }

    public static boolean extractMetadataFromCAPPs(File targetDir, String repoLocation, Map<String, String> md5MapOfAllService) {
        FilenameFilter cappFilter = (f, name) -> name.endsWith(".car");
        FilenameFilter metaFilter = (f, name) -> name.contains("_metadata_");
        File cappFolder = new File(repoLocation, "carbonapps");
        File[] files = cappFolder.listFiles(cappFilter);
        if (files == null) {
            return false;
        }
        for (File file : files) {
            try {
                File[] metadataFolders;
                String tempExtractedDirPath = AppDeployerUtils.extractCarbonApp((String)file.getPath());
                File metadataFolder = new File(tempExtractedDirPath, "metadata");
                if (!metadataFolder.exists() || (metadataFolders = metadataFolder.listFiles(metaFilter)) == null) continue;
                for (File metadataYamlFolder : metadataFolders) {
                    if (ServiceCatalogUtils.processMetadata(targetDir, metadataFolder, metadataYamlFolder, md5MapOfAllService)) continue;
                    return false;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while processing the metadata files", (Throwable)e);
                return false;
            }
            catch (CarbonException e) {
                log.error((Object)"Error occurred when extracting the carbon application", (Throwable)e);
                return false;
            }
            catch (ResolverException e) {
                log.error((Object)"Environment variables are not configured correctly", (Throwable)e);
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Could not generate the MD5 sum", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static boolean createTemporaryFolders(String folderPath) {
        boolean created;
        File serviceCatalogFolder = new File(folderPath);
        if (serviceCatalogFolder.exists()) {
            try {
                FileUtils.forceDelete((File)serviceCatalogFolder);
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while removing temporary directories", (Throwable)e);
            }
        }
        if (!(created = serviceCatalogFolder.mkdir())) {
            log.error((Object)"Could not create temporary directories required for service catalog");
            return false;
        }
        File tempDir = new File(folderPath, "temp");
        if (tempDir.exists()) {
            tempDir.delete();
        }
        if (!(created = tempDir.mkdir())) {
            log.error((Object)"Could not create temporary directories required for service catalog");
        }
        return created;
    }

    private static String getFileChecksum(File file) throws NoSuchAlgorithmException, IOException {
        int bytesCount;
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        while ((bytesCount = fis.read(byteArray)) != -1) {
            md5Digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = md5Digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readProxyServiceWSDL(File metadataYamlFile, File storeLocation) {
        BufferedReader bufferedReader = null;
        try {
            String inputLine;
            String proxyServiceUrl = ServiceCatalogUtils.getProxyServiceUrlFromMetadata(metadataYamlFile);
            if (proxyServiceUrl == null) {
                boolean bl = false;
                return bl;
            }
            if (proxyServiceUrl.endsWith("/")) {
                proxyServiceUrl = proxyServiceUrl.substring(proxyServiceUrl.length() - 1);
            }
            proxyServiceUrl = proxyServiceUrl + "?wsdl";
            URL website = new URL(proxyServiceUrl);
            URLConnection connection = website.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder responseWSDL = new StringBuilder();
            if (lineSeparator == null) {
                lineSeparator = System.getProperty("line.separator");
            }
            while ((inputLine = bufferedReader.readLine()) != null) {
                responseWSDL.append(inputLine).append(lineSeparator);
            }
            if (responseWSDL.length() == 0) {
                boolean bl = false;
                return bl;
            }
            if (storeLocation.exists()) {
                Files.write(Paths.get(storeLocation.getAbsolutePath(), "definition.wsdl"), responseWSDL.toString().getBytes(), new OpenOption[0]);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while getting WSDL definition of the given proxy service", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the buffer reader", (Throwable)e);
                }
            }
        }
        return false;
    }

    private static String getProxyServiceUrlFromMetadata(File yamlFile) {
        Yaml yaml = new Yaml();
        String currentServiceUrl = null;
        try (FileInputStream yamlStream = new FileInputStream(yamlFile);){
            Map obj = (Map)yaml.load((InputStream)yamlStream);
            currentServiceUrl = (String)obj.get("serviceUrl");
        }
        catch (IOException e) {
            log.error((Object)"Failed to fetch serviceUrl from the metadata YAML file or file does not exist");
        }
        return currentServiceUrl;
    }

    public static boolean isServiceCatalogEnabled() {
        Map catalogProperties;
        return ConfigParser.getParsedConfigs().get("service_catalog") != null && (Boolean)(catalogProperties = (Map)((ArrayList)ConfigParser.getParsedConfigs().get("service_catalog")).get(0)).get("enable") != false;
    }

    public static int getExecutorThreadCount(Map<String, String> serviceCatalogConfig, int def) {
        String executorThreads = serviceCatalogConfig.get("executor_threads");
        if (executorThreads != null) {
            int threads;
            try {
                threads = Integer.parseInt(executorThreads);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Service Catalog Executor Thread count is set to " + threads));
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid Service Catalog Executor Thread count. Setting to default " + def));
                return def;
            }
            return threads;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service Catalog Executor Thread count is not defined. Setting to default " + def));
        }
        return def;
    }

    static {
        md5List = new ArrayList<ServiceMetaDataHolder>();
        alreadyUploaded = false;
    }
}

