/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.CMISExtensionFactory;
import org.xcmis.restatom.abdera.PropertyDefinitionTypeElement;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefinitionTypeElement
extends ExtensibleElementWrapper {
    public TypeDefinitionTypeElement(Element internal) {
        super(internal);
    }

    public TypeDefinitionTypeElement(Factory factory, QName qname) {
        super(factory, qname);
    }

    public Map<String, PropertyDefinition<?>> getPropertyDefinitions() {
        HashMap propDefs = new HashMap();
        for (QName q : AtomCMIS.PROPERTY_DEFINITIONS) {
            PropertyDefinitionTypeElement propDefEl = (PropertyDefinitionTypeElement)this.getExtension(q);
            if (propDefEl == null) continue;
            PropertyDefinition<?> propDef = propDefEl.getPropertyDefinition();
            propDefs.put(propDef.getId(), propDef);
        }
        return propDefs;
    }

    public TypeDefinition getTypeDefinition() {
        BaseType baseType;
        String baseId = this.getSimpleExtension(AtomCMIS.BASE_ID);
        try {
            baseType = BaseType.fromValue((String)baseId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Unable to parse Type Definition element. Unknown baseTypeId " + baseId);
        }
        TypeDefinition type = new TypeDefinition();
        switch (baseType) {
            case DOCUMENT: {
                type.setVersionable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.VERSIONABLE)));
                String contentAllowed = this.getSimpleExtension(AtomCMIS.CONTENT_STREAM_ALLOWED);
                try {
                    type.setContentStreamAllowed(ContentStreamAllowed.fromValue((String)contentAllowed));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidArgumentException("Unable to parse Type Definition element. Unsupported 'content stream allowed attribute': " + contentAllowed);
                }
            }
            case FOLDER: {
                break;
            }
            case POLICY: {
                break;
            }
            case RELATIONSHIP: {
                type.setAllowedSourceTypes(new String[]{this.getSimpleExtension(AtomCMIS.ALLOWED_SOURCE_TYPES)});
                type.setAllowedTargetTypes(new String[]{this.getSimpleExtension(AtomCMIS.ALLOWED_TARGET_TYPES)});
            }
        }
        if (type == null) {
            String msg = "Specified baseType does not match with any allowed BaseTypeId";
            throw new InvalidArgumentException(msg);
        }
        type.setId(this.getSimpleExtension(AtomCMIS.ID));
        type.setLocalName(this.getSimpleExtension(AtomCMIS.LOCAL_NAME));
        type.setLocalNamespace(this.getSimpleExtension(AtomCMIS.LOCAL_NAMESPACE));
        type.setDisplayName(this.getSimpleExtension(AtomCMIS.DISPLAY_NAME));
        type.setQueryName(this.getSimpleExtension(AtomCMIS.QUERY_NAME));
        type.setDescription(this.getSimpleExtension(AtomCMIS.DESCRIPTION));
        type.setBaseId(baseType);
        type.setParentId(this.getSimpleExtension(AtomCMIS.PARENT_ID));
        type.setCreatable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.CREATABLE)));
        type.setFileable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.FILEABLE)));
        type.setQueryable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.QUERYABLE)));
        type.setFulltextIndexed(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.FULLTEXT_INDEXED)));
        type.setIncludedInSupertypeQuery(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.INCLUDED_IN_SUPERTYPE_QUERY)));
        type.setControllablePolicy(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.CONTROLLABLE_POLICY)));
        type.setControllableACL(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.CONTROLLABLE_ACL)));
        Map<String, PropertyDefinition<?>> propDefs = this.getPropertyDefinitions();
        type.setPropertyDefinitions(propDefs);
        return type;
    }

    public void build(TypeDefinition type) {
        if (type != null) {
            this.addSimpleExtension(AtomCMIS.ID, type.getId());
            this.addSimpleExtension(AtomCMIS.LOCAL_NAME, type.getLocalName());
            this.addSimpleExtension(AtomCMIS.LOCAL_NAMESPACE, type.getLocalNamespace());
            this.addSimpleExtension(AtomCMIS.DISPLAY_NAME, type.getDisplayName());
            this.addSimpleExtension(AtomCMIS.QUERY_NAME, type.getQueryName());
            this.addSimpleExtension(AtomCMIS.DESCRIPTION, type.getDescription());
            if (type.getBaseId() != null) {
                this.addSimpleExtension(AtomCMIS.BASE_ID, type.getBaseId().value());
            }
            this.addSimpleExtension(AtomCMIS.PARENT_ID, type.getParentId());
            this.addSimpleExtension(AtomCMIS.CREATABLE, Boolean.toString(type.isCreatable()));
            this.addSimpleExtension(AtomCMIS.FILEABLE, Boolean.toString(type.isFileable()));
            this.addSimpleExtension(AtomCMIS.QUERYABLE, Boolean.toString(type.isQueryable()));
            this.addSimpleExtension(AtomCMIS.FULLTEXT_INDEXED, Boolean.toString(type.isFulltextIndexed()));
            this.addSimpleExtension(AtomCMIS.INCLUDED_IN_SUPERTYPE_QUERY, Boolean.toString(type.isIncludedInSupertypeQuery()));
            this.addSimpleExtension(AtomCMIS.CONTROLLABLE_POLICY, Boolean.toString(type.isControllablePolicy()));
            this.addSimpleExtension(AtomCMIS.CONTROLLABLE_ACL, Boolean.toString(type.isControllableACL()));
            switch (type.getBaseId()) {
                case DOCUMENT: {
                    this.setAttributeValue(AtomCMIS.X_TYPE, "cmis:cmisTypeDocumentDefinitionType");
                    this.addSimpleExtension(AtomCMIS.VERSIONABLE, Boolean.toString(type.isVersionable()));
                    if (type.getContentStreamAllowed() != null) {
                        this.addSimpleExtension(AtomCMIS.CONTENT_STREAM_ALLOWED, type.getContentStreamAllowed().value());
                        break;
                    }
                    this.addSimpleExtension(AtomCMIS.CONTENT_STREAM_ALLOWED, ContentStreamAllowed.ALLOWED.value());
                    break;
                }
                case RELATIONSHIP: {
                    String[] arrayAllowedTarget;
                    this.setAttributeValue(AtomCMIS.X_TYPE, "cmis:cmisTypeRelationshipDefinitionType");
                    String[] arrayAllowedSource = type.getAllowedSourceTypes();
                    if (arrayAllowedSource != null && arrayAllowedSource.length > 0) {
                        for (String string : arrayAllowedSource) {
                            this.addSimpleExtension(AtomCMIS.ALLOWED_SOURCE_TYPES, string);
                        }
                    }
                    if ((arrayAllowedTarget = type.getAllowedTargetTypes()) == null || arrayAllowedTarget.length <= 0) break;
                    for (String string : arrayAllowedTarget) {
                        this.addSimpleExtension(AtomCMIS.ALLOWED_TARGET_TYPES, string);
                    }
                    break;
                }
                case FOLDER: {
                    this.setAttributeValue(AtomCMIS.X_TYPE, "cmis:cmisTypeFolderDefinitionType");
                    break;
                }
                case POLICY: {
                    this.setAttributeValue(AtomCMIS.X_TYPE, "cmis:cmisTypePolicyDefinitionType");
                }
            }
            if (type.getBaseId() == null) {
                String msg = "Specified baseType does not match with any allowed BaseTypeId";
                throw new InvalidArgumentException(msg);
            }
            if (type.getPropertyDefinitions() != null && type.getPropertyDefinitions().size() > 0) {
                for (PropertyDefinition propertyDefinition : type.getPropertyDefinitions()) {
                    PropertyDefinitionTypeElement propDefEl = (PropertyDefinitionTypeElement)this.addExtension(CMISExtensionFactory.getPropertyDefinitionTypeElementName(propertyDefinition.getPropertyType()));
                    propDefEl.build(propertyDefinition);
                }
            }
        }
    }
}

