/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.lucene.IndexRecoveryTool;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.TransactionableIndexDataManager;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexingService
extends TransactionableIndexDataManager {
    private static final Logger LOG = Logger.getLogger(LuceneIndexingService.class);

    public LuceneIndexingService(IndexConfiguration indexConfuguration, IndexRecoveryTool indexRecoveryTool) throws IndexException, IndexConfigurationException {
        super(indexConfuguration, indexRecoveryTool);
    }

    public boolean documentExists(String uuid) {
        try {
            return super.getDocument(uuid) != null;
        }
        catch (IndexException indexException) {
            return false;
        }
    }

    public Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        Collection fields = super.getIndexReader().getFieldNames(IndexReader.FieldOption.ALL);
        for (Object field : fields) {
            fildsSet.add((String)field);
        }
        return fildsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void softCleanIndex() throws IndexException {
        Directory dir;
        if (this.getDocumentCount() > 0L && (dir = this.getDirectory()) != null) {
            Directory directory = dir;
            synchronized (directory) {
                try {
                    IndexWriter writer = new IndexWriter(super.getDirectory(), (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                    writer.deleteDocuments((Query)new MatchAllDocsQuery());
                    writer.commit();
                    writer.optimize();
                    writer.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException(e.getLocalizedMessage(), e);
                }
                catch (LockObtainFailedException e) {
                    throw new IndexException(e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    throw new IndexException(e.getLocalizedMessage(), e);
                }
            }
        }
    }
}

