/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xcmis.sp.inmemory.DateValue;
import org.xcmis.sp.inmemory.Entry;
import org.xcmis.sp.inmemory.StorageImpl;
import org.xcmis.sp.inmemory.StringValue;
import org.xcmis.sp.inmemory.Value;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectDataVisitor;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.PropertyFilter;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.ChangeType;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.DecimalProperty;
import org.xcmis.spi.model.impl.HtmlProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.model.impl.UriProperty;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseObjectData
implements ObjectData {
    private static final Logger LOG = Logger.getLogger(BaseObjectData.class);
    protected final TypeDefinition type;
    protected final StorageImpl storage;
    protected final Entry entry;

    static Property<?> createCopyOfProperty(Property<?> source) {
        switch (source.getType()) {
            case BOOLEAN: {
                return new BooleanProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case DATETIME: {
                List dates = source.getValues();
                ArrayList<Calendar> work = new ArrayList<Calendar>(dates.size());
                for (Calendar c : dates) {
                    work.add((Calendar)c.clone());
                }
                return new DateTimeProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), work);
            }
            case DECIMAL: {
                return new DecimalProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case HTML: {
                return new HtmlProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case ID: {
                return new IdProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case INTEGER: {
                return new IntegerProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case STRING: {
                return new StringProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
            case URI: {
                return new UriProperty(source.getId(), source.getQueryName(), source.getLocalName(), source.getDisplayName(), new ArrayList(source.getValues()));
            }
        }
        return null;
    }

    public BaseObjectData(Entry entry, TypeDefinition type, StorageImpl storage) {
        this.entry = entry;
        this.type = type;
        this.storage = storage;
    }

    public void accept(ObjectDataVisitor visitor) {
        visitor.visit((ObjectData)this);
    }

    public void applyPolicy(PolicyData policy) {
        this.entry.addPolicy(policy);
        try {
            this.save();
        }
        catch (StorageException e) {
            throw new CmisRuntimeException("Unable apply policy. " + e.getMessage(), (Throwable)e);
        }
        this.storage.changes.add(new ChangeEvent(StorageImpl.generateId(), this.getObjectId(), ChangeType.SECURITY, Calendar.getInstance(), null, new HashSet<String>(this.entry.getPolicies()), null));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((BaseObjectData)obj).getObjectId().equals(this.getObjectId());
    }

    public List<AccessControlEntry> getACL(boolean onlyBasicPermissions) {
        if (!this.type.isControllableACL()) {
            return Collections.emptyList();
        }
        return CmisUtils.createAclFromPermissionMap(this.entry.getPermissions());
    }

    public BaseType getBaseType() {
        return this.type.getBaseId();
    }

    public String getChangeToken() {
        return this.getString("cmis:changeToken");
    }

    public String getCreatedBy() {
        return this.getString("cmis:createdBy");
    }

    public Calendar getCreationDate() {
        return this.getDate("cmis:creationDate");
    }

    public Calendar getLastModificationDate() {
        return this.getDate("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return this.getString("cmis:lastModifiedBy");
    }

    public String getName() {
        return this.getString("cmis:name");
    }

    public String getObjectId() {
        return this.entry.getId();
    }

    public FolderData getParent() throws ConstraintException {
        if ("abcdef12-3456-7890-0987-654321fedcba".equals(this.getObjectId())) {
            throw new ConstraintException("Unable get parent of root folder.");
        }
        Collection<FolderData> parents = this.getParents();
        if (parents.size() > 1) {
            throw new ConstraintException("Object has more then one parent.");
        }
        if (parents.size() == 1) {
            return parents.iterator().next();
        }
        return null;
    }

    public Collection<FolderData> getParents() {
        Set<String> parentIds = this.storage.parents.get(this.getObjectId());
        HashSet<FolderData> parents = new HashSet<FolderData>(parentIds.size());
        if (parentIds != null) {
            for (String id : parentIds) {
                try {
                    parents.add((FolderData)this.storage.getObjectById(id));
                }
                catch (ObjectNotFoundException e) {
                    LOG.warn("Not found folder " + id);
                }
            }
        }
        return parents;
    }

    public Collection<PolicyData> getPolicies() {
        if (!this.type.isControllablePolicy()) {
            return Collections.emptyList();
        }
        ArrayList<PolicyData> policies = new ArrayList<PolicyData>();
        for (String id : this.entry.getPolicies()) {
            try {
                policies.add((PolicyData)this.storage.getObjectById(id));
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Not found policy " + id);
            }
        }
        return policies;
    }

    public Map<String, Property<?>> getProperties() {
        HashMap properties = new HashMap();
        for (PropertyDefinition definition : this.type.getPropertyDefinitions()) {
            properties.put(definition.getId(), this.doGetProperty(definition));
        }
        return properties;
    }

    public Map<String, Property<?>> getProperties(PropertyFilter filter) {
        HashMap properties = new HashMap();
        for (PropertyDefinition definition : this.type.getPropertyDefinitions()) {
            String queryName = definition.getQueryName();
            if (!filter.accept(queryName)) continue;
            String id = definition.getId();
            properties.put(id, this.doGetProperty(definition));
        }
        return properties;
    }

    public Property<?> getProperty(String id) {
        PropertyDefinition definition = this.type.getPropertyDefinition(id);
        if (definition != null) {
            return this.doGetProperty(definition);
        }
        return null;
    }

    public ItemsIterator<RelationshipData> getRelationships(RelationshipDirection direction, TypeDefinition type, boolean includeSubRelationshipTypes) {
        Set<String> relationshipIds = this.storage.relationships.get(this.getObjectId());
        if (relationshipIds == null) {
            return CmisUtils.emptyItemsIterator();
        }
        HashSet<String> typeFilter = new HashSet<String>();
        typeFilter.add(type.getId());
        if (includeSubRelationshipTypes) {
            Collection<TypeDefinition> subTypes = null;
            try {
                subTypes = this.storage.getSubTypes(type.getId(), false);
            }
            catch (TypeNotFoundException e) {
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
            for (TypeDefinition t : subTypes) {
                typeFilter.add(t.getId());
            }
        }
        HashSet<RelationshipData> relationships = new HashSet<RelationshipData>();
        for (String id : relationshipIds) {
            RelationshipData relationship = null;
            try {
                relationship = (RelationshipData)this.storage.getObjectById(id);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Not found relationship " + id + ".");
                continue;
            }
            if (direction != RelationshipDirection.EITHER && (direction != RelationshipDirection.SOURCE || !relationship.getSourceId().equals(this.getObjectId())) && (direction != RelationshipDirection.TARGET || !relationship.getTargetId().equals(this.getObjectId())) || !typeFilter.contains(relationship.getTypeDefinition().getId())) continue;
            relationships.add(relationship);
        }
        return new BaseItemsIterator(relationships);
    }

    public TypeDefinition getTypeDefinition() {
        return this.type;
    }

    public String getTypeId() {
        return this.type.getId();
    }

    public int hashCode() {
        int hash = 8;
        return hash * 31 + this.getObjectId().hashCode();
    }

    public void removePolicy(PolicyData policy) {
        this.entry.removePolicy(policy);
        try {
            this.save();
        }
        catch (StorageException e) {
            throw new CmisRuntimeException("Unable remove policy. " + e.getMessage(), (Throwable)e);
        }
        this.storage.changes.add(new ChangeEvent(StorageImpl.generateId(), this.getObjectId(), ChangeType.SECURITY, Calendar.getInstance(), null, new HashSet<String>(this.entry.getPolicies()), null));
    }

    public void setACL(List<AccessControlEntry> acl) {
        Map<String, Set<String>> permissions = this.entry.getPermissions();
        permissions.clear();
        CmisUtils.addAclToPermissionMap(permissions, acl);
        try {
            this.save();
        }
        catch (StorageException e) {
            throw new CmisRuntimeException("Unable set ACL. " + e.getMessage(), (Throwable)e);
        }
        if (acl != null) {
            ArrayList<AccessControlEntry> copy = new ArrayList<AccessControlEntry>(acl.size());
            for (AccessControlEntry ace : acl) {
                copy.add(new AccessControlEntry(ace.getPrincipal(), new HashSet(ace.getPermissions()), ace.isDirect()));
            }
            this.storage.changes.add(new ChangeEvent(StorageImpl.generateId(), this.getObjectId(), ChangeType.SECURITY, Calendar.getInstance(), null, null, copy));
        }
    }

    public void setProperties(Map<String, Property<?>> properties) throws NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        ArrayList chl = new ArrayList();
        for (Property<?> property : properties.values()) {
            if (!this.doSetProperty(property)) continue;
            chl.add(BaseObjectData.createCopyOfProperty(property));
        }
        this.save();
        this.storage.changes.add(new ChangeEvent(StorageImpl.generateId(), this.getObjectId(), ChangeType.UPDATED, Calendar.getInstance(), chl, null, null));
    }

    public void setProperty(Property<?> property) throws NameConstraintViolationException, StorageException, UpdateConflictException, VersioningException {
        this.doSetProperty(property);
        this.save();
        ArrayList chl = new ArrayList(1);
        chl.add(BaseObjectData.createCopyOfProperty(property));
        this.storage.changes.add(new ChangeEvent(StorageImpl.generateId(), this.getObjectId(), ChangeType.UPDATED, Calendar.getInstance(), chl, null, null));
    }

    public String toString() {
        return "type: " + this.getTypeId() + ", name: " + this.getName() + ", id: " + this.getObjectId();
    }

    private Property<?> createProperty(PropertyDefinition<?> def, Value value) {
        if (def.getPropertyType() == PropertyType.BOOLEAN) {
            return new BooleanProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getBooleans()));
        }
        if (def.getPropertyType() == PropertyType.DATETIME) {
            return new DateTimeProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getDates()));
        }
        if (def.getPropertyType() == PropertyType.DECIMAL) {
            return new DecimalProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getDecimals()));
        }
        if (def.getPropertyType() == PropertyType.HTML) {
            return new HtmlProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getStrings()));
        }
        if (def.getPropertyType() == PropertyType.ID) {
            return new IdProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getStrings()));
        }
        if (def.getPropertyType() == PropertyType.INTEGER) {
            return new IntegerProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getIntegers()));
        }
        if (def.getPropertyType() == PropertyType.STRING) {
            return new StringProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getStrings()));
        }
        if (def.getPropertyType() == PropertyType.URI) {
            return new UriProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), value == null ? null : Arrays.asList(value.getURI()));
        }
        throw new CmisRuntimeException("Unknown property type.");
    }

    protected abstract void delete() throws StorageException, UpdateConflictException, VersioningException;

    protected Property<?> doGetProperty(PropertyDefinition<?> definition) {
        Value value = this.entry.getValue(definition.getId());
        if (value == null && "cmis:path".equals(definition.getId()) && this.type.getBaseId() == BaseType.FOLDER) {
            value = new StringValue(((FolderData)this).getPath());
        }
        return this.createProperty(definition, value);
    }

    protected boolean doSetProperty(Property<?> property) throws NameConstraintViolationException {
        PropertyDefinition definition = this.type.getPropertyDefinition(property.getId());
        Updatability updatability = definition.getUpdatability();
        if (updatability == Updatability.READWRITE || updatability == Updatability.WHENCHECKEDOUT && this.getBaseType() == BaseType.DOCUMENT && ((DocumentData)this).isPWC()) {
            Iterator i = property.getValues().iterator();
            while (i.hasNext()) {
                Object v = i.next();
                if (v != null) continue;
                i.remove();
            }
            if ("cmis:name".equals(property.getId())) {
                String name = null;
                List values = property.getValues();
                if (values.size() > 0) {
                    name = (String)values.get(0);
                }
                if (name == null || name.length() == 0) {
                    throw new NameConstraintViolationException("Name can't be null or empty string.");
                }
                if (name.equals(this.getName())) {
                    return false;
                }
                for (FolderData parent : this.getParents()) {
                    ItemsIterator iterator = parent.getChildren(null);
                    while (iterator.hasNext()) {
                        if (!name.equals(((ObjectData)iterator.next()).getName())) continue;
                        throw new NameConstraintViolationException("Object with name " + name + " already exists in parent folder.");
                    }
                }
            }
            this.entry.setProperty(property);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Property " + property.getId() + " is not updatable.");
        }
        return false;
    }

    protected Boolean getBoolean(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            Boolean[] booleans = value.getBooleans();
            return booleans.length > 0 ? booleans[0] : null;
        }
        return null;
    }

    protected Boolean[] getBooleans(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            return value.getBooleans();
        }
        return null;
    }

    protected Calendar getDate(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            Calendar[] dates = value.getDates();
            return dates.length > 0 ? dates[0] : null;
        }
        return null;
    }

    protected Calendar[] getDates(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            return value.getDates();
        }
        return null;
    }

    protected BigDecimal getDecimal(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            BigDecimal[] decimals = value.getDecimals();
            return decimals.length > 0 ? decimals[0] : null;
        }
        return null;
    }

    protected BigDecimal[] getDecimals(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            return value.getDecimals();
        }
        return null;
    }

    protected Entry getEntry() {
        return this.entry;
    }

    protected String getId(String id) {
        return this.getString(id);
    }

    protected String[] getIds(String id) {
        return this.getStrings(id);
    }

    protected BigInteger getInteger(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            BigInteger[] integers = value.getIntegers();
            return integers.length > 0 ? integers[0] : null;
        }
        return null;
    }

    protected BigInteger[] getIntegers(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            return value.getIntegers();
        }
        return null;
    }

    protected String getString(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            String[] strings = value.getStrings();
            return strings.length > 0 ? strings[0] : null;
        }
        return null;
    }

    protected String[] getStrings(String id) {
        Value value = this.entry.getValue(id);
        if (value != null) {
            return value.getStrings();
        }
        return null;
    }

    protected void save() throws StorageException {
        if (this.storage.entries.get(this.entry.getId()) == null) {
            throw new CmisRuntimeException("Object was removed from storage.");
        }
        this.entry.setValue("cmis:lastModifiedBy", new StringValue(this.storage.getCurrentUser()));
        this.entry.setValue("cmis:lastModificationDate", new DateValue(Calendar.getInstance()));
        this.entry.setValue("cmis:changeToken", new StringValue(StorageImpl.generateId()));
        this.storage.entries.put(this.entry.getId(), this.entry);
        this.storage.indexListener.updated(this);
    }
}

