/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory.tck;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.xcmis.sp.inmemory.StorageProviderImpl;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.CmisRegistryFactory;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.utils.Logger;

public class InmemoryCmisRegistryFactory
implements CmisRegistryFactory {
    private static final Logger LOG = Logger.getLogger(InmemoryCmisRegistryFactory.class);
    private CmisRegistry reg = new CmisRegistry();

    public InmemoryCmisRegistryFactory() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            LOG.error("Unable get context class loader. " + e.getMessage());
        }
        boolean fconfig = false;
        if (cl != null) {
            String sids;
            String renditionProvider;
            InputStream in = cl.getResourceAsStream("xcmis-storage.properties");
            Properties properties = new Properties();
            if (in != null) {
                try {
                    properties.load(new BufferedInputStream(in));
                    fconfig = true;
                }
                catch (IOException ioe) {
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
            if ((renditionProvider = (String)properties.get("org.xcmis.storage.renditionProvider")) != null) {
                RenditionManager renditionManager = RenditionManager.getInstance();
                renditionManager.addRenditionProviders(Arrays.asList(renditionProvider.split(",")));
            }
            if ((sids = (String)properties.get("org.xcmis.storage.id")) != null) {
                for (String s : sids.split(",")) {
                    String id = s.trim();
                    if (id.length() <= 0) continue;
                    String name = (String)properties.get("org.xcmis.storage." + id + ".name");
                    String description = (String)properties.get("org.xcmis.storage." + id + ".description");
                    String sMaxItemsNum = (String)properties.get("org.xcmis.storage." + id + ".maxItemsNum");
                    long maxItemsNum = -1L;
                    if (sMaxItemsNum != null && sMaxItemsNum.length() > 0) {
                        try {
                            maxItemsNum = Long.parseLong(sMaxItemsNum);
                        }
                        catch (NumberFormatException ne) {
                            LOG.error("Unable convert '" + sMaxItemsNum + "' to long. ");
                        }
                    }
                    String sMaxMem = (String)properties.get("org.xcmis.storage." + id + ".maxMem");
                    long maxMem = -1L;
                    if (sMaxMem != null && sMaxMem.length() > 0) {
                        try {
                            maxMem = Long.parseLong(sMaxMem);
                        }
                        catch (NumberFormatException ne) {
                            LOG.error("Unable convert '" + sMaxMem + "' to long. ");
                        }
                    }
                    this.reg.addStorage((StorageProvider)new StorageProviderImpl(id, name != null && name.length() > 0 ? name : id, description != null && description.length() > 0 ? description : id, maxMem, maxItemsNum));
                    LOG.info("Register storage " + id);
                }
            }
        }
        if (!fconfig) {
            this.reg.addStorage((StorageProvider)new StorageProviderImpl("cmis1", "cmis1", "", -1L, -1L));
        }
    }

    public CmisRegistry getRegistry() {
        return this.reg;
    }
}

