/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory.query;

import java.util.HashSet;
import java.util.Set;
import org.xcmis.search.content.Schema;
import org.xcmis.search.lucene.content.SchemaTableResolver;
import org.xcmis.search.value.NameConverter;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.QueryNameTypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.Logger;

public class CmisSchemaTableResolver
extends SchemaTableResolver {
    private final QueryNameTypeManager typeManager;
    private static final Logger LOG = Logger.getLogger(CmisSchemaTableResolver.class);

    public CmisSchemaTableResolver(NameConverter nameConverter, Schema schema, QueryNameTypeManager typeManager) {
        super(nameConverter, schema);
        this.typeManager = typeManager;
    }

    protected Set<String> getSubTypes(String tableName) {
        HashSet<String> subTypes = new HashSet<String>();
        try {
            TypeDefinition type = this.typeManager.getTypeDefinitionByQueryName(tableName, false);
            ItemsIterator typeChildren = this.typeManager.getTypeChildren(type.getId(), false);
            while (typeChildren.hasNext()) {
                TypeDefinition typeDefinition = (TypeDefinition)typeChildren.next();
                subTypes.add(typeDefinition.getQueryName());
            }
        }
        catch (TypeNotFoundException tnf) {
            LOG.error(tnf.getMessage(), (Throwable)tnf);
        }
        return subTypes;
    }
}

