/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.xcmis.sp.inmemory.BooleanValue;
import org.xcmis.sp.inmemory.DateValue;
import org.xcmis.sp.inmemory.DecimalValue;
import org.xcmis.sp.inmemory.IntegerValue;
import org.xcmis.sp.inmemory.StringValue;
import org.xcmis.sp.inmemory.UriValue;
import org.xcmis.sp.inmemory.Value;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyType;

final class Entry {
    private Map<String, Value> values;
    private Map<String, Set<String>> permissions;
    private Set<String> policies;

    public Entry() {
    }

    public Entry(Map<String, Value> values, Set<String> policies, Map<String, Set<String>> permissions) {
        this.values = values != null ? new ConcurrentHashMap<String, Value>(values) : null;
        this.policies = policies != null ? new CopyOnWriteArraySet<String>(policies) : null;
        this.permissions = permissions != null ? new ConcurrentHashMap<String, Set<String>>(permissions) : null;
    }

    public void addPolicy(PolicyData policy) {
        this.getPolicies().add(policy.getObjectId());
    }

    public BaseType getBaseTypeId() {
        Value value = this.getValues().get("cmis:baseTypeId");
        if (value != null) {
            String[] strs = value.getStrings();
            return strs.length > 0 ? BaseType.fromValue((String)strs[0]) : null;
        }
        return null;
    }

    public String getId() {
        Value value = this.getValues().get("cmis:objectId");
        if (value != null) {
            String[] strs = value.getStrings();
            return strs.length > 0 ? strs[0] : null;
        }
        return null;
    }

    public Map<String, Set<String>> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ConcurrentHashMap<String, Set<String>>();
        }
        return this.permissions;
    }

    public Collection<String> getPolicies() {
        if (this.policies == null) {
            this.policies = new CopyOnWriteArraySet<String>();
        }
        return this.policies;
    }

    public String getTypeId() {
        Value value = this.getValues().get("cmis:objectTypeId");
        if (value != null) {
            String[] strs = value.getStrings();
            return strs.length > 0 ? strs[0] : null;
        }
        return null;
    }

    public Value getValue(String id) {
        return this.getValues().get(id);
    }

    public Map<String, Value> getValues() {
        if (this.values == null) {
            this.values = new ConcurrentHashMap<String, Value>();
        }
        return this.values;
    }

    public void removePolicy(PolicyData policy) {
        this.getPolicies().remove(policy.getObjectId());
    }

    public void setPermissions(Map<String, Set<String>> permissions) {
        Map<String, Set<String>> ps = this.getPermissions();
        ps.clear();
        ps.putAll(permissions);
    }

    public void setProperty(Property<?> property) {
        if (property.getType() == PropertyType.BOOLEAN) {
            List booleans = property.getValues();
            this.setValue(property.getId(), new BooleanValue(booleans));
        } else if (property.getType() == PropertyType.DATETIME) {
            List dates = property.getValues();
            this.setValue(property.getId(), new DateValue(dates));
        } else if (property.getType() == PropertyType.DECIMAL) {
            List decimals = property.getValues();
            this.setValue(property.getId(), new DecimalValue(decimals));
        } else if (property.getType() == PropertyType.INTEGER) {
            List integers = property.getValues();
            this.setValue(property.getId(), new IntegerValue(integers));
        } else if (property.getType() == PropertyType.URI) {
            List uris = property.getValues();
            this.setValue(property.getId(), new UriValue(uris));
        } else if (property.getType() == PropertyType.STRING || property.getType() == PropertyType.HTML || property.getType() == PropertyType.ID) {
            List text = property.getValues();
            this.setValue(property.getId(), new StringValue(text));
        }
    }

    public void setValue(String id, Value value) {
        Map<String, Value> vs = this.getValues();
        if (value == null) {
            vs.remove(id);
        } else {
            vs.put(id, value);
        }
    }

    public void setValues(Map<String, Value> values) {
        if (values != null) {
            for (Map.Entry<String, Value> e : values.entrySet()) {
                this.setValue(e.getKey(), e.getValue());
            }
        }
    }

    public String toString() {
        return this.getId();
    }
}

