/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import org.apache.tika.exception.TikaException;
import org.xcmis.sp.inmemory.InmemConnection;
import org.xcmis.sp.inmemory.StorageConfiguration;
import org.xcmis.sp.inmemory.StorageImpl;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageProvider;

public class StorageProviderImpl
implements StorageProvider {
    private StorageImpl storageImpl = null;
    private StorageConfiguration storageConfig = null;
    private RenditionManager renditionManager;

    public StorageProviderImpl(String repositoryId, String repositoryName, String description, long maxStorageMemSize, long maxItemsNumber) throws TikaException {
        this.storageConfig = new StorageConfiguration(repositoryId, repositoryName, description, maxStorageMemSize, maxItemsNumber);
        this.renditionManager = RenditionManager.getInstance();
        this.storageImpl = new StorageImpl(this.storageConfig, this.renditionManager, new PermissionService());
    }

    public Connection getConnection() {
        if (this.storageImpl == null) {
            throw new InvalidArgumentException("CMIS repository does not exist.");
        }
        return new InmemConnection(this.storageImpl);
    }

    public String getStorageID() {
        return this.storageConfig.getId();
    }
}

