/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.StorageImpl;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.utils.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JcrFile
extends DocumentDataImpl {
    public JcrFile(JcrNodeEntry jcrEntry, IndexListener indexListener, RenditionManager renditionManager) {
        super(jcrEntry, indexListener, renditionManager);
        try {
            if (jcrEntry.getType().isVersionable() && jcrEntry.getNode().canAddMixin("mix:versionable")) {
                jcrEntry.getNode().addMixin("mix:versionable");
                jcrEntry.save();
            }
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void cancelCheckout() throws StorageException {
        throw new CmisRuntimeException("Not implemented for not CMIS type.");
    }

    @Override
    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws StorageException {
        throw new CmisRuntimeException("Not implemented for not CMIS type.");
    }

    @Override
    public DocumentData checkout() throws VersioningException, StorageException {
        throw new CmisRuntimeException("Not implemented for not CMIS type.");
    }

    @Override
    public Calendar getCreationDate() {
        try {
            return this.getNode().getProperty("jcr:created").getDate();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get cteation date. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public String getVersionLabel() {
        return StorageImpl.LATEST_LABEL;
    }

    @Override
    public String getVersionSeriesId() {
        try {
            return this.getNode().getProperty("jcr:versionHistory").getString();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get version series ID. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public void setContentStream(ContentStream content) throws IOException, StorageException {
        try {
            Node contentNode = this.getNode().getNode("jcr:content");
            if (content != null) {
                MimeType mediaType = content.getMediaType();
                contentNode.setProperty("jcr:mimeType", mediaType.getBaseType());
                if (mediaType.getParameter("charset") != null) {
                    contentNode.setProperty("jcr:encoding", mediaType.getParameter("charset"));
                }
                contentNode.setProperty("jcr:data", content.getStream()).getLength();
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            } else {
                contentNode.setProperty("jcr:mimeType", "");
                contentNode.setProperty("jcr:encoding", (Value)null);
                contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(new byte[0]));
            }
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable set content stream. " + re.getMessage(), (Throwable)re);
        }
        this.save();
    }

    @Override
    protected void save() throws StorageException {
        this.jcrEntry.save();
        if (this.indexListener != null) {
            this.indexListener.updated(this);
        }
    }
}

