/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.xcmis.sp.jcr.exo.BaseObjectData;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PolicyDataImpl
extends BaseObjectData
implements PolicyData {
    public PolicyDataImpl(JcrNodeEntry jcrEntry, IndexListener indexListener) {
        super(jcrEntry, indexListener);
    }

    public ContentStream getContentStream(String streamId) {
        return null;
    }

    public FolderData getParent() throws ConstraintException {
        return null;
    }

    public Collection<FolderData> getParents() {
        return Collections.emptyList();
    }

    public String getPolicyText() {
        return this.jcrEntry.getString("cmis:policyText");
    }

    @Override
    protected void delete() throws StorageException {
        String objectId = this.getObjectId();
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            PropertyIterator iter = node.getReferences();
            while (iter.hasNext()) {
                Node controllable = iter.nextProperty().getParent();
                if (!controllable.isNodeType("nt:file") && !controllable.isNodeType("nt:folder") && !controllable.isNodeType("cmis:policy")) continue;
                throw new StorageException("Unable to delete applied policy.");
            }
            node.remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }
}

