/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectParent;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;

public class NavigationTest
extends BaseTest {
    private static String testRootFolderId;
    private static String folder1;
    private static String folder2;
    private static String folder3;
    private static String doc1;
    private static String doc2;
    private static String doc3;
    private static String doc4;
    private static String doc5;
    private static String doc6;
    private static String pwc2;
    private static String pwc5;
    private static String pwc6;
    private static String rel1;
    private static String rel2;
    private static String rel3;

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            NavigationTest.clear(testRootFolderId);
        }
    }

    @BeforeClass
    public static void start() throws Exception {
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        testRootFolderId = NavigationTest.createFolder(rootFolderID, folderType.getId(), "navigation_testroot", null, null, null);
        folder1 = NavigationTest.createFolder(testRootFolderId, folderType.getId(), "folder1", null, null, null);
        doc1 = NavigationTest.createDocument(testRootFolderId, documentType.getId(), "doc1", null, null, null, null, null);
        doc2 = NavigationTest.createDocument(testRootFolderId, documentType.getId(), "doc2", null, null, null, null, null);
        folder2 = NavigationTest.createFolder(testRootFolderId, folderType.getId(), "folder2", null, null, null);
        doc3 = NavigationTest.createDocument(folder2, documentType.getId(), "doc3", null, null, null, null, null);
        folder3 = NavigationTest.createFolder(folder2, folderType.getId(), "folder3", null, null, null);
        doc4 = NavigationTest.createDocument(folder3, documentType.getId(), "doc4", null, null, null, null, null);
        doc5 = NavigationTest.createDocument(testRootFolderId, documentType.getId(), "doc5", null, null, null, null, null);
        doc6 = NavigationTest.createDocument(testRootFolderId, documentType.getId(), "doc6", null, null, null, null, null);
        if (documentType.isVersionable()) {
            pwc2 = connection.checkout(doc2);
            pwc5 = connection.checkout(doc5);
            pwc6 = connection.checkout(doc6);
        }
        if (isRelationshipsSupported) {
            TypeDefinition relationshipType = connection.getTypeDefinition("cmis:relationship");
            rel1 = NavigationTest.createRelationship(relationshipType.getId(), "rel1", doc3, doc4, null, null, null);
            rel2 = NavigationTest.createRelationship(relationshipType.getId(), "rel2", doc1, doc2, null, null, null);
            rel3 = NavigationTest.createRelationship(relationshipType.getId(), "rel3", folder2, doc1, null, null, null);
        }
        System.out.println("Running Navigation Service tests");
    }

    @Test
    public void testGetCheckedOutDocs() throws Exception {
        ArrayList<String> exp = new ArrayList<String>(3);
        for (String s : new String[]{pwc2, pwc5, pwc6}) {
            if (s == null) continue;
            exp.add(s);
        }
        ItemsList pwcs = connection.getCheckedOutDocs(null, false, IncludeRelationships.NONE, true, null, "cmis:none", null, -1, 0);
        ArrayList<String> res = new ArrayList<String>();
        for (CmisObject o : pwcs.getItems()) {
            res.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)exp.size(), (long)res.size());
        for (String s : res) {
            Assert.assertTrue((String)("Unexpected item in result set " + s), (boolean)exp.contains(s));
        }
        for (CmisObject o : pwcs.getItems()) {
            Assert.assertNull((Object)o.getPathSegment());
            Assert.assertNull((Object)o.getAllowableActions());
            Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
            Assert.assertEquals((long)0L, (long)o.getRelationship().size());
            Assert.assertEquals((long)0L, (long)o.getRenditions().size());
            res.add(o.getObjectInfo().getId());
        }
    }

    @Test
    public void testGetCheckedOutDocs_AllowableActions() throws Exception {
        ItemsList pwcs = connection.getCheckedOutDocs(null, true, IncludeRelationships.NONE, true, null, "cmis:none", null, -1, 0);
        for (CmisObject o : pwcs.getItems()) {
            Assert.assertNotNull((String)"AllowableActions must be present in result.", (Object)o.getAllowableActions());
        }
    }

    @Test
    public void testGetCheckedOutDocs_FilterNotValidException() throws Exception {
        try {
            String filter = "(,*";
            connection.getCheckedOutDocs(testRootFolderId, false, IncludeRelationships.NONE, true, filter, "cmis:none", null, -1, 0);
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCheckedOutDocs_MaxItems() throws Exception {
        ItemsList pwcs = connection.getCheckedOutDocs(testRootFolderId, false, IncludeRelationships.NONE, true, null, "cmis:none", null, 2, 0);
        Assert.assertTrue((String)"Unexpected items number. ", (pwcs.getItems().size() <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCheckedOutDocs_PropertyFiltered() throws Exception {
        String filter = "cmis:name,cmis:path";
        ItemsList pwcs = connection.getCheckedOutDocs(testRootFolderId, false, IncludeRelationships.NONE, true, filter, "cmis:none", null, -1, 0);
        HashSet<String> queryNames = new HashSet<String>();
        for (CmisObject o : pwcs.getItems()) {
            for (Map.Entry e : o.getProperties().entrySet()) {
                queryNames.add(((Property)e.getValue()).getQueryName());
            }
            Assert.assertEquals((long)1L, (long)queryNames.size());
            for (String q : queryNames) {
                Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (boolean)q.equalsIgnoreCase("cmis:name"));
            }
        }
    }

    @Test
    @Ignore(value="Skip this test at he moment since it is not clear how-to determine which behavior storage supports. See section 2.1.9.8 'Version Specific/Independent membership in Relationships'")
    public void testGetCheckedOutDocs_Relationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList pwcs = connection.getCheckedOutDocs(testRootFolderId, false, IncludeRelationships.BOTH, true, null, "cmis:none", null, -1, 0);
        for (CmisObject o : pwcs.getItems()) {
            if (o.getObjectInfo().getId().equals(pwc2)) {
                Assert.assertTrue((String)("Expected relationship " + rel2 + " not found. "), (o.getRelationship().size() == 1 && o.getRelationship().contains(rel2) ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)0L, (long)o.getRelationship().size());
        }
    }

    @Test
    public void testGetCheckedOutDocs_RenditionsFiltered() throws Exception {
        ItemsList pwcs = connection.getCheckedOutDocs(testRootFolderId, false, IncludeRelationships.NONE, true, null, "cmis:none", null, -1, 0);
        for (CmisObject one : pwcs.getItems()) {
            Assert.assertTrue((String)"Rendition filter works incorrect. ", (one.getRenditions().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetCheckedOutDocs_SkipCount() throws Exception {
        ArrayList<String> exp = new ArrayList<String>(3);
        for (String s : new String[]{pwc2, pwc5, pwc6}) {
            if (s == null) continue;
            exp.add(s);
        }
        if (exp.isEmpty()) {
            return;
        }
        ItemsList pwcs = connection.getCheckedOutDocs(testRootFolderId, true, IncludeRelationships.NONE, true, null, "cmis:none", null, -1, 0);
        ArrayList<String> ids0 = new ArrayList<String>(pwcs.getItems().size());
        for (CmisObject o : pwcs.getItems()) {
            ids0.add(o.getObjectInfo().getId());
        }
        pwcs = connection.getCheckedOutDocs(testRootFolderId, true, IncludeRelationships.NONE, true, null, "cmis:none", null, -1, 1);
        ArrayList<String> ids1 = new ArrayList<String>(pwcs.getItems().size());
        for (CmisObject o : pwcs.getItems()) {
            ids1.add(o.getObjectInfo().getId());
        }
        ids0.remove(0);
        Assert.assertEquals(ids0, ids1);
    }

    @Test
    public void testGetChildren() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 0);
        Assert.assertEquals((long)6L, (long)children.getItems().size());
        HashSet<String> childrenIDs = new HashSet<String>(6);
        for (CmisObject child : children.getItems()) {
            childrenIDs.add(child.getObjectInfo().getId());
        }
        Assert.assertTrue((String)("Expected child " + folder1 + " not found. "), (boolean)childrenIDs.contains(folder1));
        Assert.assertTrue((String)("Expected child " + folder2 + " not found. "), (boolean)childrenIDs.contains(folder2));
        Assert.assertTrue((String)("Expected child " + doc1 + " not found. "), (boolean)childrenIDs.contains(doc1));
        Assert.assertTrue((String)("Expected child " + doc2 + " not found. "), (boolean)childrenIDs.contains(doc2));
        Assert.assertTrue((String)("Expected child " + doc5 + " not found. "), (boolean)childrenIDs.contains(doc5));
        Assert.assertTrue((String)("Expected child " + doc6 + " not found. "), (boolean)childrenIDs.contains(doc6));
        for (CmisObject o : children.getItems()) {
            Assert.assertNull((Object)o.getPathSegment());
            Assert.assertNull((Object)o.getAllowableActions());
            Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
            Assert.assertEquals((long)0L, (long)o.getRelationship().size());
            Assert.assertEquals((long)0L, (long)o.getRenditions().size());
        }
    }

    @Test
    public void testGetChildren_AllowableActions() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, true, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 0);
        Assert.assertEquals((long)6L, (long)children.getItems().size());
        for (CmisObject child : children.getItems()) {
            Assert.assertNotNull((String)"Allowable actions must be present in result.", (Object)child.getAllowableActions());
        }
    }

    @Test
    public void testGetChildren_FilterNotValidException() throws Exception {
        try {
            String filter = "(,*";
            connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, filter, "cmis:none", null, -1, 0);
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChildren_HasMoreItems() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, 2, 0);
        Assert.assertTrue((boolean)children.isHasMoreItems());
    }

    @Test
    public void testGetChildren_InvalidArgumentException() throws Exception {
        try {
            connection.getChildren(doc1, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 0);
            Assert.fail((String)"InvalidArgumentException must be thrown since try get children from not folder object. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChildren_MaxItems() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, 3, 0);
        Assert.assertTrue((String)"Wrong number of items in result. ", (children.getItems().size() <= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetChildren_NumItems() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, 2, 0);
        int numItems = children.getNumItems();
        Assert.assertTrue((String)"NumItems must be 6 or -1. ", (numItems == -1 || numItems == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testGetChildren_PathSegments() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.BOTH, true, true, null, "cmis:none", null, -1, 0);
        Assert.assertEquals((long)6L, (long)children.getItems().size());
        for (CmisObject child : children.getItems()) {
            Assert.assertNotNull((String)"Path segment must be present in result.", (Object)child.getPathSegment());
        }
    }

    @Test
    public void testGetChildren_PropertyFiltered() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, "cmis:name,cmis:path", "cmis:none", null, -1, 0);
        Assert.assertEquals((long)6L, (long)children.getItems().size());
        for (CmisObject child : children.getItems()) {
            BaseType baseType = child.getObjectInfo().getBaseType();
            HashSet<String> queryNames = new HashSet<String>();
            for (Map.Entry e : child.getProperties().entrySet()) {
                queryNames.add(((Property)e.getValue()).getQueryName());
            }
            if (baseType == BaseType.DOCUMENT) {
                Assert.assertEquals((long)1L, (long)queryNames.size());
                Assert.assertTrue((String)"Unexpected property in result. ", (boolean)((String)queryNames.iterator().next()).equalsIgnoreCase("cmis:name"));
                continue;
            }
            if (baseType != BaseType.FOLDER) continue;
            Assert.assertEquals((long)2L, (long)queryNames.size());
            for (String q : queryNames) {
                Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetChildren_Relationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.BOTH, false, true, null, "cmis:none", null, -1, 0);
        Assert.assertEquals((long)6L, (long)children.getItems().size());
        for (CmisObject child : children.getItems()) {
            String childId = child.getObjectInfo().getId();
            List relationships = child.getRelationship();
            HashSet<String> relationshipIDs = new HashSet<String>(relationships.size());
            for (CmisObject rel : relationships) {
                relationshipIDs.add(rel.getObjectInfo().getId());
            }
            if (childId.equals(doc1)) {
                Assert.assertEquals((long)2L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel2 + " not found. "), (boolean)relationshipIDs.contains(rel2));
                Assert.assertTrue((String)("Expected relationship " + rel3 + " not found. "), (boolean)relationshipIDs.contains(rel3));
                continue;
            }
            if (childId.equals(doc2)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel2 + " not found. "), (boolean)relationshipIDs.contains(rel2));
                continue;
            }
            if (childId.equals(folder2)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel3 + " not found. "), (boolean)relationshipIDs.contains(rel3));
                continue;
            }
            Assert.assertEquals((long)0L, (long)relationshipIDs.size());
        }
    }

    @Test
    public void testGetChildren_RenditionFiltered() throws Exception {
        if (capabilities.getCapabilityRenditions() == CapabilityRendition.NONE) {
            return;
        }
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 0);
        for (CmisObject child : children.getItems()) {
            Assert.assertTrue((String)"Rendition filter works incorrect.", (child.getRenditions().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetChildren_SkipCount() throws Exception {
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 0);
        ArrayList<String> childrenIDs = new ArrayList<String>(6);
        for (CmisObject child : children.getItems()) {
            childrenIDs.add(child.getObjectInfo().getId());
        }
        Assert.assertEquals((long)6L, (long)childrenIDs.size());
        children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, false, true, null, "cmis:none", null, -1, 3);
        ArrayList<String> childrenIDsPage = new ArrayList<String>(6);
        for (CmisObject child : children.getItems()) {
            childrenIDsPage.add(child.getObjectInfo().getId());
        }
        Assert.assertEquals((long)3L, (long)childrenIDsPage.size());
        Iterator iterator0 = childrenIDs.iterator();
        int skip = 3;
        while (skip-- > 0) {
            iterator0.next();
            iterator0.remove();
        }
        Assert.assertEquals(childrenIDs, childrenIDsPage);
    }

    @Test
    public void testGetDescendants() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        HashMap<String, List<String>> exp = new HashMap<String, List<String>>();
        exp.put(doc1, null);
        exp.put(doc2, null);
        exp.put(doc3, null);
        exp.put(doc4, null);
        exp.put(doc5, null);
        exp.put(doc6, null);
        exp.put(folder1, new ArrayList());
        exp.put(folder2, Arrays.asList(folder3, doc3));
        exp.put(folder3, Arrays.asList(doc4));
        this.validateTree(descendants, exp);
        for (CmisObject o : this.objectTreeAsList(descendants)) {
            Assert.assertNull((Object)o.getPathSegment());
            Assert.assertNull((Object)o.getAllowableActions());
            Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
            Assert.assertEquals((long)0L, (long)o.getRelationship().size());
            Assert.assertEquals((long)0L, (long)o.getRenditions().size());
        }
    }

    @Test
    public void testGetDescendants_AllowableActions() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, true, IncludeRelationships.NONE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(descendants);
        Assert.assertEquals((long)9L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertNotNull((String)"Allowable actions must be present in result.", (Object)o.getAllowableActions());
        }
    }

    @Test
    public void testGetDescendants_Depth_InvalidArgumentException() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        try {
            connection.getDescendants(testRootFolderId, 0, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
            Assert.fail((String)"InvalidArgumentException must be thrown, depth 0 is not allowed. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDescendants_DepthLimit() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, 2, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        HashMap<String, List<String>> exp = new HashMap<String, List<String>>();
        exp.put(doc1, null);
        exp.put(doc2, null);
        exp.put(doc3, null);
        exp.put(doc5, null);
        exp.put(doc6, null);
        exp.put(folder1, new ArrayList());
        exp.put(folder2, Arrays.asList(folder3, doc3));
        exp.put(folder3, new ArrayList());
        this.validateTree(descendants, exp);
    }

    @Test
    public void testGetDescendants_FilterNotValidException() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        try {
            String filter = "(,*";
            connection.getDescendants(testRootFolderId, 2, false, IncludeRelationships.NONE, false, true, filter, "cmis:none");
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDescendants_InvalidArgumentException() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        try {
            connection.getDescendants(doc1, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
            Assert.fail((String)"InvalidArgumentException must be thrown since try get descendants from not folder object. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDescendants_PathSegment() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(descendants);
        Assert.assertEquals((long)9L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertNotNull((String)"Path segment must be present in result.", (Object)o.getPathSegment());
        }
    }

    @Test
    public void testGetDescendants_PropertyFiltered() throws Exception {
        if (!capabilities.isCapabilityGetDescendants()) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, "cmis:name,cmis:path", "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(descendants);
        Assert.assertEquals((long)9L, (long)list.size());
        for (CmisObject o : list) {
            BaseType baseType = o.getObjectInfo().getBaseType();
            HashSet<String> queryNames = new HashSet<String>();
            for (Map.Entry e : o.getProperties().entrySet()) {
                queryNames.add(((Property)e.getValue()).getQueryName());
            }
            if (baseType == BaseType.DOCUMENT) {
                Assert.assertEquals((long)1L, (long)queryNames.size());
                Assert.assertTrue((String)"Unexpected property in result. ", (boolean)((String)queryNames.iterator().next()).equalsIgnoreCase("cmis:name"));
                continue;
            }
            if (baseType != BaseType.FOLDER) continue;
            Assert.assertEquals((long)2L, (long)queryNames.size());
            for (String q : queryNames) {
                Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetDescendants_Relationships() throws Exception {
        if (!capabilities.isCapabilityGetDescendants() || !isRelationshipsSupported) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, false, IncludeRelationships.SOURCE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(descendants);
        Assert.assertEquals((long)9L, (long)list.size());
        for (CmisObject o : list) {
            String id = o.getObjectInfo().getId();
            List relationships = o.getRelationship();
            HashSet<String> relationshipIDs = new HashSet<String>(relationships.size());
            for (CmisObject rel : relationships) {
                relationshipIDs.add(rel.getObjectInfo().getId());
            }
            if (id.equals(doc1)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel2 + " not found. "), (boolean)relationshipIDs.contains(rel2));
                continue;
            }
            if (id.equals(doc3)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel1 + " not found. "), (boolean)relationshipIDs.contains(rel1));
                continue;
            }
            if (id.equals(folder2)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel3 + " not found. "), (boolean)relationshipIDs.contains(rel3));
                continue;
            }
            Assert.assertEquals((long)0L, (long)relationshipIDs.size());
        }
    }

    @Test
    public void testGetDescendants_RenditionsFiltered() throws Exception {
        if (!capabilities.isCapabilityGetDescendants() && capabilities.getCapabilityRenditions() == CapabilityRendition.NONE) {
            return;
        }
        List descendants = connection.getDescendants(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(descendants);
        Assert.assertEquals((long)9L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertTrue((String)"Rendition filter works incorrect.", (o.getRenditions().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetFolderParent() throws Exception {
        CmisObject parent = connection.getFolderParent(folder1, true, null);
        Assert.assertNotNull((String)"No parent s for folder. ", (Object)parent);
        Assert.assertEquals((Object)testRootFolderId, (Object)parent.getObjectInfo().getId());
        Assert.assertNull((Object)parent.getPathSegment());
        Assert.assertNull((Object)parent.getAllowableActions());
        Assert.assertEquals((long)0L, (long)parent.getPolicyIds().size());
        Assert.assertEquals((long)0L, (long)parent.getRelationship().size());
        Assert.assertEquals((long)0L, (long)parent.getRenditions().size());
    }

    @Test
    public void testGetFolderParent_FilterNotValidException() throws Exception {
        try {
            String filter = "(,*";
            connection.getFolderParent(folder1, false, filter);
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFolderParent_PropertyFiltered() throws Exception {
        CmisObject parent = connection.getFolderParent(folder1, true, "cmis:name,cmis:path");
        Assert.assertNotNull((String)"No parent s for folder. ", (Object)parent);
        HashSet<String> queryNames = new HashSet<String>();
        for (Map.Entry e : parent.getProperties().entrySet()) {
            queryNames.add(((Property)e.getValue()).getQueryName());
        }
        Assert.assertEquals((long)2L, (long)queryNames.size());
        for (String q : queryNames) {
            Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetFolderParent_RootFolder_InvalidArgumentException() throws Exception {
        try {
            connection.getFolderParent(rootFolderID, true, null);
            Assert.fail((String)"InvalidArgumentException must be thrown, can't get parent of root folder. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFolderTree() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        HashMap<String, List<String>> exp = new HashMap<String, List<String>>();
        exp.put(folder1, new ArrayList());
        exp.put(folder2, Arrays.asList(folder3));
        exp.put(folder3, new ArrayList());
        this.validateTree(tree, exp);
        for (CmisObject o : this.objectTreeAsList(tree)) {
            Assert.assertNull((Object)o.getPathSegment());
            Assert.assertNull((Object)o.getAllowableActions());
            Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
            Assert.assertEquals((long)0L, (long)o.getRelationship().size());
            Assert.assertEquals((long)0L, (long)o.getRenditions().size());
        }
    }

    @Test
    public void testGetFolderTree_AllowableActions() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, true, IncludeRelationships.NONE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(tree);
        Assert.assertEquals((long)3L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertNotNull((String)"Allowable actions must be present in result.", (Object)o.getAllowableActions());
        }
    }

    @Test
    public void testGetFolderTree_Depth_InvalidArgumentException() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        try {
            connection.getFolderTree(testRootFolderId, 0, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
            Assert.fail((String)"InvalidArgumentException must be thrown, depth 0 is not allowed. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFolderTree_DepthLimit() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, 1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        HashMap<String, List<String>> exp = new HashMap<String, List<String>>();
        exp.put(folder1, new ArrayList());
        exp.put(folder2, new ArrayList());
        this.validateTree(tree, exp);
    }

    @Test
    public void testGetFolderTree_FilterNotValidException() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        try {
            String filter = "(,*";
            connection.getFolderTree(testRootFolderId, 2, false, IncludeRelationships.NONE, false, true, filter, "cmis:none");
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFolderTree_InvalidArgumentException() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        try {
            connection.getDescendants(doc1, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
            Assert.fail((String)"InvalidArgumentException must be thrown since try get descendants folders from not folder object. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFolderTree_PathSegment() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(tree);
        Assert.assertEquals((long)3L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertNotNull((String)"Path segment must be present in result.", (Object)o.getPathSegment());
        }
    }

    @Test
    public void testGetFolderTree_PropertyFiltered() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree()) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, "cmis:name,cmis:path", "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(tree);
        Assert.assertEquals((long)3L, (long)list.size());
        for (CmisObject o : list) {
            HashSet<String> queryNames = new HashSet<String>();
            for (Map.Entry e : o.getProperties().entrySet()) {
                queryNames.add(((Property)e.getValue()).getQueryName());
            }
            Assert.assertEquals((long)2L, (long)queryNames.size());
            for (String q : queryNames) {
                Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetFolderTree_Relationships() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree() || !isRelationshipsSupported) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, false, IncludeRelationships.SOURCE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(tree);
        Assert.assertEquals((long)3L, (long)list.size());
        for (CmisObject o : list) {
            String id = o.getObjectInfo().getId();
            List relationships = o.getRelationship();
            HashSet<String> relationshipIDs = new HashSet<String>(relationships.size());
            for (CmisObject rel : relationships) {
                relationshipIDs.add(rel.getObjectInfo().getId());
            }
            if (id.equals(folder2)) {
                Assert.assertEquals((long)1L, (long)relationshipIDs.size());
                Assert.assertTrue((String)("Expected relationship " + rel3 + " not found. "), (boolean)relationshipIDs.contains(rel3));
                continue;
            }
            Assert.assertEquals((long)0L, (long)relationshipIDs.size());
        }
    }

    @Test
    public void testGetFolderTree_RenditionsFiltered() throws Exception {
        if (!capabilities.isCapabilityGetFolderTree() && capabilities.getCapabilityRenditions() == CapabilityRendition.NONE) {
            return;
        }
        List tree = connection.getFolderTree(testRootFolderId, -1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        List<CmisObject> list = this.objectTreeAsList(tree);
        Assert.assertEquals((long)3L, (long)list.size());
        for (CmisObject o : list) {
            Assert.assertTrue((String)"Rendition filter works incorrect.", (o.getRenditions().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetObjectParents() throws Exception {
        List parents = connection.getObjectParents(doc1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        Assert.assertEquals((Object)testRootFolderId, (Object)((ObjectParent)parents.get(0)).getObject().getObjectInfo().getId());
        CmisObject o = ((ObjectParent)parents.get(0)).getObject();
        Assert.assertNull((Object)o.getPathSegment());
        Assert.assertNull((Object)o.getAllowableActions());
        Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
        Assert.assertEquals((long)0L, (long)o.getRelationship().size());
        Assert.assertEquals((long)0L, (long)o.getRenditions().size());
    }

    @Test
    public void testGetObjectParents_AllowableActions() throws Exception {
        List parents = connection.getObjectParents(doc1, true, IncludeRelationships.NONE, false, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        CmisObject parent = ((ObjectParent)parents.get(0)).getObject();
        Assert.assertNotNull((String)"AllowableActions must be present in result.", (Object)parent.getAllowableActions());
    }

    @Test
    public void testGetObjectParents_FilterNotValidException() throws Exception {
        try {
            String filter = "(,*";
            connection.getObjectParents(doc1, false, IncludeRelationships.NONE, false, true, filter, "cmis:none");
            Assert.fail((String)("Filter " + filter + " is not valid, FilterNotValidException must be thrown. "));
        }
        catch (FilterNotValidException filterNotValidException) {
            // empty catch block
        }
    }

    @Test
    public void testGetObjectParents_IncludePathSegment() throws Exception {
        List parents = connection.getObjectParents(doc3, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        ObjectParent parent = (ObjectParent)parents.get(0);
        Assert.assertNotNull((String)"RelativePathSegment must be present in result.", (Object)parent.getRelativePathSegment());
    }

    @Test
    public void testGetObjectParents_NotFileable_ConstraintException() throws Exception {
        try {
            if (rel1 != null) {
                connection.getObjectParents(rel1, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
                Assert.fail((String)("ConstraintException must be thrown since object " + rel1 + " (relationship) is not fileable."));
            }
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testGetObjectParents_PropertiesFIlter() throws Exception {
        String filter = "cmis:name,cmis:path";
        List parents = connection.getObjectParents(doc3, false, IncludeRelationships.NONE, false, true, filter, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        HashSet<String> queryNames = new HashSet<String>();
        for (Map.Entry e : ((ObjectParent)parents.get(0)).getObject().getProperties().entrySet()) {
            queryNames.add(((Property)e.getValue()).getQueryName());
        }
        Assert.assertEquals((long)2L, (long)queryNames.size());
        for (String q : queryNames) {
            Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetObjectParents_Relationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        List parents = connection.getObjectParents(doc3, false, IncludeRelationships.BOTH, false, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        CmisObject parent = ((ObjectParent)parents.get(0)).getObject();
        ArrayList<String> relationships = new ArrayList<String>();
        for (CmisObject rel : parent.getRelationship()) {
            relationships.add(rel.getObjectInfo().getId());
        }
        Assert.assertTrue((String)("Expected relationship " + rel3 + " not found in result. "), (relationships.size() == 1 && relationships.contains(rel3) ? 1 : 0) != 0);
    }

    @Test
    public void testGetObjectParents_RenditionsFiltered() throws Exception {
        List parents = connection.getObjectParents(doc3, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        Assert.assertNotNull(parents.get(0));
        Assert.assertTrue((String)"Renditions filter works incorrect.", (((ObjectParent)parents.get(0)).getObject().getRenditions().size() == 0 ? 1 : 0) != 0);
    }

    private void objectTreeAsMap(List<ItemsTree<CmisObject>> source, Map<String, List<String>> map) {
        for (ItemsTree<CmisObject> one : source) {
            CmisObject type = (CmisObject)one.getContainer();
            String id = type.getObjectInfo().getId();
            List children = one.getChildren();
            if (children != null) {
                ArrayList<String> l = new ArrayList<String>();
                if (children.size() > 0) {
                    for (ItemsTree c : children) {
                        l.add(((CmisObject)c.getContainer()).getObjectInfo().getId());
                    }
                    this.objectTreeAsMap(children, map);
                }
                map.put(id, l);
                continue;
            }
            map.put(id, null);
        }
    }

    private void validateTree(List<ItemsTree<CmisObject>> source, Map<String, List<String>> expected) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.objectTreeAsMap(source, result);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertEquals(expected.keySet(), result.keySet());
        for (Map.Entry<String, List<String>> e : expected.entrySet()) {
            List<String> v1 = e.getValue();
            List v2 = (List)result.get(e.getKey());
            if (v1 == null || v1.size() == 0) {
                Assert.assertTrue((String)("Object " + e.getKey() + " must not have children. "), (v2 == null || v2.size() == 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)"Number of children is incorrect. ", (v2 != null && v2.size() > 0 ? 1 : 0) != 0);
            for (String s : v1) {
                Assert.assertTrue((String)("Missing item " + s + " in tree hierarchy. "), (boolean)v2.contains(s));
            }
        }
    }
}

