/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;

public class PolicyTest
extends BaseTest {
    private static TypeDefinition folderType;
    private static TypeDefinition policyType;
    private static String controllablePolicyObject;
    private static TypeDefinition controllablePolicyType;
    private static String notControllablePolicyObject;
    private static TypeDefinition notControllablePolicyType;
    private static String testRootFolderId;

    @BeforeClass
    public static void start() throws Exception {
        String targetId;
        String sourceId;
        folderType = connection.getTypeDefinition("cmis:folder");
        if (isPoliciesSupported) {
            policyType = connection.getTypeDefinition("cmis:policy");
        }
        testRootFolderId = PolicyTest.createFolder(rootFolderID, folderType.getId(), "policy_testroot", null, null, null);
        List allTypes = connection.getTypeDescendants(null, -1, true);
        controllablePolicyType = PolicyTest.getControllablePolicyType(allTypes);
        notControllablePolicyType = PolicyTest.getNotControllablePolicyType(allTypes);
        if (controllablePolicyType != null) {
            switch (controllablePolicyType.getBaseId()) {
                case DOCUMENT: {
                    controllablePolicyObject = PolicyTest.createDocument(testRootFolderId, controllablePolicyType.getId(), PolicyTest.generateName(controllablePolicyType, null), null, null, null, null, null);
                    break;
                }
                case FOLDER: {
                    controllablePolicyObject = PolicyTest.createFolder(testRootFolderId, controllablePolicyType.getId(), PolicyTest.generateName(controllablePolicyType, null), null, null, null);
                    break;
                }
                case POLICY: {
                    controllablePolicyObject = PolicyTest.createPolicy(testRootFolderId, controllablePolicyType.getId(), PolicyTest.generateName(controllablePolicyType, null), null, null, null, null);
                    break;
                }
                case RELATIONSHIP: {
                    sourceId = PolicyTest.createDocument(testRootFolderId, "cmis:document", PolicyTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    targetId = PolicyTest.createDocument(testRootFolderId, "cmis:document", PolicyTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    controllablePolicyObject = PolicyTest.createRelationship(controllablePolicyType.getId(), PolicyTest.generateName(controllablePolicyType, null), sourceId, targetId, null, null, null);
                }
            }
        }
        if (notControllablePolicyType != null) {
            switch (notControllablePolicyType.getBaseId()) {
                case DOCUMENT: {
                    notControllablePolicyObject = PolicyTest.createDocument(testRootFolderId, notControllablePolicyType.getId(), PolicyTest.generateName(notControllablePolicyType, null), null, null, null, null, null);
                    break;
                }
                case FOLDER: {
                    notControllablePolicyObject = PolicyTest.createFolder(testRootFolderId, notControllablePolicyType.getId(), PolicyTest.generateName(notControllablePolicyType, null), null, null, null);
                    break;
                }
                case POLICY: {
                    notControllablePolicyObject = PolicyTest.createPolicy(testRootFolderId, notControllablePolicyType.getId(), PolicyTest.generateName(notControllablePolicyType, null), null, null, null, null);
                    break;
                }
                case RELATIONSHIP: {
                    sourceId = PolicyTest.createDocument(testRootFolderId, "cmis:document", PolicyTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    targetId = PolicyTest.createDocument(testRootFolderId, "cmis:document", PolicyTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    notControllablePolicyObject = PolicyTest.createRelationship(notControllablePolicyType.getId(), PolicyTest.generateName(notControllablePolicyType, null), sourceId, targetId, null, null, null);
                }
            }
        }
        System.out.println("Running Policy Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            PolicyTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testApplyPolicy() throws Exception {
        if (!isPoliciesSupported || controllablePolicyObject == null) {
            return;
        }
        String policy = PolicyTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), PolicyTest.generateName(policyType, null), "policy1", null, null, null);
        connection.applyPolicy(policy, controllablePolicyObject);
        List policies = connection.getAppliedPolicies(controllablePolicyObject, true, null);
        Assert.assertTrue((policies.size() >= 1 ? 1 : 0) != 0);
        HashSet<String> policiesId = new HashSet<String>(policies.size());
        for (CmisObject o : policies) {
            policiesId.add(o.getObjectInfo().getId());
        }
        Assert.assertTrue((String)"Expected policy is not found. ", (boolean)policiesId.contains(policy));
    }

    @Test
    public void testApplyPolicy_ConstraintException() throws Exception {
        if (!isPoliciesSupported || notControllablePolicyObject == null) {
            return;
        }
        String policy = PolicyTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), PolicyTest.generateName(policyType, null), "policy1", null, null, null);
        try {
            connection.applyPolicy(policy, notControllablePolicyObject);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePolicy_ConstraintException() throws Exception {
        if (!isPoliciesSupported || notControllablePolicyObject == null) {
            return;
        }
        try {
            connection.removePolicy(null, notControllablePolicyObject);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePolicy_Simple() throws Exception {
        if (!isPoliciesSupported || controllablePolicyObject == null) {
            return;
        }
        String policy = PolicyTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), PolicyTest.generateName(policyType, null), "policy1", null, null, null);
        connection.applyPolicy(policy, controllablePolicyObject);
        connection.removePolicy(policy, controllablePolicyObject);
        List policies = connection.getAppliedPolicies(controllablePolicyObject, true, null);
        HashSet<String> policiesId = new HashSet<String>(policies.size());
        for (CmisObject o : policies) {
            policiesId.add(o.getObjectInfo().getId());
        }
        Assert.assertFalse((String)("Policy " + policy + " must be removed. "), (boolean)policiesId.contains(policy));
    }
}

