/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.model.AccessControlEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmisUtils {
    public static final Comparator<ObjectData> versionComparator = new Comparator<ObjectData>(){

        @Override
        public int compare(ObjectData object1, ObjectData object2) {
            Calendar c1 = object1.getLastModificationDate();
            Calendar c2 = object2.getLastModificationDate();
            return c2.compareTo(c1);
        }
    };
    public static ItemsIterator<Object> EMPTY_ITEMS_ITERATOR = new EmptyItemsIterator();

    public static <T> ItemsIterator<T> emptyItemsIterator() {
        return EMPTY_ITEMS_ITERATOR;
    }

    public static List<AccessControlEntry> createAclFromPermissionMap(Map<String, Set<String>> permissions) {
        ArrayList<AccessControlEntry> acl = new ArrayList<AccessControlEntry>();
        if (permissions != null) {
            for (Map.Entry<String, Set<String>> e : permissions.entrySet()) {
                AccessControlEntry ace = new AccessControlEntry(e.getKey(), e.getValue());
                acl.add(ace);
            }
        }
        return acl;
    }

    public static XMLGregorianCalendar fromCalendar(Calendar calendar) {
        XMLGregorianCalendar xmlCalendar;
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        }
        catch (DatatypeConfigurationException e) {
            String msg = "Unable get XMLGregorianCalendar.";
            throw new RuntimeException(msg, e);
        }
        xmlCalendar.setYear(calendar.get(1));
        xmlCalendar.setMonth(calendar.get(2) + 1);
        xmlCalendar.setDay(calendar.get(5));
        xmlCalendar.setTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        return xmlCalendar;
    }

    public static List<AccessControlEntry> mergeACLs(List<AccessControlEntry> existedAcl, List<AccessControlEntry> addAcl, List<AccessControlEntry> removeAcl) {
        HashMap<String, Set<String>> cache = new HashMap<String, Set<String>>();
        CmisUtils.addAclToPermissionMap(cache, existedAcl);
        CmisUtils.addAclToPermissionMap(cache, addAcl);
        CmisUtils.removeAclFromPermissionMap(cache, removeAcl);
        return CmisUtils.createAclFromPermissionMap(cache);
    }

    public static void addAclToPermissionMap(Map<String, Set<String>> map, List<AccessControlEntry> acl) {
        if (acl != null) {
            for (AccessControlEntry ace : acl) {
                String principal = ace.getPrincipal();
                if (principal == null) continue;
                Set<String> permissions = map.get(principal);
                if (permissions == null) {
                    permissions = new HashSet<String>();
                    map.put(principal, permissions);
                }
                permissions.addAll(ace.getPermissions());
            }
        }
    }

    public static void removeAclFromPermissionMap(Map<String, Set<String>> map, List<AccessControlEntry> acl) {
        if (acl != null) {
            for (AccessControlEntry ace : acl) {
                Set<String> permissions;
                String principal = ace.getPrincipal();
                if (principal == null || (permissions = map.get(principal)) == null) continue;
                permissions.removeAll(ace.getPermissions());
                if (permissions.size() != 0) continue;
                map.remove(principal);
            }
        }
    }

    private CmisUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyItemsIterator
    implements ItemsIterator<Object> {
        private EmptyItemsIterator() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void skip(int skip) throws NoSuchElementException {
            throw new NoSuchElementException("skip");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException("next");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

