/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.math.BigInteger;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.core.EnumIncludeRelationships;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.messaging.CmisObjectListType;
import org.xcmis.messaging.Query;
import org.xcmis.messaging.QueryResponse;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.DiscoveryServicePort;
import org.xcmis.spi.ChangeLogTokenHolder;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="DiscoveryService", portName="DiscoveryServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class DiscoveryServicePortImpl
implements DiscoveryServicePort {
    private static final Log LOG = ExoLogger.getLogger(DiscoveryServicePortImpl.class);

    @Override
    public QueryResponse query(Query parameters) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation query");
        }
        Connection conn = null;
        try {
            String repositoryId = parameters.getRepositoryId();
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            String statement = parameters.getStatement();
            boolean allVersions = parameters.getSearchAllVersions() == null || parameters.getSearchAllVersions().isNil() ? false : (Boolean)parameters.getSearchAllVersions().getValue();
            boolean includeAllowableActions = parameters.getIncludeAllowableActions() == null || parameters.getIncludeAllowableActions().isNil() ? false : (Boolean)parameters.getIncludeAllowableActions().getValue();
            IncludeRelationships includeRelationships = parameters.getIncludeRelationships() == null || parameters.getIncludeRelationships().isNil() ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)((EnumIncludeRelationships)((Object)parameters.getIncludeRelationships().getValue())).value());
            String renditionFilter = parameters.getRenditionFilter() == null || parameters.getRenditionFilter().isNil() ? null : (String)parameters.getRenditionFilter().getValue();
            int maxItems = parameters.getMaxItems() == null || parameters.getMaxItems().isNil() ? Integer.MAX_VALUE : ((BigInteger)parameters.getMaxItems().getValue()).intValue();
            int skipCount = parameters.getSkipCount() == null || parameters.getSkipCount().isNil() ? 0 : ((BigInteger)parameters.getSkipCount().getValue()).intValue();
            QueryResponse response = new QueryResponse();
            CmisObjectListType result = TypeConverter.getCmisObjectListType((ItemsList<CmisObject>)conn.query(statement, allVersions, includeAllowableActions, includeRelationships, true, renditionFilter, maxItems, skipCount));
            response.setObjects(result);
            QueryResponse queryResponse = response;
            return queryResponse;
        }
        catch (Exception e) {
            LOG.error((Object)("Query error: " + e.getMessage()), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String propertyFilter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, CmisExtensionType extension, Holder<CmisObjectListType> objects) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation getContentChanges");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objects.value = TypeConverter.getCmisObjectListType((ItemsList<CmisObject>)conn.getContentChanges(changeLogToken == null ? null : new ChangeLogTokenHolder(), includeProperties == null ? false : includeProperties, propertyFilter, includePolicyIds == null ? false : includePolicyIds, includeACL == null ? false : includeACL, true, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue()));
        }
        catch (Exception e) {
            LOG.error((Object)("Get content changes error: " + e.getMessage()));
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

