/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.math.BigInteger;
import java.util.List;
import javax.activation.DataHandler;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.xcmis.core.CmisAccessControlListType;
import org.xcmis.core.CmisAllowableActionsType;
import org.xcmis.core.CmisObjectType;
import org.xcmis.core.CmisPropertiesType;
import org.xcmis.core.CmisRenditionType;
import org.xcmis.core.EnumIncludeRelationships;
import org.xcmis.core.EnumUnfileObject;
import org.xcmis.core.EnumVersioningState;
import org.xcmis.messaging.CmisContentStreamType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.messaging.DeleteTreeResponse;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.ObjectServicePort;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ChangeTokenHolder;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.utils.Logger;
import org.xcmis.spi.utils.MimeType;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="ObjectService", portName="ObjectServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class ObjectServicePortImpl
implements ObjectServicePort {
    private static final Logger LOG = Logger.getLogger(ObjectServicePortImpl.class);

    @Override
    public void createDocument(String repositoryId, CmisPropertiesType properties, String folderId, CmisContentStreamType contentStream, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation createDocument");
        }
        BaseContentStream cs = null;
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            if (contentStream != null) {
                cs = new BaseContentStream(contentStream.getStream().getInputStream(), contentStream.getFilename(), MimeType.fromString((String)contentStream.getMimeType()));
            }
            objectId.value = conn.createDocument(folderId, TypeConverter.getPropertyMap(properties), (ContentStream)cs, TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies, versioningState == null ? VersioningState.MAJOR : VersioningState.fromValue((String)versioningState.value()));
        }
        catch (Exception e) {
            LOG.error("Create document error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void createDocumentFromSource(String repositoryId, String sourceId, CmisPropertiesType properties, String folderId, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation createDocumentFromSource");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objectId.value = conn.createDocumentFromSource(sourceId, folderId, TypeConverter.getPropertyMap(properties), TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies, versioningState == null ? VersioningState.MAJOR : VersioningState.fromValue((String)versioningState.value()));
        }
        catch (Exception e) {
            LOG.error("Create document from source error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void createFolder(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation createFolder");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objectId.value = conn.createFolder(folderId, TypeConverter.getPropertyMap(properties), TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies);
        }
        catch (Exception e) {
            LOG.error("Create folder error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void createPolicy(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation createPolicy");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objectId.value = conn.createPolicy(folderId, TypeConverter.getPropertyMap(properties), TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies);
        }
        catch (Exception e) {
            LOG.error("Create policy error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void createRelationship(String repositoryId, CmisPropertiesType properties, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation createRelationship");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objectId.value = conn.createRelationship(TypeConverter.getPropertyMap(properties), TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies);
        }
        catch (Exception e) {
            LOG.error("Create relationship error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> documentId, Holder<String> changeToken, Holder<CmisExtensionType> extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation deleteContentStream");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            ChangeTokenHolder hold = new ChangeTokenHolder();
            if (changeToken != null) {
                hold.setValue(changeToken.value);
            }
            documentId.value = conn.deleteContentStream((String)documentId.value, (ChangeTokenHolder)(changeToken != null ? hold : null));
        }
        catch (Exception e) {
            LOG.error("Delete document's content error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisExtensionType deleteObject(String repositoryId, String objectId, Boolean allVersions, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation deleteObject");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.deleteObject(objectId, allVersions);
        }
        catch (Exception e) {
            LOG.error("Delete object error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }

    @Override
    public DeleteTreeResponse.FailedToDelete deleteTree(String repositoryId, String folderId, Boolean allVersions, EnumUnfileObject unfileObject, Boolean continueOnFailure, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation deleteTree");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            DeleteTreeResponse.FailedToDelete failed = new DeleteTreeResponse.FailedToDelete();
            failed.getObjectIds().addAll(conn.deleteTree(folderId, allVersions, unfileObject == null ? UnfileObject.DELETE : UnfileObject.fromValue((String)unfileObject.value()), Boolean.valueOf(continueOnFailure == null ? false : continueOnFailure)));
            DeleteTreeResponse.FailedToDelete failedToDelete = failed;
            return failedToDelete;
        }
        catch (Exception e) {
            LOG.error("Delete folder tree error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisAllowableActionsType getAllowableActions(String repositoryId, String objectId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getAllowableActions");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisAllowableActionsType cmisAllowableActionsType = TypeConverter.getCmisAllowableActionsType(conn.getAllowableActions(objectId));
            return cmisAllowableActionsType;
        }
        catch (Exception e) {
            LOG.error("Get allowable actions error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisContentStreamType getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getContentStream");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisContentStreamType stream = new CmisContentStreamType();
            ContentStream cs = conn.getContentStream(objectId, streamId);
            stream.setFilename(cs.getFileName());
            String mediaType = cs.getMediaType().toString();
            stream.setMimeType(mediaType);
            if (cs.length() != -1L) {
                stream.setLength(BigInteger.valueOf(cs.length()));
            }
            stream.setStream(new DataHandler((Object)cs.getStream(), mediaType));
            CmisContentStreamType cmisContentStreamType = stream;
            return cmisContentStreamType;
        }
        catch (Exception e) {
            LOG.error("Get content stream error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisObjectType getObject(String repositoryId, String objectId, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getObject");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectType cmisObjectType = TypeConverter.getCmisObjectType(conn.getObject(objectId, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePolicyIds == null ? false : includePolicyIds, includeACL == null ? false : includeACL, false, propertyFilter, renditionFilter));
            return cmisObjectType;
        }
        catch (Exception e) {
            LOG.error("Get object error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisObjectType getObjectByPath(String repositoryId, String path, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getObjectByPath");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectType cmisObjectType = TypeConverter.getCmisObjectType(conn.getObjectByPath(path, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePolicyIds == null ? false : includePolicyIds, includeACL == null ? false : includeACL, false, propertyFilter, renditionFilter));
            return cmisObjectType;
        }
        catch (Exception e) {
            LOG.error("Get object by path error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisPropertiesType getProperties(String repositoryId, String objectId, String propertyFilter, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getProperties");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisPropertiesType cmisPropertiesType = TypeConverter.getCmisPropertiesType(conn.getProperties(objectId, false, propertyFilter));
            return cmisPropertiesType;
        }
        catch (Exception e) {
            LOG.error("Get properties error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisRenditionType> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getRenditions");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisRenditionType> list = TypeConverter.getCmisRenditionTypeList(conn.getRenditions(objectId, renditionFilter, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue(), skipCount == null ? 0 : skipCount.intValue()));
            return list;
        }
        catch (Exception e) {
            LOG.error("Get renditions error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, Holder<CmisExtensionType> extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation moveObject");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            objectId.value = conn.moveObject((String)objectId.value, targetFolderId, sourceFolderId);
        }
        catch (Exception e) {
            LOG.error("Move object error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> documentId, Boolean overwriteFlag, Holder<String> changeToken, CmisContentStreamType contentStream, Holder<CmisExtensionType> extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation setContentStream");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            BaseContentStream cs = null;
            if (contentStream != null) {
                cs = new BaseContentStream(contentStream.getStream().getInputStream(), contentStream.getFilename(), MimeType.fromString((String)contentStream.getMimeType()));
            }
            ChangeTokenHolder hold = new ChangeTokenHolder();
            if (changeToken != null) {
                hold.setValue(changeToken.value);
            }
            documentId.value = conn.setContentStream((String)documentId.value, (ContentStream)cs, changeToken == null ? null : hold, Boolean.valueOf(overwriteFlag == null ? true : overwriteFlag));
        }
        catch (Exception e) {
            LOG.error("Set content stream error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, CmisPropertiesType properties, Holder<CmisExtensionType> extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation updateProperties");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            ChangeTokenHolder hold = new ChangeTokenHolder();
            if (changeToken != null) {
                hold.setValue(changeToken.value);
            }
            objectId.value = conn.updateProperties((String)objectId.value, changeToken.value == null ? null : hold, TypeConverter.getPropertyMap(properties));
        }
        catch (Exception e) {
            LOG.error("Update properties error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

