/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.xcmis.core.CmisRepositoryInfoType;
import org.xcmis.core.CmisTypeDefinitionType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.messaging.CmisRepositoryEntryType;
import org.xcmis.messaging.CmisTypeContainer;
import org.xcmis.messaging.CmisTypeDefinitionListType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.RepositoryServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.RepositoryShortInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.Logger;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="RepositoryService", portName="RepositoryServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class RepositoryServicePortImpl
implements RepositoryServicePort {
    private static final Logger LOG = Logger.getLogger(RepositoryServicePortImpl.class);

    @Override
    public List<CmisRepositoryEntryType> getRepositories(CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getRepositories");
        }
        Set entries = CmisRegistry.getInstance().getStorageInfos();
        Connection conn = null;
        try {
            ArrayList<CmisRepositoryEntryType> res = new ArrayList<CmisRepositoryEntryType>();
            for (RepositoryShortInfo info : entries) {
                conn = CmisRegistry.getInstance().getConnection(info.getRepositoryId());
                RepositoryInfo repoInfo = conn.getStorage().getRepositoryInfo();
                CmisRepositoryEntryType type = new CmisRepositoryEntryType();
                type.setRepositoryId(repoInfo.getRepositoryId());
                type.setRepositoryName(repoInfo.getRepositoryName());
                res.add(type);
            }
            ArrayList<CmisRepositoryEntryType> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Get type children error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisRepositoryInfoType getRepositoryInfo(String repositoryId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getRepositoryInfo");
        }
        Connection conn = null;
        conn = CmisRegistry.getInstance().getConnection(repositoryId);
        return TypeConverter.getCmisRepositoryInfoType(conn.getStorage().getRepositoryInfo());
    }

    @Override
    public CmisTypeDefinitionListType getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getTypeChildren");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisTypeDefinitionListType cmisTypeDefinitionListType = TypeConverter.getCmisTypeDefinitionListType((ItemsList<TypeDefinition>)conn.getTypeChildren(typeId, includePropertyDefinitions == null ? false : includePropertyDefinitions, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue(), skipCount == null ? 0 : skipCount.intValue()));
            return cmisTypeDefinitionListType;
        }
        catch (Exception e) {
            LOG.error("Get type children error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisTypeDefinitionType getTypeDefinition(String repositoryId, String typeId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getTypeDefinition");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisTypeDefinitionType cmisTypeDefinitionType = TypeConverter.getCmisTypeDefinitionType(conn.getTypeDefinition(typeId));
            return cmisTypeDefinitionType;
        }
        catch (Exception e) {
            LOG.error("Get type definition error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisTypeContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getTypeDescendants");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisTypeContainer> list = TypeConverter.getCmisTypeContainerList(conn.getTypeDescendants(typeId, depth == null ? 1 : depth.intValue(), includePropertyDefinitions == null ? false : includePropertyDefinitions));
            return list;
        }
        catch (Exception e) {
            LOG.error("Get type descendants error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

