/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.context.StandardAttributeResolver;
import org.xhtmlrenderer.context.StylesheetFactoryImpl;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.extend.lib.DOMTreeResolver;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.newmatch.Matcher;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.sheet.FontFaceRule;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.util.XRLog;

public class StyleReference {
    private @Nullable NamespaceHandler _nsh;
    private @Nullable Document _doc;
    private final StylesheetFactoryImpl _stylesheetFactory;
    private @Nullable Matcher _matcher;
    private UserAgentCallback _uac;

    public StyleReference(UserAgentCallback userAgent) {
        this._uac = userAgent;
        this._stylesheetFactory = new StylesheetFactoryImpl(userAgent);
    }

    public void setDocumentContext(SharedContext context, NamespaceHandler nsh, Document doc, UserInterface ui) {
        this._nsh = nsh;
        this._doc = doc;
        StandardAttributeResolver attRes = new StandardAttributeResolver(this._nsh, this._uac, ui);
        List<StylesheetInfo> infos = this.getStylesheets();
        XRLog.match("media = " + context.getMedia());
        this._matcher = new Matcher(new DOMTreeResolver(), attRes, this._stylesheetFactory, this.readAndParseAll(infos, context.getMedia()), context.getMedia());
    }

    private List<Stylesheet> readAndParseAll(List<StylesheetInfo> infos, String medium) {
        ArrayList<Stylesheet> result = new ArrayList<Stylesheet>(infos.size() + 15);
        for (StylesheetInfo info : infos) {
            if (!info.appliesToMedia(medium)) continue;
            Stylesheet sheet = this._stylesheetFactory.getStylesheet(info);
            if (sheet != null) {
                if (!sheet.getImportRules().isEmpty()) {
                    result.addAll(this.readAndParseAll(sheet.getImportRules(), medium));
                }
                result.add(sheet);
                continue;
            }
            XRLog.load(Level.WARNING, "Unable to load CSS from " + info.getUri());
        }
        return result;
    }

    public boolean isHoverStyled(Element e) {
        return this._matcher.isHoverStyled(e);
    }

    public Map<String, CSSPrimitiveValue> getCascadedPropertiesMap(Element e) {
        CascadedStyle cs = this._matcher.getCascadedStyle(e, false);
        LinkedHashMap<String, CSSPrimitiveValue> props = new LinkedHashMap<String, CSSPrimitiveValue>();
        Iterator<PropertyDeclaration> i = cs.getCascadedPropertyDeclarations();
        while (i.hasNext()) {
            PropertyDeclaration pd = i.next();
            String propName = pd.getPropertyName();
            CSSName cssName = CSSName.getByPropertyName(propName);
            props.put(propName, cs.propertyByName(cssName).getValue());
        }
        return props;
    }

    public @Nullable CascadedStyle getPseudoElementStyle(Node node, String pseudoElement) {
        Element e = node.getNodeType() == 1 ? (Element)node : (Element)node.getParentNode();
        return this._matcher.getPECascadedStyle(e, pseudoElement);
    }

    public CascadedStyle getCascadedStyle(@Nullable Element e, boolean restyle) {
        if (e == null) {
            return CascadedStyle.emptyCascadedStyle;
        }
        return this._matcher.getCascadedStyle(e, restyle);
    }

    @CheckReturnValue
    public @NonNull PageInfo getPageStyle(@Nullable String pageName, String pseudoPage) {
        return this._matcher.getPageCascadedStyle(pageName, pseudoPage);
    }

    public void flushStyleSheets() {
        String uri = this._uac.getBaseURL();
        if (this._stylesheetFactory.containsStylesheet(uri)) {
            this._stylesheetFactory.removeCachedStylesheet(uri);
            XRLog.cssParse("Removing stylesheet '" + uri + "' from cache by request.");
        } else {
            XRLog.cssParse("Requested removing stylesheet '" + uri + "', but it's not in cache.");
        }
    }

    public void flushAllStyleSheets() {
        this._stylesheetFactory.flushCachedStylesheets();
    }

    private List<StylesheetInfo> getStylesheets() {
        ArrayList<StylesheetInfo> infos = new ArrayList<StylesheetInfo>();
        long st = System.currentTimeMillis();
        this._nsh.getDefaultStylesheet().ifPresent(defaultStylesheet -> infos.add((StylesheetInfo)defaultStylesheet));
        infos.addAll(this._nsh.getStylesheets(this._doc));
        XRLog.load("TIME: parse stylesheets in " + (System.currentTimeMillis() - st) + " ms.");
        return infos;
    }

    public void removeStyle(Element e) {
        if (this._matcher != null) {
            this._matcher.removeStyle(e);
        }
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._matcher.getFontFaceRules();
    }

    public void setUserAgentCallback(UserAgentCallback userAgentCallback) {
        this._uac = userAgentCallback;
        this._stylesheetFactory.setUserAgentCallback(userAgentCallback);
    }

    public void setSupportCMYKColors(boolean b) {
        this._stylesheetFactory.setSupportCMYKColors(b);
    }
}

