/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.MarginBox;
import org.xhtmlrenderer.render.RenderingContext;

public class PageBox {
    private static final MarginArea[] MARGIN_AREA_DEFS = new MarginArea[]{new TopLeftCorner(), new TopMarginArea(), new TopRightCorner(), new LeftMarginArea(), new RightMarginArea(), new BottomLeftCorner(), new BottomMarginArea(), new BottomRightCorner()};
    private static final int LEADING_TRAILING_SPLIT = 5;
    private final CalculatedStyle _style;
    private int _top;
    private int _bottom;
    private int _paintingTop;
    private int _paintingBottom;
    private int _pageNo;
    private final int _outerPageWidth;
    private @Nullable PageDimensions _pageDimensions;
    private final @NonNull PageInfo _pageInfo;
    private final @Nullable MarginAreaContainer[] _marginAreas = new MarginAreaContainer[MARGIN_AREA_DEFS.length];
    private @Nullable Element _metadata;

    public PageBox(PageInfo pageInfo, CssContext cssContext, CalculatedStyle style) {
        this._pageInfo = pageInfo;
        this._style = style;
        this._outerPageWidth = this.getWidth(cssContext);
    }

    public int getWidth(CssContext cssCtx) {
        return this.getPageDimensions(cssCtx).width();
    }

    public int getHeight(CssContext cssCtx) {
        return this.getPageDimensions(cssCtx).height();
    }

    @CheckReturnValue
    private PageDimensions getPageDimensions(CssContext cssCtx) {
        if (this._pageDimensions == null) {
            this._pageDimensions = this.resolvePageDimensions(cssCtx);
        }
        return this._pageDimensions;
    }

    @CheckReturnValue
    private PageDimensions resolvePageDimensions(CssContext cssCtx) {
        CalculatedStyle style = this.getStyle();
        int width = style.isLength(CSSName.FS_PAGE_WIDTH) ? style.getIntPropertyProportionalTo(CSSName.FS_PAGE_WIDTH, 0.0f, cssCtx) : this.resolveAutoPageWidth(cssCtx);
        int height = style.isLength(CSSName.FS_PAGE_HEIGHT) ? style.getIntPropertyProportionalTo(CSSName.FS_PAGE_HEIGHT, 0.0f, cssCtx) : this.resolveAutoPageHeight(cssCtx);
        return style.isIdent(CSSName.FS_PAGE_ORIENTATION, IdentValue.LANDSCAPE) ? new PageDimensions(height, width) : new PageDimensions(width, height);
    }

    private boolean isUseLetterSize() {
        Locale l = Locale.getDefault();
        String county = l.getCountry();
        return county.equals("US") || county.equals("CA") || county.equals("MX");
    }

    private int resolveAutoPageWidth(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "8.5in", 8.5f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "210mm", 210.0f, (short)7, 0.0f, cssCtx);
    }

    private int resolveAutoPageHeight(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "11in", 11.0f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "297mm", 297.0f, (short)7, 0.0f, cssCtx);
    }

    public int getContentHeight(CssContext cssCtx) {
        int height = this.getHeight(cssCtx) - this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.TOP) - this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.BOTTOM);
        if (height <= 0) {
            throw new IllegalArgumentException("The content height cannot be zero or less.  Check your document margin definition.");
        }
        return height;
    }

    public int getContentWidth(CssContext cssCtx) {
        int width = this.getWidth(cssCtx) - this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.LEFT) - this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.RIGHT);
        if (width <= 0) {
            throw new IllegalArgumentException("The content width cannot be zero or less.  Check your document margin definition.");
        }
        return width;
    }

    public CalculatedStyle getStyle() {
        return this._style;
    }

    public int getBottom() {
        return this._bottom;
    }

    public int getTop() {
        return this._top;
    }

    public void setTopAndBottom(CssContext cssCtx, int top) {
        this._top = top;
        this._bottom = top + this.getContentHeight(cssCtx);
    }

    public int getPaintingBottom() {
        return this._paintingBottom;
    }

    public void setPaintingBottom(int paintingBottom) {
        this._paintingBottom = paintingBottom;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public Rectangle getScreenPaintingBounds(CssContext cssCtx, int additionalClearance) {
        return new Rectangle(additionalClearance, this.getPaintingTop(), this.getWidth(cssCtx), this.getPaintingBottom() - this.getPaintingTop());
    }

    public Rectangle getPrintPaintingBounds(CssContext cssCtx) {
        return new Rectangle(0, 0, this.getWidth(cssCtx), this.getHeight(cssCtx));
    }

    @CheckReturnValue
    public Rectangle getPagedViewClippingBounds(CssContext cssCtx, int additionalClearance) {
        return new Rectangle(additionalClearance + this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.LEFT), this.getPaintingTop() + this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.TOP), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
    }

    @CheckReturnValue
    public Rectangle getPrintClippingBounds(CssContext cssCtx) {
        return new Rectangle(this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.LEFT), this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.TOP), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx) - 1);
    }

    @CheckReturnValue
    public RectPropertySet getMargin(CssContext cssCtx) {
        return this.getStyle().getMarginRect(this._outerPageWidth, cssCtx);
    }

    @CheckReturnValue
    private Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        return new Rectangle(left + (int)margin.left(), top + (int)margin.top(), this.getWidth(cssCtx) - (int)margin.left() - (int)margin.right(), this.getHeight(cssCtx) - (int)margin.top() - (int)margin.bottom());
    }

    public void paintBorder(RenderingContext c, int additionalClearance, Layer.PagedMode mode) {
        int top = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Layer.PagedMode.PAGED_MODE_SCREEN -> this.getPaintingTop();
            case Layer.PagedMode.PAGED_MODE_PRINT -> 0;
        };
        c.getOutputDevice().paintBorder(c, this.getStyle(), this.getBorderEdge(additionalClearance, top, c), 15);
    }

    public void paintBackground(RenderingContext c, int additionalClearance, Layer.PagedMode mode) {
        Rectangle bounds = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Layer.PagedMode.PAGED_MODE_SCREEN -> this.getScreenPaintingBounds(c, additionalClearance);
            case Layer.PagedMode.PAGED_MODE_PRINT -> this.getPrintPaintingBounds(c);
        };
        c.getOutputDevice().paintBackground(c, this.getStyle(), bounds, bounds, this.getStyle().getBorder(c));
    }

    public void paintMarginAreas(RenderingContext c, int additionalClearance, Layer.PagedMode mode) {
        for (int i = 0; i < MARGIN_AREA_DEFS.length; ++i) {
            MarginAreaContainer container = this._marginAreas[i];
            if (container == null) continue;
            TableBox table = container.table();
            Point p = container.area().getPaintingPosition(c, this, additionalClearance, mode);
            c.getOutputDevice().translate(p.x, p.y);
            table.getLayer().paint(c);
            c.getOutputDevice().translate(-p.x, -p.y);
        }
    }

    public int getPageNo() {
        return this._pageNo;
    }

    public void setPageNo(int pageNo) {
        this._pageNo = pageNo;
    }

    public int getOuterPageWidth() {
        return this._outerPageWidth;
    }

    public int getMarginBorderPadding(CssContext cssCtx, CalculatedStyle.Edge edge) {
        return this.getStyle().getMarginBorderPadding(cssCtx, this.getOuterPageWidth(), edge);
    }

    public PageInfo getPageInfo() {
        return this._pageInfo;
    }

    @CheckReturnValue
    public @Nullable Element getMetadata() {
        return this._metadata;
    }

    public void layout(LayoutContext c) {
        c.setPage(this);
        this.retrievePageMetadata(c);
        this.layoutMarginAreas(c);
    }

    private void retrievePageMetadata(LayoutContext c) {
        List<PropertyDeclaration> props = this.getPageInfo().getXMPPropertyList();
        if (props != null && !props.isEmpty()) {
            for (PropertyDeclaration decl : props) {
                BlockBox metadata;
                FSFunction func;
                PropertyValue funcVal;
                if (!decl.getCSSName().equals(CSSName.CONTENT)) continue;
                PropertyValue value = (PropertyValue)decl.getValue();
                List values = value.getValues();
                if (values.size() != 1 || (funcVal = (PropertyValue)values.get(0)).getPropertyValueType() != PropertyValue.Type.VALUE_TYPE_FUNCTION || !BoxBuilder.isElementFunction(func = funcVal.getFunction()) || (metadata = BoxBuilder.getRunningBlock(c, funcVal)) == null) break;
                this._metadata = metadata.getElement();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutMarginAreas(LayoutContext c) {
        RectPropertySet margin = this.getMargin(c);
        for (int i = 0; i < MARGIN_AREA_DEFS.length; ++i) {
            MarginArea area = MARGIN_AREA_DEFS[i];
            Dimension dim = area.getLayoutDimension(c, this, margin);
            TableBox table = BoxBuilder.createMarginTable(c, this._pageInfo, area.getMarginBoxNames(), (int)dim.getHeight(), area.getDirection());
            if (table == null) continue;
            table.setContainingBlock(new MarginBox(new Rectangle((int)dim.getWidth(), (int)dim.getHeight())));
            try {
                c.setNoPageBreak(1);
                c.reInit(false);
                c.pushLayer(table);
                c.getRootLayer().addPage(c);
                table.layout(c);
                c.popLayer();
            }
            finally {
                c.setNoPageBreak(0);
            }
            this._marginAreas[i] = new MarginAreaContainer(area, table);
        }
    }

    public boolean isLeftPage() {
        return this._pageNo % 2 != 0;
    }

    public boolean isRightPage() {
        return this._pageNo % 2 == 0;
    }

    public void exportLeadingText(RenderingContext c, Writer writer) throws IOException {
        for (int i = 0; i < 5; ++i) {
            MarginAreaContainer container = this._marginAreas[i];
            if (container == null) continue;
            container.table().exportText(c, writer);
        }
    }

    public void exportTrailingText(RenderingContext c, Writer writer) throws IOException {
        for (int i = 5; i < this._marginAreas.length; ++i) {
            MarginAreaContainer container = this._marginAreas[i];
            if (container == null) continue;
            container.table().exportText(c, writer);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class MarginArea {
        private final MarginBoxName[] _marginBoxNames;

        public abstract Dimension getLayoutDimension(CssContext var1, PageBox var2, RectPropertySet var3);

        @CheckReturnValue
        public abstract Point getPaintingPosition(RenderingContext var1, PageBox var2, int var3, Layer.PagedMode var4);

        private MarginArea(MarginBoxName marginBoxName) {
            this._marginBoxNames = new MarginBoxName[]{marginBoxName};
        }

        private MarginArea(MarginBoxName[] marginBoxNames) {
            this._marginBoxNames = marginBoxNames;
        }

        public MarginBoxName[] getMarginBoxNames() {
            return this._marginBoxNames;
        }

        public BoxBuilder.MarginDirection getDirection() {
            return BoxBuilder.MarginDirection.HORIZONTAL;
        }
    }

    private record MarginAreaContainer(MarginArea area, TableBox table) {
    }

    private record PageDimensions(int width, int height) {
    }

    private static final class TopLeftCorner
    extends MarginArea {
        private TopLeftCorner() {
            super(MarginBoxName.TOP_LEFT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingTop();
                case Layer.PagedMode.PAGED_MODE_PRINT -> 0;
            };
            return new Point(additionalClearance, top);
        }
    }

    private static final class TopMarginArea
    extends MarginArea {
        private TopMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.TOP_LEFT, MarginBoxName.TOP_CENTER, MarginBoxName.TOP_RIGHT});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension(page.getContentWidth(c), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int left = additionalClearance + (int)page.getMargin(c).left();
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingTop();
                case Layer.PagedMode.PAGED_MODE_PRINT -> 0;
            };
            return new Point(left, top);
        }
    }

    private static final class TopRightCorner
    extends MarginArea {
        private TopRightCorner() {
            super(MarginBoxName.TOP_RIGHT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.right(), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int left = additionalClearance + page.getWidth(c) - (int)page.getMargin(c).right();
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingTop();
                case Layer.PagedMode.PAGED_MODE_PRINT -> 0;
            };
            return new Point(left, top);
        }
    }

    private static final class LeftMarginArea
    extends MarginArea {
        private LeftMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.LEFT_TOP, MarginBoxName.LEFT_MIDDLE, MarginBoxName.LEFT_BOTTOM});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), page.getContentHeight(c));
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingTop() + (int)page.getMargin(c).top();
                case Layer.PagedMode.PAGED_MODE_PRINT -> (int)page.getMargin(c).top();
            };
            return new Point(additionalClearance, top);
        }

        @Override
        public BoxBuilder.MarginDirection getDirection() {
            return BoxBuilder.MarginDirection.VERTICAL;
        }
    }

    private static final class RightMarginArea
    extends MarginArea {
        private RightMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.RIGHT_TOP, MarginBoxName.RIGHT_MIDDLE, MarginBoxName.RIGHT_BOTTOM});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), page.getContentHeight(c));
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int left = additionalClearance + page.getWidth(c) - (int)page.getMargin(c).right();
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingTop() + (int)page.getMargin(c).top();
                case Layer.PagedMode.PAGED_MODE_PRINT -> (int)page.getMargin(c).top();
            };
            return new Point(left, top);
        }

        @Override
        public BoxBuilder.MarginDirection getDirection() {
            return BoxBuilder.MarginDirection.VERTICAL;
        }
    }

    private static final class BottomLeftCorner
    extends MarginArea {
        private BottomLeftCorner() {
            super(MarginBoxName.BOTTOM_LEFT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingBottom() - (int)page.getMargin(c).bottom();
                case Layer.PagedMode.PAGED_MODE_PRINT -> page.getHeight(c) - (int)page.getMargin(c).bottom();
            };
            return new Point(additionalClearance, top);
        }
    }

    private static final class BottomMarginArea
    extends MarginArea {
        private BottomMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.BOTTOM_LEFT, MarginBoxName.BOTTOM_CENTER, MarginBoxName.BOTTOM_RIGHT});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension(page.getContentWidth(c), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int left = additionalClearance + (int)page.getMargin(c).left();
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingBottom() - (int)page.getMargin(c).bottom();
                case Layer.PagedMode.PAGED_MODE_PRINT -> page.getHeight(c) - (int)page.getMargin(c).bottom();
            };
            return new Point(left, top);
        }
    }

    private static final class BottomRightCorner
    extends MarginArea {
        private BottomRightCorner() {
            super(MarginBoxName.BOTTOM_RIGHT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.right(), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c, PageBox page, int additionalClearance, Layer.PagedMode mode) {
            int left = additionalClearance + page.getWidth(c) - (int)page.getMargin(c).right();
            int top = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Layer.PagedMode.PAGED_MODE_SCREEN -> page.getPaintingBottom() - (int)page.getMargin(c).bottom();
                case Layer.PagedMode.PAGED_MODE_PRINT -> page.getHeight(c) - (int)page.getMargin(c).bottom();
            };
            return new Point(left, top);
        }
    }
}

