/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.ButtonField;
import org.xhtmlrenderer.simple.extend.form.CheckboxField;
import org.xhtmlrenderer.simple.extend.form.FileField;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.HiddenField;
import org.xhtmlrenderer.simple.extend.form.ImageField;
import org.xhtmlrenderer.simple.extend.form.PasswordField;
import org.xhtmlrenderer.simple.extend.form.RadioButtonField;
import org.xhtmlrenderer.simple.extend.form.ResetField;
import org.xhtmlrenderer.simple.extend.form.SelectField;
import org.xhtmlrenderer.simple.extend.form.SubmitField;
import org.xhtmlrenderer.simple.extend.form.TextAreaField;
import org.xhtmlrenderer.simple.extend.form.TextField;

public class FormFieldFactory {
    private FormFieldFactory() {
    }

    public static @Nullable FormField create(XhtmlForm form, LayoutContext context, BlockBox box) {
        Element e = Objects.requireNonNull(box.getElement());
        String typeKey = FormFieldFactory.getTypeKey(e);
        if (typeKey == null) {
            return null;
        }
        return switch (typeKey) {
            case "submit" -> new SubmitField(e, form, context, box);
            case "reset" -> new ResetField(e, form, context, box);
            case "button" -> new ButtonField(e, form, context, box);
            case "image" -> new ImageField(e, form, context, box);
            case "hidden" -> new HiddenField(e, form, context, box);
            case "password" -> new PasswordField(e, form, context, box);
            case "checkbox" -> new CheckboxField(e, form, context, box);
            case "radio" -> new RadioButtonField(e, form, context, box);
            case "file" -> new FileField(e, form, context, box);
            case "textarea" -> new TextAreaField(e, form, context, box);
            case "select" -> new SelectField(e, form, context, box);
            default -> new TextField(e, form, context, box);
        };
    }

    private static @Nullable String getTypeKey(Element e) {
        return switch (e.getNodeName()) {
            case "input" -> e.getAttribute("type");
            case "textarea" -> "textarea";
            case "select" -> "select";
            default -> null;
        };
    }
}

