/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.Java2DFontContext;
import org.xhtmlrenderer.swing.Java2DOutputDevice;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.ImageUtil;
import org.xml.sax.SAXException;

public class Java2DRenderer {
    private static final int DEFAULT_HEIGHT = 1000;
    private static final int DEFAULT_DOTS_PER_POINT = 1;
    private static final int DEFAULT_DOTS_PER_PIXEL = 1;
    private static final int DEFAULT_IMAGE_TYPE = 1;
    private final SharedContext sharedContext;
    private Java2DOutputDevice outputDevice;
    private @Nullable Document doc;
    private @Nullable Box root;
    private BufferedImage outputImage;
    private final int bufferedImageType;
    private boolean rendered;
    private @Nullable String sourceDocument;
    private @Nullable String sourceDocumentBase;
    private final int width;
    private final int height;
    private static final int NO_HEIGHT = -1;

    public Java2DRenderer(String url, String baseUrl, int width, int height) {
        this(url, baseUrl, width, height, 1);
    }

    public Java2DRenderer(String url, String baseUrl, int width, int height, int bufferedImageType) {
        this(width, height, bufferedImageType);
        this.sourceDocument = url;
        this.sourceDocumentBase = baseUrl;
    }

    public Java2DRenderer(File file, int width, int height) throws IOException {
        this(file.toURI().toURL().toExternalForm(), width, height);
    }

    public Java2DRenderer(Document doc, int width, int height) {
        this(width, height, 1);
        this.doc = doc;
    }

    public Java2DRenderer(Document doc, int width) {
        this(doc, width, -1);
    }

    public Java2DRenderer(Document doc, String baseUrl, int width, int height) {
        this(doc, width, height);
        this.sourceDocumentBase = baseUrl;
    }

    public Java2DRenderer(File file, int width) throws IOException {
        this(file.toURI().toURL().toExternalForm(), width, -1);
    }

    public static Java2DRenderer fromFile(File file, int width, int bufferedImageType) throws IOException {
        String url = file.toURI().toURL().toExternalForm();
        return new Java2DRenderer(url, url, width, -1, bufferedImageType);
    }

    public Java2DRenderer(String url, int width) {
        this(url, url, width, -1);
    }

    public Java2DRenderer(String url, String baseurl, int width) {
        this(url, baseurl, width, -1);
    }

    public Java2DRenderer(String url, int width, int height) {
        this(url, url, width, height);
    }

    public SharedContext getSharedContext() {
        return this.sharedContext;
    }

    public BufferedImage getImage() {
        if (!this.rendered) {
            this.setDocument(this.doc == null ? this.loadDocument(this.sourceDocument) : this.doc, this.sourceDocumentBase, new XhtmlNamespaceHandler());
            this.layout(this.width);
            int height = this.height == -1 ? this.root.getHeight() : this.height;
            this.outputImage = this.createBufferedImage(this.width, height);
            this.outputDevice = new Java2DOutputDevice(this.outputImage);
            ImageUtil.withGraphics(this.outputImage, newG -> {
                RenderingContext rc = this.sharedContext.newRenderingContextInstance(this.outputDevice, new Java2DFontContext((Graphics2D)newG));
                this.sharedContext.getTextRenderer().setup(rc.getFontContext());
                this.root.getLayer().paint(rc);
            });
            this.rendered = true;
        }
        return this.outputImage;
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        BufferedImage image = ImageUtil.createCompatibleBufferedImage(width, height, this.bufferedImageType);
        ImageUtil.clearImage(image);
        return image;
    }

    private void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this.doc = doc;
        this.sharedContext.reset();
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this.sharedContext.getCss().flushStyleSheets();
        } else {
            this.sharedContext.getCss().flushAllStyleSheets();
        }
        this.sharedContext.setBaseURL(url);
        this.sharedContext.setNamespaceHandler(nsh);
        this.sharedContext.getCss().setDocumentContext(this.sharedContext, this.sharedContext.getNamespaceHandler(), doc, new NullUserInterface());
    }

    private void layout(int width) {
        Rectangle rect = new Rectangle(0, 0, width, 1000);
        this.sharedContext.setTemporaryCanvas(rect);
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox(c, this.doc);
        root.setContainingBlock(new ViewportBox(rect));
        root.layout(c);
        this.root = root;
    }

    private Document loadDocument(String uri) {
        return this.sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    private LayoutContext newLayoutContext() {
        Java2DFontContext fontContext = new Java2DFontContext(this.outputDevice.getGraphics());
        LayoutContext result = this.sharedContext.newLayoutContextInstance(fontContext);
        this.sharedContext.getTextRenderer().setup(fontContext);
        return result;
    }

    private Java2DRenderer(int width, int height, int bufferedImageType) {
        this.width = width;
        this.height = height;
        this.bufferedImageType = bufferedImageType;
        this.outputImage = ImageUtil.createCompatibleBufferedImage(1, 1);
        this.outputDevice = new Java2DOutputDevice(this.outputImage);
        this.sharedContext = new SharedContext(new NaiveUserAgent(), 72.0f, 1);
        this.sharedContext.setPrint(false);
        this.sharedContext.setInteractive(false);
    }

    public static BufferedImage htmlAsImage(String html, int widthInPixels) throws SAXException {
        BufferedImage bufferedImage;
        ByteArrayInputStream in = new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8));
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            bufferedImage = new Java2DRenderer(document, widthInPixels).getImage();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)in).close();
        return bufferedImage;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        @Override
        public boolean isHover(Element e) {
            return false;
        }

        @Override
        public boolean isActive(Element e) {
            return false;
        }

        @Override
        public boolean isFocus(Element e) {
            return false;
        }
    }
}

