/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.util.XRLog;

public class IOUtil {
    public static void copyFile(File page, File outputDir) throws IOException {
        File outputFile = new File(outputDir, page.getName());
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));){
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(page.toPath(), new OpenOption[0]));){
                IOUtil.copyBytes(in, out);
            }
            ((OutputStream)out).flush();
        }
    }

    private static void copyBytes(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public static void deleteAllFiles(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.delete()) continue;
                throw new IOException("Cleanup directory " + dir + ", can't delete file " + file);
            }
        }
    }

    public static @Nullable InputStream openStreamAtUrl(String uri) {
        try {
            URLConnection uc = new URL(uri).openConnection();
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(30000);
            uc.setRequestProperty("Accept", "*/*");
            uc.connect();
            return uc.getInputStream();
        }
        catch (MalformedURLException e) {
            XRLog.exception("bad URL given: " + uri, e);
        }
        catch (FileNotFoundException e) {
            XRLog.exception("item at URI " + uri + " not found (caused by: " + e + ")");
        }
        catch (IOException e) {
            XRLog.exception("IO problem for " + uri, e);
        }
        return null;
    }

    @CheckReturnValue
    public static @Nullable InputStream getInputStream(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new BufferedInputStream(new URL(uri).openStream());
        }
        catch (MalformedURLException e) {
            XRLog.exception("bad URL given: " + uri, e);
        }
        catch (FileNotFoundException e) {
            XRLog.exception("item at URI " + uri + " not found (caused by: " + e + ")");
        }
        catch (IOException e) {
            XRLog.exception("IO problem for " + uri, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    public static byte @Nullable [] readBytes(String uri) {
        try (InputStream is = IOUtil.getInputStream(uri);){
            if (is == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = IOUtil.readBytes(is);
            return byArray;
        }
        catch (IOException e) {
            XRLog.load(Level.WARNING, "Unable to read " + uri, e);
            return null;
        }
    }

    @CheckReturnValue
    public static byte[] readBytes(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            byte[] byArray = IOUtil.readBytes(is);
            return byArray;
        }
    }

    @CheckReturnValue
    public static byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(is.available());
        IOUtil.copyBytes(is, result);
        return result.toByteArray();
    }

    @Deprecated
    public static void close(@Nullable Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

