/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.css.extend.AttributeResolver;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.extend.UserInterface;

@ParametersAreNonnullByDefault
public class StandardAttributeResolver
implements AttributeResolver {
    private final NamespaceHandler nsh;
    private final UserAgentCallback uac;
    private final UserInterface ui;
    private final Map<Node, String> classAttributeCache = new IdentityHashMap<Node, String>();

    public StandardAttributeResolver(NamespaceHandler nsh, UserAgentCallback uac, UserInterface ui) {
        this.nsh = nsh;
        this.uac = uac;
        this.ui = ui;
    }

    @Override
    public String getAttributeValue(Node e, String attrName) {
        return this.nsh.getAttributeValue((Element)e, attrName);
    }

    @Override
    public String getAttributeValue(Node e, String namespaceURI, String attrName) {
        return this.nsh.getAttributeValue((Element)e, namespaceURI, attrName);
    }

    @Override
    public String getClass(Node e) {
        return this.classAttributeCache.computeIfAbsent(e, x -> this.nsh.getClass((Element)e));
    }

    @Override
    public String getID(Node e) {
        return this.nsh.getID((Element)e);
    }

    @Override
    public String getNonCssStyling(Node e) {
        return this.nsh.getNonCssStyling((Element)e);
    }

    @Override
    public String getElementStyling(Node e) {
        return this.nsh.getElementStyling((Element)e);
    }

    @Override
    public String getLang(Node e) {
        return this.nsh.getLang((Element)e);
    }

    @Override
    public boolean isLink(Node e) {
        return this.nsh.getLinkUri((Element)e) != null;
    }

    @Override
    public boolean isVisited(Node e) {
        return this.isLink(e) && this.uac.isVisited(this.nsh.getLinkUri((Element)e));
    }

    @Override
    public boolean isHover(Node e) {
        return this.ui.isHover((Element)e);
    }

    @Override
    public boolean isActive(Node e) {
        return this.ui.isActive((Element)e);
    }

    @Override
    public boolean isFocus(Node e) {
        return this.ui.isFocus((Element)e);
    }
}

