/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xhtmlrenderer.util.FSImageWriter;

public class ImageRenderer {
    public static final int DEFAULT_WIDTH = 1024;

    public static BufferedImage renderToImage(String url, String path, int width) throws IOException {
        return ImageRenderer.renderImageToOutput(url, path, width);
    }

    public static BufferedImage renderToImage(String url, String path, int width, int height) throws IOException {
        return ImageRenderer.renderImageToOutput(url, path, width);
    }

    public static BufferedImage renderToImage(File inFile, String path, int width) throws IOException {
        return ImageRenderer.renderToImage(inFile.toURI().toURL().toExternalForm(), path, width);
    }

    public static BufferedImage renderToImage(File inFile, String path, int width, int height) throws IOException {
        return ImageRenderer.renderToImage(inFile.toURI().toURL().toExternalForm(), path, width, height);
    }

    private static BufferedImage renderImageToOutput(String url, String path, int width) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
            Java2DRenderer renderer = new Java2DRenderer(url, url, width);
            BufferedImage image = renderer.getImage();
            new FSImageWriter().write(image, os);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
    }

    public static void main(String[] args) throws IOException {
        String url;
        if (args.length != 1) {
            ImageRenderer.usage("Incorrect argument list.");
        }
        if (!(url = args[0]).contains("://")) {
            File f = new File(url);
            if (f.exists()) {
                Object output = f.getAbsolutePath();
                output = ((String)output).substring(0, ((String)output).lastIndexOf(46)) + ".png";
                System.out.println("Saving image to " + (String)output);
                ImageRenderer.renderToImage(f, (String)output, 1024);
            } else {
                ImageRenderer.usage("File to render is not found: " + url);
            }
        } else {
            File out = File.createTempFile("fs", ".png");
            System.out.println("Saving image to " + out.getAbsolutePath());
            ImageRenderer.renderToImage(url, out.getAbsolutePath(), 1024);
        }
    }

    private static void usage(String err) {
        if (err != null && !err.isEmpty()) {
            System.err.println("==>" + err);
        }
        System.err.println("Usage: ... [url]");
        System.exit(1);
    }
}

